
weighted_sum_errors <- function(object, ...) UseMethod("weighted_sum_errors")

weighted_sum_errors.expectreg <- function(object, ...) {
    #if(class(object)[1]=="expectreg"){
        w_object <- matrix(object$asymmetries , nrow=nrow(object$fitted)        , ncol=length(object$asymmetries) , byrow=T)
        w_object <- abs(w_object - 1*(object$response < object$fitted))
        wse      <- colSums(w_object*(object$response - object$fitted)^2)
#         }
#     if(class(object)[1]=="rq" || class(object)[1]=="rqs"){
#         w_object <- matrix(object$tau         , nrow=length(object$y) , ncol=length(object$tau)         , byrow=T)
#         w_object <- abs(w_object - 1*(object$y < object$fitted.values))
#         wse      <- colSums(w_object*abs(object$y - object$fitted.values))
#         }
    wse
    }



OCV <- function(object, ...) UseMethod("OCV")

OCV.expectreg <- function(object, ...)
{
    if(inherits(object,"boost") || inherits(object,"noncross"))
      stop("OCV only available for least squares methods.")
	w = matrix(object$asymmetries,nrow=length(object$response),ncol=length(object$asymmetries),byrow=T)
    w = abs(w - 1*(object$response < object$fitted))
	
    colMeans(w*(object$response - object$fitted)^2/(1-object$diag.hatma)^2)
}

GCV <- function(object, ...) UseMethod("GCV")

GCV.expectreg <- function(object, ...)
{
    if(inherits(object,"boost") || inherits(object,"noncross"))
      stop("OCV only available for least squares methods.")
	w = matrix(object$asymmetries,nrow=length(object$response),ncol=length(object$asymmetries),byrow=T)
    w = abs(w - 1*(object$response < object$fitted))
    
	colMeans(w*(object$response - object$fitted)^2)/(1-(1+colSums(object$diag.hatma))/length(object$response))^2 

}

CV_Score <- function(object, ...) UseMethod("CV_Score")

CV_Score.expectreg <- function(object, N_CV=5, ...) {
    Numbers <- Sample_Numbers(N_CV1=N_CV,n_ges1=nrow(object$data))
#    cat("1 ")
    Score <- rep(NA,times = N_CV)
    Score_matrix <- matrix(NA,nrow = N_CV,ncol=length(object$asymmetries))
#    cat("2 \n")
    for(g in 1:N_CV) {
#        cat("g: ", g,"   ")
        StartModel <- expectreg.ls(formula = object$formula, expectiles=object$asymmetries, 
                                   data=object$data[Numbers[[2]][[g]],], estimate = class(object)[2], 
                                   smooth = object$smooth_orig, ci = FALSE, lambda = 1)   
#        cat("a " )
        name_response <- as.character(object$formula)[2]
        
        PredModel <- predict(object=StartModel,newdata=object$data[Numbers[[1]][[g]],])                           
#        cat("b " )
        w_Model <- matrix(object$asymmetries, nrow=nrow(object$data[Numbers[[1]][[g]],]), ncol=length(object$asymmetries) , byrow=T)
        w_Model2 <- abs(w_Model - 1*(object$data[Numbers[[1]][[g]],name_response] < PredModel$fitted))
        # Commutated summation order due to weighting  
#        cat("c " )
        Score_matrix[g,] <- colMeans(w_Model2 * abs(object$data[Numbers[[1]][[g]],name_response] - PredModel$fitted)^2)   
        Score[g] <- mean(Score_matrix[g,])   
#        cat("d \n" )
        }
    ScoreStartModel <- mean(Score)
    ScoreStartModelMatrix <- colMeans(Score_matrix)
    list("score_all"=ScoreStartModel,"score_vec"=ScoreStartModelMatrix)
    }

Scoring_Score <- function(object, ...) UseMethod("Scoring_Score")

Scoring_Score.expectreg <- function(object, N_CV=5,grid_alpha=50,weight=1,interval=c(-1,2), ...) {
    grid_goodness <- seq(from=1/grid_alpha, to=(1-1/grid_alpha), by=1/grid_alpha)
    weight_vector  <- rep(1,times=length(grid_goodness))
    weight_vector[grid_goodness > min(interval) & grid_goodness < max(interval)] <- weight_vector[grid_goodness > min(interval) & grid_goodness < max(interval)] * weight
    weight_vector <- weight_vector/sum(weight_vector)
#    cat("1 ")
        
    Numbers <- Sample_Numbers(N_CV1=N_CV,n_ges1=nrow(object$data))
#    cat("2 \n")
    Score <- rep(NA,times = N_CV)
    Score_matrix <- matrix(NA,nrow = N_CV,ncol=length(grid_goodness))
    for(g in 1:N_CV) {
#        cat("g: ", g,"   ")
        StartModel <- expectreg.ls(formula = object$formula, expectiles=grid_goodness, data=object$data[Numbers[[2]][[g]],], 
                                   estimate = class(object)[2], smooth = object$smooth_orig, ci = FALSE, lambda = 1)   
#        cat("a " )
        name_response <- as.character(object$formula)[2]
        
        PredModel <- predict(object=StartModel,newdata=object$data[Numbers[[1]][[g]],])                           
#        cat("b " )
        w_Model <- matrix(grid_goodness, nrow=nrow(object$data[Numbers[[1]][[g]],]), ncol=length(grid_goodness) , byrow=T)
        w_Model2 <- abs(w_Model - 1*(object$data[Numbers[[1]][[g]],name_response] < PredModel$fitted))
        # Commutated summation order due to weighting  
#        cat("c " )
        Score_matrix[g,] <- colMeans(w_Model2 * abs(object$data[Numbers[[1]][[g]],name_response] - PredModel$fitted)^2)   
        Score[g] <- sum(Score_matrix[g,]*weight_vector)   
#        cat("d \n" )
        }
    ScoreStartModel <- mean(Score)
    ScoreStartModelMatrix <- colMeans(Score_matrix)
    names(ScoreStartModelMatrix) <- grid_goodness
    list("score_all"=ScoreStartModel,"score_vec"=ScoreStartModelMatrix)
    }

AIC_Area_Score <- function(object, ...) UseMethod("AIC_Area_Score")

AIC_Area_Score.expectreg <- function(object, k=2, grid_alpha=50,weight=1,interval=c(-1,2), ...) {
    grid_goodness <- seq(from=1/grid_alpha, to=(1-1/grid_alpha), by=1/grid_alpha)
    weight_vector  <- rep(1,times=length(grid_goodness))
    weight_vector[grid_goodness > min(interval) & grid_goodness < max(interval)] <- weight_vector[grid_goodness > min(interval) & grid_goodness < max(interval)] * weight
    weight_vector <- weight_vector/sum(weight_vector)
    
    StartModel <- update(object, expectiles=grid_goodness)
    Score_matrix <- AIC(StartModel,k=k)   
    Score <- sum(Score_matrix*weight_vector)   
    
    ScoreStartModel <- Score
    ScoreStartModelMatrix <- Score_matrix
    names(ScoreStartModelMatrix) <- grid_goodness
    list("score_all"=ScoreStartModel,"score_vec"=ScoreStartModelMatrix)
    }



stepExpect <- function(object, ...) UseMethod("stepExpect")

stepExpect.expectreg <- function(object, 
                                 scope = NULL, 
                                 split = c("no","complete","restricted"), 
                                 type = c("separately","jointly"),
                                 criterion = c("AIC","BIC","OCV","GCV","CV"), 
                                 k = 2, 
                                 N_CV = 5,
                                 grid_alpha = 50, 
                                 weight = 1, 
                                 interval = c(-1, 2), 
                                 direction = c("forward","backward","both"), 
                                 delta = 1e-05, 
                                 trace = FALSE, 
                                 lambda = 1, 
                                 output_type = c("one_model","list_models"), 
                                 ...) {
    
#     dot_in <- list(...)
#     output_type <- NULL
#     if(!is.null(dot_in) && length(dot_in) > 0 && "output_type" %in% names(dot_in)) {
#         output_type <- dot_in$output_type
#     }
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    criterion <- match.arg(criterion)
    split     <- match.arg(split)
    direction <- match.arg(direction)
    
    type <- match.arg(type)
    
    if(type == "separately") {
        result <- stepExpect_separately(object = object, scope = scope, output_type = output_type, 
                           trace = trace, lambda = lambda, direction = direction, delta = delta,
                           criterion = criterion,k = k, N_CV = N_CV, split = split)  
    }
    if(type == "jointly") {
        result <- stepExpect_jointly(object = object, scope = scope, output_type = output_type, 
                           trace = trace, lambda = lambda, direction = direction, delta = delta,
                           grid_alpha = grid_alpha, weight = weight, interval = interval, 
                           criterion = criterion, k = k, N_CV = N_CV, split = split)  
    }
    result
}


garroteExpect <- function(object, ...) UseMethod("garroteExpect")

garroteExpect.expectreg <- function(object, 
                                    scope = NULL,
                                    split = c("no","complete","restricted"), 
                                    type = c("separately","jointly"),
                                    N_CV = 5,
                                    grid_alpha = 50, 
                                    grid_gamma = 50, 
                                    fix_gamma = NULL, 
                                    start_gamma = 1e-04,
                                    delta_min = 2.5e-16, 
                                    trace = FALSE, 
                                    lambda = 1, 
                                    output_type = c("one_model_delta", "list_models_delta","one_model","list_models"), 
                                    ...) {
    
#     dot_in <- list(...)
#     output_type <- NULL
#     if(!is.null(dot_in) && length(dot_in) > 0 && "output_type" %in% names(dot_in)) {
#         output_type <- dot_in$output_type
#     }
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    
    split     <- match.arg(split)
     
    type <- match.arg(type)
    
    if(type == "separately") {
        result <- garroteExpect_separately(object=object, scope = scope, output_type = output_type, 
                            trace = trace, lambda = lambda, N_CV = N_CV, 
                            grid_gamma = grid_gamma, delta_min = delta_min, fix_gamma = fix_gamma, 
                            start_gamma = start_gamma, split = split) 
    }
    if(type == "jointly") {
        result <- garroteExpect_grid(object=object, scope = scope, output_type = output_type, 
                            trace = trace, lambda = lambda, N_CV = N_CV, 
                            grid_alpha = grid_alpha, grid_gamma = grid_gamma, delta_min = delta_min, fix_gamma = fix_gamma,
                            start_gamma = start_gamma, split = split) 
    }
    result
}

bestExpect <- function(object, ...) UseMethod("bestExpect")


bestExpect.expectreg <- function(object, 
                                 scope = NULL, 
                                 split = c("no","complete","restricted"),
                                 criterion = c("AIC","BIC","OCV","GCV","CV"), 
                                 k = 2, 
                                 N_CV = 5, 
                                 trace = FALSE, 
                                 lambda = 1, 
                                 output_type = c("one_model","list_models"), 
                                 ...) {
    
#     dot_in <- list(...)
#     output_type <- NULL
#     if(!is.null(dot_in) && length(dot_in) > 0 && "output_type" %in% names(dot_in)) {
#         output_type <- dot_in$output_type
#     }
    
    output_type <- match.arg(output_type, several.ok = TRUE)

    criterion <- match.arg(criterion, several.ok = FALSE)
    split     <- match.arg(split)
     
    
    if("CV" %in% criterion & length(criterion) > 1) {
        stop("CV is only a single procedure.")
    }
    
    if(length(criterion) == 1 & criterion == "CV") {
        result <- bestCV_separately(object = object, scope = scope, output_type = output_type, 
                              trace = trace, lambda = lambda, N_CV = N_CV, 
                              split = split) 

    }
#     if(is.null(criterion)) {
#        result <- bestAIC_separately(object = object, scope = scope, output_type = output_type, 
#                                trace = trace, lambda = lambda, criterion = criterion, k = k, 
#                                split = split) 
#     }
    if(all(criterion %in% c("AIC","BIC","OCV","GCV"))) {
        result <- bestAIC_separately(object = object, scope = scope, output_type = output_type, 
                                trace = trace, lambda = lambda, criterion = criterion, k = k, 
                                split = split) 
     }
    result
}
