plot.expectreg_selected <- function(x, rug = TRUE, xlab = NULL, ylab = NULL, ylim = NULL,
                                    legend = TRUE, ci = FALSE, ask = NULL, cex.main = 2, 
                                    mar.min = 5, main = NULL, cols = "rainbow", 
                                    hcl.par = list(h=c(260,0), c=185, l=c(30,85)), 
                                    ylim_spat = NULL, ylim_factor = NULL, 
                                    range_warning = TRUE, add_intercept = TRUE, 
                                    type = c("one_model","list_models","one_model_delta","list_models_delta"),
                                    ... ) {
    op_save <- par(no.readonly = TRUE)
    
    #print("plot.expectreg_selected is not completely tested! It may crash for unknown reasons!")
    type <- match.arg(type)
    
    #if(class(x) != "expectreg_selected") {stop("Only for class expectreg_selected")}
    names_x <- names(x)
    list_models <- NULL
    one_model <- NULL
    ind_plot1 <- FALSE
    ind_plot2 <- FALSE
    if(type == "one_model") {
        if("one_model" %in% names_x) {
            one_model <- x$one_model
            ind_plot1 <- TRUE
        } else {
            if("list_models" %in% names_x) {
                ind_plot2 <- TRUE
                list_models <- x$list_models
                warning("type is changed to list_models")
            } else {
                if("one_model_delta" %in% names_x){
                    one_model <- x$one_model_delta
                    ind_plot1 <- TRUE
                    warning("type is changed to one_model_delta")
                } else {
                    if("list_models_delta" %in% names_x) {
                        ind_plot2 <- TRUE
                        list_models <- x$list_models_delta
                        warning("type is changed to list_models_delta")
                    } else {
                        stop("plot(type = 'one_model' is not possible, since one_model is no part of x")
                    }
                }
            }
        }
    }
    
    if(type == "one_model_delta") {
        if("one_model_delta" %in% names_x) {
            one_model <- x$one_model_delta
            ind_plot1 <- TRUE
        } else {
            if("list_models_delta" %in% names_x) {
                ind_plot2 <- TRUE
                list_models <- x$list_models_delta
                warning("type is changed to list_models_delta")
            } else {
                if("one_model" %in% names_x){
                    one_model <- x$one_model
                    ind_plot1 <- TRUE
                    warning("type is changed to one_model")
                } else {
                    if("list_models" %in% names_x) {
                        ind_plot2 <- TRUE
                        list_models <- x$list_models
                        warning("type is changed to list_models")
                    } else {
                        stop("plot(type = 'one_model_delta' is not possible, since one_model_delta is no part of x")
                    }
                }
            }
        }
    }
    
    if(type == "list_models") {
        if("list_models" %in% names_x) {
            list_models <- x$list_models
            ind_plot2 <- TRUE
        } else {
            if("one_model" %in% names_x) {
                ind_plot1 <- TRUE
                one_model <- x$one_model
                warning("type is changed to one_model")
            } else {
                if("list_models_delta" %in% names_x){
                    list_models <- x$list_models_delta
                    ind_plot2 <- TRUE
                    warning("type is changed to list_models_delta")
                } else {
                    if("one_model_delta" %in% names_x) {
                        ind_plot1 <- TRUE
                        one_model <- x$one_model_delta
                        warning("type is changed to one_model_delta")
                    } else {
                        stop("plot(type = 'list_models' is not possible, since list_models is no part of x")
                    }
                }
            }
        }
    }
    
    if(type == "list_models_delta") {
        if("list_models_delta" %in% names_x) {
            list_models <- x$list_models_delta
            ind_plot2 <- TRUE
        } else {
            if("one_model_delta" %in% names_x) {
                ind_plot1 <- TRUE
                one_model <- x$one_model_delta
                warning("type is changed to one_model_delta")
            } else {
                if("list_models" %in% names_x){
                    list_models <- x$list_models
                    ind_plot2 <- TRUE
                    warning("type is changed to list_models")
                } else {
                    if("one_model" %in% names_x) {
                        ind_plot1 <- TRUE
                        one_model <- x$one_model
                        warning("type is changed to one_model")
                    } else {
                        stop("plot(type = 'list_models_delta' is not possible, since list_models_delta is no part of x")
                    }
                }
            }
        }
    }
    
    
    if(!ind_plot2 & !ind_plot1) warning("Nothing to plot")
    if(ind_plot2 & ind_plot1) stop("Error in if cases of plot.expectreg_selected")
    
    
    if(ind_plot1){
        plot(one_model, rug=rug, xlab=xlab, ylab=ylab, ylim=ylim, legend=legend,
             ci=ci, ask=ask, cex.main=cex.main, mar.min=mar.min, main=main, cols=cols,
             hcl.par=hcl.par, ylim_spat=ylim_spat,
             ylim_factor=ylim_factor, range_warning=range_warning, 
             add_intercept=add_intercept, ...)
    }
    
    
    
    if(ind_plot2)  {
        
        
        ask <- FALSE
        if(ci)
            warning("no confidence intervals are plotted for type = 'list_models'.")
        
        if(!rug)
            warning("rug only possible for type = 'one_model'.")
        
        rug <- TRUE
        
        number_models <- length(list_models)
        asymmetries_vec <- rep(0,times=number_models)
        for(ii in 1:number_models) {
            if(length(list_models[[ii]]$asymmetries) != 1) {
                stop("no pure separate models")
            }
            asymmetries_vec[ii] <- list_models[[ii]]$asymmetries
        }
        
        if(any(duplicated(asymmetries_vec))) {
            stop("Duplicated asymmetries")
        }
        
        pp = asymmetries_vec
        np_new <- length(pp)
        np <- 1
        
        pp.plot_new <- 1:length(pp)
        np.plot_new <- length(pp.plot_new)
        
        pp.plot <- 1
        np.plot <- length(pp.plot)
        
        col_vector <- rainbow(np.plot_new+1)[1:np.plot_new]
        if(cols == "hcl") {
            col_vector <- diverge_hcl(n=np.plot_new,h=hcl.par$h,c=hcl.par$c,l=hcl.par$l)[1:np.plot_new]
        }
        
        covariates_vec1 <- NULL
        for(ii in 1:number_models) {
            covariates_vec1 <- c(covariates_vec1,names(list_models[[ii]]$coef))
        }
        covariates_vec <- sort(unique(covariates_vec1))
        
        types_matrix <- matrix(NA,nrow=number_models,ncol=length(covariates_vec))
        colnames(types_matrix) <- covariates_vec
        for(ii in 1:number_models) {
            for(kk in 1:length(covariates_vec)) {
                k_number <- which(names(list_models[[ii]]$coef) == covariates_vec[kk])
                if(length(k_number) > 0) {
                    types_matrix[ii,kk] <- list_models[[ii]]$effects[[k_number]]
                }
            }
        }
        types_vec <- rep(NA,times=length(covariates_vec))
        for(kk in 1:length(covariates_vec)) {
            temp_types_vec <- unique(types_matrix[!is.na(types_matrix[,kk]),kk])
            if(length(temp_types_vec) == 1) {
                types_vec[kk] <- temp_types_vec
            }
        }
        
        names(types_vec) <- colnames(types_matrix)
        
        #print(types_matrix)
        #print(types_vec)
        if(is.null(xlab)) {
            xlab = covariates_vec
        } else { 
            if(length(xlab) < length(covariates_vec)) {
                xlab = rep(xlab[1],length(covariates_vec))
            }
        }
        
        ylim2 <- ylim
        if(is.null(ylim)) {
            ylim2 <- range(list_models[[1]]$response)
        }    
        
        ylim3 <- ylim_factor
        ylim_fact <- NULL
        min_fact <- NA
        max_fact <- NA
        for(ii in 1:number_models) {
            for(kk in 1:length(list_models[[ii]]$covariates)) {
                if(is.factor(list_models[[ii]]$covariates[[kk]]) && list_models[[ii]]$effects[[kk]] == "parametric") {
                    mina <- min(list_models[[ii]]$coefficients[[kk]])
                    maxa <- max(list_models[[ii]]$coefficients[[kk]])
                    min_fact <- min(c(min_fact,mina),na.rm=T)
                    max_fact <- max(c(max_fact,maxa),na.rm=T)
                }
            }
        }
        ylim_fact <- c(min_fact,max_fact)
        if(is.null(ylim_factor)){
            ylim3 <- ylim_fact
        }
        
        bnd <- NA
        for(ii in 1:number_models) {
            for(kk in 1:length(list_models[[ii]]$covariates)) {
                if(list_models[[ii]]$bases[[kk]]$type == "markov"){
                    bnd <- list_models[[ii]]$bases[[kk]]$bnd
                }
            }
        }
        
        ind_50 <- 1
        if(0.5 %in% asymmetries_vec) { ind_50 <- which(asymmetries_vec == 0.5)}
        intercept_50 <- list_models[[ind_50]]$intercept
        
        if(!add_intercept) {
            intercept_50[] <- 0
        }
        
        for(kk in 1:length(covariates_vec)){
            if(!is.na(types_vec[kk])) {
                #cat("\n",covariates_vec[kk])
                main2 <- main
                if(!is.null(main)) {
                    if(length(main) > length(covariates_vec)) {
                        main2 <- NULL
                    }
                    if(length(main) == length(covariates_vec)) {
                        main2 <- main[kk]
                    }
                    if(length(main) == 1) {
                        main2 <- main
                    }
                }
                first_plot <- 0
                for(ii in 1:number_models) {
                    #cat(asymmetries_vec[ii], " ")
                    x <- list_models[[ii]]
                    if(!inherits(x,"boost")) {
                        #cat("2 ")
                        k_number <- which(names(x$coef) == covariates_vec[kk])
                        if(length(k_number) > 0) {
                            #cat("3 ")
                            yy = x$response
                            if(is.null(ylab))
                                ylab = attr(yy,"name")
                            
                            cov = x$covariates
                            Z = x$values
                            coefficients = x$coefficients
                            formula = x$formula
                            intercept = x$intercepts
                            m = length(yy)
                            types = x$effects
                            helper = x$helper
                            nb <- vector()
                            for(k1 in 1:length(x$bases)) {
                                nb[k1] = ncol(x$bases[[k_number]]$B)
                            }
                            partbasis = (sum(nb[0:(k_number-1)])+1):(sum(nb[0:k_number]))
                            
                            intercept2 <- intercept
                            if(!add_intercept) intercept2[] <- 0
                            
                            if(types_vec[kk] == "pspline" || types_vec[kk] == "penalizedpart_pspline") {
                                first_plot <- first_plot + 1
                                
                                ndat = data.frame(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100))
                                names(ndat) = names(cov)[k_number]
                                Bpred = predict(x$bases[[k_number]],ndat)
                                ZZZ = Bpred %*% coefficients[[k_number]]
                                #                         if(only_pen) { 
                                #                             ZZZ = Bpred[,-(1)] %*% coefficients[[k_number]][-(1),]
                                #                             }
                                #                         if(only_unp) { 
                                #                             ZZZ = Bpred[,1,drop=F] %*% coefficients[[k_number]][1,]
                                #                             }
                                #       
                                #print(str(ZZZ))
                                #cat("\n")
                                ZZZ[,1] = ZZZ[,1] + intercept2[1]
                                
                                #cat("ii: ", ii, " ")
                                if(first_plot == 1) {
                                    par(op_save)
                                    matplot(cov[[k_number]],Z[[k_number]],type="n",xlab=xlab[kk], ylab=ylab,ylim=ylim2,main=main2)
                                    rug(cov[[k_number]])
                                    #abline(h=0)
                                    #abline(v=mean(range((cov[[k_number]]))))
                                }
                                
                                matlines(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100), ZZZ[,1] - intercept_50, col=col_vector[ii], lty=1,lwd=2)
                                
                            } # End if(pspline)
                            ###################### markov ##################################################                    
                            if(types_vec[kk] == "markov") {
                                first_plot <- first_plot + 1
                                        
                                z = NULL
                                Zspathelp = helper[[k_number]][[2]]
                                bnd = helper[[k_number]][[1]]
                                
                                if(inherits(x,"boost"))
                                {
                                    warning("no plot possible") 
                                }
                                else
                                {
                                    #z = z - mean(z)
                                    
                                    z = matrix(NA,nrow=nrow(Zspathelp),ncol=np)
                                    if(ci)
                                    {
                                        warning("no ci plotting available")
                                    }
                                    else
                                    {
                                        regions <- data.frame(x = rownames(x$bases[[k_number]]$P_orig))
                                        colnames(regions) <- x$bases[[k_number]]$xname_orig
                                        rownames(x$bases[[k_number]]$P_orig)
                                        
                                        coefficients_markov <- predict(x$bases[[k_number]],regions)
                                        z <- coefficients_markov %*% x$coefficients[[k_number]]
                                        
                                    }
                                    
                                    
                                    if(class(bnd) != "bnd")
                                    {
                                        if(!is.na(bnd)){
                                            if(is.numeric(cov[[k_number]])) {
                                                if(first_plot == 1) {
                                                    par(op_save)
                                                    plot(seq(0,1.1*max(cov[[k_number]]),length=10), seq(0,max(z[,pp.plot]),length=10), 
                                                     type = "n", xlab = "District", ylab = "coefficients", main=main2, ...)
                                                }
                                                matpoints(rep(as.numeric(attr(bnd,"regions")),times=np),z[,pp.plot],col=col_vector[ii])
                                            }
                                        }
                                        if(is.na(bnd)){
                                            if(is.numeric(cov[[k_number]])) {
                                                if(first_plot == 1) {
                                                    par(op_save)
                                                    plot(seq(1.1*min(cov[[k_number]]),1.1*max(cov[[k_number]]),length=10), seq(min(z),max(z),length=10), 
                                                         type = "n", xlab = "District", ylab = "coefficients", main=main2, ...)
                                                    }
                                                matpoints((unique(cov[[k_number]])), z, col = col_vector[ii], pch = 19, cex = 1)
                                            }
                                            if(is.factor(cov[[k_number]])) {
                                                if(first_plot == 1) {
                                                par(op_save)
                                                plot(seq(0, 1.1 * length(levels(cov[[k_number]])), length = 10), 
                                                     seq(min(z), max(z), length = 10), type = "n", 
                                                     xlab = "District", ylab = "coefficients", main=main2, ...)
                                            }
                                                matpoints(1:length(levels(cov[[k_number]])), z, col = col_vector[ii], pch = 19, cex = 1)
                                            }
                                        }
                                    }
                                    else
                                    {
                                        #split.screen(c(3,4))
                                        #par(mfrow=(c(row.grid,col.grid)))
                                        if(is.null(ylim_spat)) {
                                            plot.limits = range(z)
                                        } else {
                                            plot.limits <- ylim_spat
                                        }
                                        
                                        for(i1 in 1:np.plot) 
                                        {
                                            #screen(i1)
                                            #n = as.numeric(attr(bnd[[k_number]],"regions"))
                                            #re = unique(Z[[k_number]][,i1])
                                            re = data.frame(attr(bnd,"regions"),z[,pp.plot[i1]])
                                            drawmap(re,bnd,regionvar=1,plotvar=2,limits=plot.limits,
                                                    main=pp[ii],swapcolors=TRUE,legend=legend,
                                                    cex.legend=1.5,cols = "grey",mar.min=mar.min,
                                                    cex.main=cex.main)
                                            if((min(z) < plot.limits[1] || max(z) > plot.limits[2]) && range_warning) {
                                                mtext(paste("Range wider than ylim. Range: ",min(z), " , " , max(z)))
                                            }
                                        }
                                        #close.screen(all = TRUE)
                                        
                                    }
                                }
                            }# End if(markov)
                            ################################################################################                    
                            if(types_vec[kk] == "2dspline")
                            {
                                if(inherits(x,"boost"))
                                {
                                    warning("no plot possible for boost") 
                                }
                                else
                                {
                                    gitter = 20
                                    x.min = apply(cov[[k_number]],2,min,na.rm=TRUE)
                                    x.max = apply(cov[[k_number]],2,max,na.rm=TRUE)
                                    x.gitter = cbind(rep(seq(x.min[1],x.max[1],length=gitter),times=gitter),rep(seq(x.min[2],x.max[2],length=gitter),each=gitter))
                                    
                                    ndat = as.data.frame(x.gitter)
                                    
                                    names(ndat) = rep(xlab[kk],2)
                                    B.gitter = predict(x$bases[[k_number]],ndat)
                                    
                                    #B.gitter = rb(x.gitter,"2dspline")[[1]]
                                    
                                    #par(mfrow=(c(row.grid,col.grid)))
                                    for(i1 in 1:np)
                                    {
                                        if(i1 %in% pp.plot)
                                        {
                                            z <- B.gitter %*% coefficients[[k_number]][,i1]# + intercept[i1]
                                            
                                            
                                            if(ci)
                                            {
                                                #lower = matrix(NA,nrow=400,ncol=np)
                                                #upper = matrix(NA,nrow=400,ncol=np)
                                                
                                                for(nn in 1:nrow(B.gitter))
                                                {
                                                    deviation = qnorm(0.975) * sqrt(t(c(1,B.gitter[nn,])) %*% x$covmat[[i1]][c(1,partbasis+1),c(1,partbasis+1)] %*% c(1,B.gitter[nn,]))
                                                    #lower[nn,i1] = ZZZ[nn,i1] - deviation
                                                    #upper[nn,i1] = ZZZ[nn,i1] + deviation
                                                    z[nn] = 1*((z - deviation) > 0) - 1*((z + deviation) < 0)
                                                }
                                                z = t(matrix(z,nrow=gitter,ncol=gitter))
                                                
                                                image(seq(x.min[1],x.max[1],length=gitter),seq(x.min[2],x.max[2],length=gitter),z,zlim=range(z),main=pp[pp.plot[i1]])
                                            }
                                            else
                                            {
                                                
                                                z = t(matrix(z,nrow=gitter,ncol=gitter))
                                                
                                                plot.limits = range(z,na.rm=TRUE)
                                                
                                                if(is.null(ylim_spat)) {
                                                    ylim2 = plot.limits
                                                    
                                                } else {
                                                    ylim2 <- ylim_spat
                                                }
                                                
                                                persp(seq(x.min[1],x.max[1],length=gitter),seq(x.min[2],x.max[2],length=gitter),z,
                                                      ticktype="detailed",phi=40,theta=35,zlim=ylim2,col = "lightblue",
                                                      xlab = names(cov[[k_number]])[1], ylab = names(cov[[k_number]])[2], zlab = ylab,main=pp[ii])
                                                if((min(z) < plot.limits[1] || max(z) > plot.limits[2]) && range_warning) {
                                                    mtext(paste("Range wider than ylim. Range: ",min(z), " , " , max(z)))
                                                }
                                            }
                                        }
                                    }
                                    
                                }      
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "radial")
                            {
                                if(inherits(x,"boost"))
                                {
                                    warning("no plot possible for boost") 
                                    
                                }
                                else
                                {
                                    gitter = 20
                                    x.min = apply(cov[[k_number]],2,min)
                                    x.max = apply(cov[[k_number]],2,max)
                                    x.gitter = cbind(rep(seq(x.min[1],x.max[1],length=gitter),times=gitter),rep(seq(x.min[2],x.max[2],length=gitter),each=gitter))
                                    
                                    cov[[k_number]] = cov[[k_number]][order(cov[[k_number]][,1]),]
                                    #knots = unique(cov[[k_number]])
                                    #knots = knots[seq(1,nrow(knots),length=min(50,nrow(knots))),]
                                    knots = helper[[k_number]]
                                    B.gitter = matrix(NA,nrow=dim(x.gitter)[1],ncol=dim(knots)[1])
                                    
                                    #for(i1 in 1:dim(x.gitter)[1])
                                    #for(j in 1:dim(knots)[1])
                                    #{
                                    #  r = sqrt(sum((x.gitter[i1,] - knots[j,])^2))
                                    #  B.gitter[i1,j] = r^2*log(r)
                                    #}
                                    #for(i1 in 1:dim(x.gitter)[1])
                                    for(j in 1:dim(knots)[1])
                                    {
                                        r = sqrt(rowSums((x.gitter - matrix(unlist(knots[j,]),nrow=nrow(x.gitter),ncol=ncol(knots),byrow=T))^2))
                                        r[r==0] = 1
                                        #r = sqrt(sum((x.gitter[i1,] - knots[j,])^2)
                                        B.gitter[,j] = r^2*log(r)
                                    }
                                    
                                    #par(mfrow=(c(row.grid,col.grid)))
                                    for(i1 in 1:np)
                                    {
                                        if(i1 %in% pp.plot)
                                        {
                                            z <- B.gitter %*% coefficients[[k_number]][,i1] + intercept2[i1]
                                            z = t(matrix(z,nrow=gitter,ncol=gitter))
                                            
                                            plot.limits = range(cbind(yy,z),na.rm=TRUE)
                                            
                                            if(is.null(ylim_spat)) {
                                                ylim2 = plot.limits
                                            } else {
                                                ylim2 <- ylim_spat
                                            }
                                            
                                            persp(seq(x.min[1],x.max[1],length=gitter),seq(x.min[2],x.max[2],length=gitter),z,
                                                  ticktype="detailed",phi=40,theta=35,zlim=ylim2,col = "lightblue",
                                                  xlab = names(cov[[k_number]])[1], ylab = names(cov[[k_number]])[2], zlab = ylab,main=pp[ii])
                                            if((min(z) < plot.limits[1] || max(z) > plot.limits[2]) && range_warning) {
                                                mtext(paste("Range wider than ylim. Range: ",min(z), " , " , max(z)))
                                            }
                                        }
                                    }
                                }
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "krig")
                            {
                                gitter = 20
                                krig.phi = helper[[k_number]][[1]]
                                x.min = apply(cov[[k_number]],2,min)
                                x.max = apply(cov[[k_number]],2,max)
                                x.gitter = cbind(rep(seq(x.min[1],x.max[1],length=gitter),times=gitter),rep(seq(x.min[2],x.max[2],length=gitter),each=gitter))
                                
                                cov[[k_number]] = cov[[k_number]][order(cov[[k_number]][,1]),]
                                #knots = unique(cov[[k_number]])
                                #knots = knots[seq(1,nrow(knots),length=min(50,nrow(knots))),]
                                knots = helper[[k_number]][[2]]
                                #knots = cov[[k_number]][seq(1,dim(cov[[k_number]])[1],length=min(50,dim(cov[[k_number]])[1])),]
                                B.gitter = matrix(NA,nrow=dim(x.gitter)[1],ncol=dim(knots)[1])
                                
                                #for(i1 in 1:dim(x.gitter)[1])
                                for(j in 1:dim(knots)[1])
                                {
                                    r = sqrt(rowSums((x.gitter - matrix(unlist(knots[j,]),nrow=nrow(x.gitter),ncol=ncol(knots),byrow=T))^2))/krig.phi
                                    #r = sqrt(sum((x.gitter[i1,] - knots[j,])^2))/krig.phi
                                    B.gitter[,j] = exp(-r)*(1+r)
                                }
                                
                                #par(mfrow=(c(row.grid,col.grid)))
                                for(i1 in 1:np)
                                {
                                    if(i1 %in% pp.plot)
                                    {
                                        z <- B.gitter %*% coefficients[[k_number]][,i1] + intercept2[i1]
                                        z = t(matrix(z,nrow=gitter,ncol=gitter))
                                        
                                        plot.limits = range(cbind(yy,z),na.rm=TRUE)
                                        
                                        if(is.null(ylim_spat)) {
                                            ylim2 = plot.limits
                                        } else {
                                            ylim2 <- ylim_spat
                                        }
                                        
                                        persp(seq(x.min[1],x.max[1],length=gitter),seq(x.min[2],x.max[2],length=gitter),z,
                                              ticktype="detailed",phi=40,theta=35,zlim=ylim2,col = "lightblue",
                                              xlab = names(cov[[k_number]])[1], ylab = names(cov[[k_number]])[2], zlab = ylab,main=pp[ii])
                                        if((min(z) < plot.limits[1] || max(z) > plot.limits[2]) && range_warning) {
                                            mtext(paste("Range wider than ylim. Range: ",min(z), " , " , max(z)))
                                        }
                                    }
                                }
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "random")
                            {
                                if(inherits(x,"boost"))
                                {
                                    warning("no plot possible for boost") 
                                }
                                else
                                {
                                    first_plot <- first_plot + 1
                                    if(first_plot == 1) {
                                        par(op_save)
                                        plot(seq(0,1.1*max(cov[[k_number]]),length=10), seq(0,max(coefficients[[k_number]] + intercept2 - intercept2[1]),length=10), type = "n", xlab = xlab[kk], ylab = "coefficients", main=main2)
                                    }
                                    points(rep(sort(unique(cov[[k_number]])),times=np.plot),(coefficients[[k_number]] + intercept2 - intercept2[1])[,pp.plot],col=col_vector)
                                }
                                
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "ridge")
                            {
                                first_plot <- first_plot + 1
                                if(first_plot == 1) {
                                    par(op_save)
                                    plot(seq(0,1.1*dim(cov[[k_number]])[2],length=10), seq(0,max(coefficients[[k_number]] + intercept2 - intercept2[1]),length=10), type = "n", xlab = xlab[kk], ylab = "coefficients", main=main2)
                                }
                                points(rep(1:dim(cov[[k_number]])[2],times=np.plot),(coefficients[[k_number]] + intercept2 - intercept2[1])[,pp.plot],col=col_vector)
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "parametric" && !is.factor(cov[[k_number]]))
                            {
                                #cat(names(coefficients)[k_number],"\n")
                                #print(str(cov[[k_number]]))
                                if(inherits(x,"boost"))
                                {
                                    warning("plot not possible for boost")
                                }
                                else
                                {
                                    first_plot <- first_plot + 1
                                    
                                    if(is.null(ylim) && rug) { ylim2 = range(yy,Z[[k_number]]-intercept_50,na.rm=TRUE)}
                                    if(is.null(ylim) && !rug) { ylim2 = range(yy,Z[[k_number]],na.rm=TRUE)}
                                    
                                    if(!is.vector(cov[[k_number]])) {
                                        for(i1 in 1:ncol(cov[[k_number]]))
                                        {
                                            if(rug)
                                            {
                                                #cat("1 \n" )
                                                if(first_plot == 1) {
                                                    par(op_save)
                                                    matplot(cov[[k_number]][,i1],Z[[k_number]] - intercept_50,type="n",xlab=xlab[kk], ylab=ylab,ylim=range(Z[[k_number]]-intercept_50,na.rm=TRUE), main=main2,...)
                                                    rug(cov[[k_number]][,i1])
                                                }
                                                matlines(cov[[k_number]][,i1], Z[[k_number]][,pp.plot] - intercept_50, col=col_vector[ii], lty=1,lwd=2)
                                            }
                                            else
                                            {
                                                #cat("2 \n" )
                                                #if(first_plot == 1) {
                                                #                                         plot(cov[[k_number]][,i1], yy, cex=0.5, pch=20, col="grey42", xlab=names(cov)[kk], ylab=ylab,ylim=ylim2)
                                                #                                         }
                                                #                                      matlines(sort(cov[[k_number]][,i1]), Z[[k_number]][order(cov[[k_number]][,i1]),pp.plot], col=col_vector, lty=1,lwd=2)
                                            }
                                        }
                                    }
                                    if(is.vector(cov[[k_number]])) {
                                        i1 <- 1
                                        
                                        if(rug)
                                        {
                                            
                                            
                                            ndat = data.frame(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100))
                                            names(ndat) = names(cov)[k_number]
                                            Bpred = predict(x$bases[[k_number]],ndat)
                                            ZZZ = Bpred %*% coefficients[[k_number]]
                                            ZZZ[,1] = ZZZ[,1] + intercept2[1]
                                            
                                            #cat("3 \n")
                                            if(first_plot == 1) {
                                                par(op_save)
                                                matplot(cov[[k_number]],Z[[k_number]],type="n",xlab=xlab[kk], ylab=ylab,ylim=ylim2, main=main2,...)
                                                rug(cov[[k_number]])
                                            }
                                            #print(intercept_50)
                                            matlines(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100), ZZZ[,1] - intercept_50, col=col_vector[ii], lty=1,lwd=2)
                                        }
                                        else
                                        { #cat("4 \n")
                                            
                                            #                                      if(first_plot == 1) {
                                            #                                        plot(cov[[k_number]], yy, cex=0.5, pch=20, col="grey42", xlab=names(cov)[kk], ylab=ylab,ylim=ylim2)
                                            #                                         }
                                            #                                      matlines(sort(cov[[k_number]]), Z[[k_number]][order(cov[[k_number]]),pp.plot], col=col_vector, lty=1,lwd=2)
                                        }
                                        
                                    }
                                }
                            }
                            if(types_vec[[kk]] == "parametric" && is.factor(cov[[k_number]])) { 
                                if(inherits(x,"boost")) {
                                    cat("Sorry factor plot for Boosting not implemented yet.")
                                } else {
                                    first_plot <- first_plot + 1
                                    if(first_plot == 1) {
                                        par(op_save)
                                        plot(rep(1,times=np),coefficients[[k_number]][1,],type="n",col=col_vector[ii],xlim=c(0.75,length(levels(cov[[k_number]]))-(0.75)),pch=19,lwd=2,axes=F,xlab=xlab[kk], ylab=ylab,ylim=ylim3,main=main2)
                                        abline(h=0) 
                                        axis(side=2)
                                        axis(side=1,at=seq(1,length(levels(cov[[k_number]]))-1),labels=levels(cov[[k_number]])[-1],cex=1)
                                        if(!is.null(ylim_factor) & (ylim_fact[1] < ylim_factor[1] || ylim_fact[2] > ylim_factor[2]) && range_warning) {
                                            mtext(paste("Range wider than ylim_factor. Range: ",ylim_fact[1], " , " , ylim_fact[2]))
                                        }
                                    }
                                    points(rep(1,times=np),coefficients[[k_number]][1,],col=col_vector[ii],xlim=c(0.5,length(levels(cov[[k_number]]))),pch=19,lwd=2)
                                    if(length(levels(cov[[k_number]])) > 2) {
                                        for(k1 in 2:(length(levels(cov[[k_number]]))-1)) {
                                            points(rep(k1,times=np),coefficients[[k_number]][k1,],col=col_vector[ii],pch=19,lwd=2)
                                        }
                                    }
                                    
                                    
                                }
                            }
                            ################################################################################                    
                            if(types_vec[kk] == "special")
                            {    
                                
                                if(is.null(ylim))
                                    ylim2 = range(cbind(yy,Z[[k_number]]),na.rm=TRUE)
                                if(first_plot == 1){
                                    par(op_save)
                                    plot(cov[[k_number]], yy, cex=0.5, pch=20, col="grey42", xlab=xlab[kk], ylab=ylab,ylim=ylim2, main=main2,...)
                                }
                                matlines(sort(cov[[k_number]]), Z[[k_number]][order(cov[[k_number]]),pp.plot], col=col_vector, lty=1,lwd=2)
                                if(legend & first_plot == 1)
                                    legend(x="topright", pch=19, cex=1, col=rev(col_vector), legend=rev(pp[pp.plot]), bg="white", bty="n")
                            } # End special
                        } # End if(k_number)
                    } # End if(boost)
                } # End for(list_models)
                
                if(legend && first_plot >= 1 && (types_vec[kk] == "pspline" || types_vec[kk] == "penalizedpart_pspline"))
                    legend(x="topright", pch=19, cex=0.8, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                
                if(legend && first_plot >= 1 && types_vec[kk] == "random")
                    legend(x="right", pch=19, cex=0.8, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                
                if(legend && first_plot >= 1 && types_vec[kk] == "ridge")
                    legend(x="right", pch=19, cex=0.8, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                
                if(legend && first_plot >= 1 && types_vec[kk] == "parametric" && rug)
                    legend(x="topright", pch=19, cex=0.8, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                if(legend && first_plot >= 1 && types_vec[kk] == "markov" & class(bnd) != "bnd")
                    legend(x="right", pch=19, cex=1, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                
                
                
            } # End if(!is.na(types_vec))
        } # End for(covariates_vec)
        
                ## Join penalizedpart_pspline with parametric part if possible
        covariates_prb <- names(types_vec)[types_vec == "penalizedpart_pspline"]
        if(length(covariates_prb) > 0) { 
            for(kkk in 1:length(covariates_prb)){
                kk <- which(covariates_vec == covariates_prb[kkk])
                #cat("\n",covariates_vec[kk])
                main2 <- main
                if(!is.null(main)) {
                    if(length(main) > length(covariates_vec)) {
                        main2 <- NULL
                    }
                    if(length(main) == length(covariates_vec)) {
                        main2 <- main[kk]
                    }
                    if(length(main) == 1) {
                        main2 <- main
                    }
                }
                first_plot <- 0
                for(ii in 1:number_models) {
                    #cat(asymmetries_vec[ii], " ")
                    x <- list_models[[ii]]
                    if(!inherits(x,"boost")) {
                        #cat("2 ")
                        #k_number <- which(names(x$coef) == covariates_vec[kk])
                        short_name <- gsub(pattern="_prb",x=covariates_prb[kkk],replacement="")
                        k_number2 <- NULL
                        k_number3 <- NULL
                        if(short_name %in% names(x$coef)) {
                            kk2 <-  which(names(types_vec) == short_name)
                            k_number2 <- which(names(x$coef) == names(types_vec)[kk2])
                        }
                        long_name <- paste(short_name,"_prb",sep="")
                        if(long_name %in% names(x$coef)) {
                            kk3 <-  which(names(types_vec) == long_name)
                            k_number3 <- which(names(x$coef) == names(types_vec)[kk3])
                        }
                        if(length(k_number2) > 0 || length(k_number3) > 0) {
                            if(length(k_number2) > 0) {
                                k_number <- which(names(x$coef) == short_name)
                            } else {
                                k_number <- which(names(x$coef) == long_name)
                            }
                            
                            #cat("3 ")
                            yy = x$response
                            if(is.null(ylab))
                                ylab = attr(yy,"name")
                            
                            cov = x$covariates
                            Z = x$values
                            coefficients = x$coefficients
                            formula = x$formula
                            intercept = x$intercepts
                            m = length(yy)
                            types = x$effects
                            helper = x$helper
                           
                            intercept2 <- intercept
                            if(!add_intercept) intercept2[] <- 0
                            
                            first_plot <- first_plot + 1
                            ndat = data.frame(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100))
                            names(ndat) = names(cov)[k_number]
                            
                            ZZZ <- intercept[1]  
                            ZZZ2 <- 0
                            ZZZ3 <- 0
                            short_name <- gsub(pattern="_prb",x=names(x$coef)[k_number],replacement="")
                            if(short_name %in% names(x$coef)) {
                                kk2 <-  which(names(types_vec) == short_name)
                                k_number2 <- which(names(x$coef) == covariates_vec[kk2])
                                Bpred2 = predict(x$bases[[k_number2]],ndat)
                                ZZZ2 = Bpred2 %*% coefficients[[k_number2]]
                            xlab_join <- paste(xlab[kk2],"_joined",sep="")
                            }
                            long_name <- paste(short_name,"_prb",sep="")
                            if(long_name %in% names(x$coef)) {
                                kk3 <-  which(names(types_vec) == long_name)
                                k_number3 <- which(names(x$coef) == covariates_vec[kk3])
                                Bpred3 = predict(x$bases[[k_number3]],ndat)
                                ZZZ3 = Bpred3 %*% coefficients[[k_number3]]
                            xlab_join <- paste(xlab[kk3],"_joined",sep="")
                            }
                            ZZZ <-  ZZZ + ZZZ2 + ZZZ3   
                            
                            
                            #cat("ii: ", ii, " ")
                            if(first_plot == 1) {
                                par(op_save)
                                matplot(cov[[k_number]],Z[[k_number]],type="n",xlab=xlab_join, ylab=ylab,ylim=ylim2,main=main2)
                                rug(cov[[k_number]])
                                #abline(h=0)
                                #abline(v=mean(range((cov[[k_number]]))))
                            }
                            
                            matlines(seq(min(cov[[k_number]]),max(cov[[k_number]]),length=100), ZZZ - intercept_50 , col=col_vector[ii], lty=1,lwd=2)
                            
                            ################################################################################                    
                            
                        } # End if(k_number)
                    } # End if(boost)
                } # End for(list_models)
                
                if(legend && first_plot >= 1 && (types_vec[kk] == "pspline" || types_vec[kk] == "penalizedpart_pspline"))
                    legend(x="topright", pch=19, cex=0.8, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
                
            } # End for(covariates_prb)
            }
            
    } # End if ind_plot2
}  # End function 


