\name{garroteExpect}
\alias{garroteExpect}
\alias{garroteExpect.expectreg}
%\alias{garroteExpect_separately}
%\alias{garroteExpect_grid}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Non-negative garrote for expectile regression
}
\description{
Computes non-negative garrote model selection for expectile regression model separately for each asymmetry parameter or jointly on a grid approach.
}
\usage{
\method{garroteExpect}{expectreg}(object, scope = NULL, split = c("no","complete","restricted"), 
    type = c("separately","jointly"), N_CV = 5, grid_alpha = 50, grid_gamma = 50, 
    fix_gamma = NULL, start_gamma = 1e-04, delta_min = 2.5e-16, trace = FALSE, 
    lambda = 1, output_type = c("one_model_delta", "list_models_delta", 
    "one_model", "list_models"), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
 an object of class \code{expectreg}. Required to get the basic information: \code{data}, \code{estimate}, \code{smooth}, \code{expectiles}, ...
}
  \item{scope}{
    defines the range of models evaluated in the model selection. This could be either \code{NULL},  a single formula, or a list of two formulas specifying the upper and lower bound. See the details for how to specify the formulas and how they are used. Covariates specified in the lower bound are not reweighted.
}
  \item{split}{
how to deal with psplines. See details.
}
  \item{type}{
how to deal with the different asymmetry parameters. Either estimate the best model for each asymmetry parameter \code{separately} or \code{jointly}.
}
  \item{N_CV}{
Number of cross validations used to find the optimal penalty parameter gamma. Default is 5.
}
  \item{grid_alpha}{
number of asymmetry parameters used for grid approach. Grid is defined as \code{seq(1/grid_alpha,1-1/grid_alpha,1/grid_alpha)}
}
  \item{grid_gamma}{
number of possible penalty parameters. Grid of gamma is defined as \cr \code{seq(from = start_gamma, to=}number of covariates\code{, by = 1/grid_gamma)}. 
}
  \item{fix_gamma}{
if non-NULL penalty parameter is not estimated. The parameter \code{fix_gamma} is used instead.
}
  \item{start_gamma}{
minimal value for penalty parameter.
}
  \item{delta_min}{
  minimum value of estimated parameters to be different from 0. Estimated parameters smaller than \code{delta_min} are changed to 0. If 0 nothing is changed.
}
  \item{trace}{
 if \code{TRUE}, information about penalty parameter and estimated weighting parameters is printed.
}
  \item{lambda}{
initial value of smoothing parameter for updating \code{expectreg.ls()}. Default is 1.
}
\item{output_type}{
specifies which output should be created. Default is \code{"list_models"}. See value for details.
}
  \item{...}{
}
}
\details{
Estimates the best model via non-negative garrote shrinkage. \cr
Either the aim is to minimize the predicted weighted errors for each asymmetry parameter separately 
\deqn{\sum\limits_{i=1}^n{w_{\tau}(y_i)(y_i - \beta_{0,\tau} - \sum\limits_k{\delta_{k,\tau} \hat{f}_{k,\tau}})^2}}
by finding the optimal \eqn{\delta_{\tau}}, with the constraint
\deqn{\sum\limits_{k}{\delta_{k,\tau}} = \gamma_{\tau}.}
Where \eqn{\gamma_{\tau} <= } \emph{Number of covariates} is called penalization parameter and defines in principle how many covariates are excluded. \eqn{0 <= \delta_{k,\tau} <~ 1} are the so called weighting coefficients and define which covariates are excluded. The best new model is then defined by reweighting the estimated coefficients (and splines) with \eqn{\delta}:
\deqn{\hat{f}^{new}_{k,\tau} = \delta_{k,\tau} \hat{f}_{k,\tau}}

Or the aim is to minimize the predicted weighted errors for all asymmetry parameters jointly: 
\deqn{\sum\limits_{i=1}^n{w_{\tau}(y_i)(y_i - \beta_{0} - \sum\limits_k{\delta_{k} \hat{f}_{k,\tau}})^2}}
by finding the optimal \eqn{\delta}, with the constraint
\deqn{\sum\limits_{k}{\delta_{k}} = \gamma.}
Where \eqn{\gamma <= } \emph{Number of covariates} is called penalization parameter and defines in principle how many covariates are excluded. \eqn{0 <= \delta_{k} <~ 1} are the so called weighting coefficients and define which covariates are excluded. The best new model is then defined by reweighting the estimated coefficients (and splines) with \eqn{\delta}:
\deqn{\hat{f}^{new}_{k,\tau} = \delta_{k} \hat{f}_{k,\tau}}

If \code{scope} is \code{NULL}, then the lower bound is the intercept model and the upper bound is the model given in \code{object}. If \code{code} is a single formula then this is the upper bound and the lower bound is the intercept model. If \code{scope} is a list of two formulae then the first is the upper bound and the second is the lower bound. \cr

For P-splines several approaches for model selection are possible:
\itemize{
    \item{\code{split = "no"} { No special treatment is applied. The input is only checked for inconsitency. Each covariate may only occure once, except if it is the combination of "parametric" and "penalizedpart_pspline". Then both covariates are treated a independent covariates.}}
    \item{\code{split = "restricted"} { For every P-spline two possibilities are evaluated in each step and the better one is used. The two possibilities are the classical linear covariate and the classical P-spline. If one is selected the otherone is not possible anymore. Thus not possible for non-negative garrote.}}
    \item{\code{split = "complete"} { Each P-spline is splitted into its linear trend (\code{rb(..., type = 'parametric')}) and the wiggly deviation of the linear trend \code{rb(..., type = 'penalizedpart_pspline')}. Both parts are used as independent covariates in the model selection. }}
    }

}
\value{
An object of class \code{expectreg_selected}. \cr
A LIST with elements specified in \code{output_type} and anova:
  \item{anova }{A LIST of model selection information:
                \itemize{
                    \item{Four each asymmetry parameter the following information are specified in a LIST:
                        \describe{
                            \item{\code{gamma_values}}{matrix of possible penalty parameters in first row and their MSE in second row}
                            \item{\code{gamma_opt}}{optimal penalty parameter}
                            \item{\code{delta_opt}}{vector of estimated weighting coefficients}
                            \item{\code{best_model}}{Formula of model specified via scope. Covariates with weighting coefficients smaller then \code{delta_min} are excluded.}
                            }
                        }
                    \item{For all asymmetry parameters together the following elements are added to the first level of the anova:
                        \describe{
                            \item{\code{names_selection}}{Names of covariates possible to be excluded.}
                            \item{\code{names_fixed}}{Names of covariates always in the best model (lower bound of scope). Here not reweighted covariates.}
                            \item{\code{table_delta_opt}}{matrix of estimated weighting coefficients.}
                            \item{\code{table_selected}}{matrix of selected covariates. 1 means selected 0 means excluded. Here defined via estimated weighting coefficients.}
                            }
                        }
                    }
                }
  \item{one_model_delta }{Model specified in scope, one model with all asymmetry parameters. The coeffcients are reweighted with the estimated shrinkage parameters.}
  \item{list_models_delta }{LIST of models specified in scope for each asymmetry parameter separately. The coeffcients are reweighted with the estimated shrinkage parameters.}
  \item{one_model }{Model specified in scope, one model with all asymmetry parameters.}
  \item{list_models }{LIST of models specified in scope for each asymmetry parameter separately.}
}
\note{Values of delta smaller than 0 occure due to problems in \code{solve.QP}}
\references{
To be published \cr

Marra G and Wood S (2011)
\emph{ Practical variable selection for generalized additive models }
Computational Statistics and Data Analysis.
}
\author{
Elmar Spiegel
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%%\section{Warning }{\code{output_type = IndexBestModel} needs a lot saving space and is only recommended for small simulations }

\seealso{
 \code{\link{stepExpect}}, \code{\link{bestExpect}}
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.75*x2 + eps

data1 <- data.frame(y, x1, x2, x3)

model1 <- expectreg.ls(y ~ x1 + x2 + x3, data = data1, expectiles = c(0.1,0.5,0.9))

# standard model
set.seed(1)
selected1 <- garroteExpect(model1, trace = TRUE, N_CV=10, grid_gamma = 50)

# change grid for search of best penalty parameter
set.seed(1)
selected2 <- garroteExpect(model1, trace = TRUE, N_CV=10, grid_gamma = 25)

# fix penalty parameter
set.seed(1)
selected3 <- garroteExpect(model1, trace = TRUE, N_CV=10, grid_gamma = 50, fix_gamma = 
                     rep(2.5,times=3))

# Use different scope
model2 <- expectreg.ls(y ~ 1, data = data1, expectiles = c(0.1,0.5,0.9))
scopeA <- y ~ x1 + x2 + x3
scopeB <- list(y ~ x1 + x3, y ~ x3)
scopeC <- list(y ~ x1 + x2, y ~ x3)

set.seed(1)
selectedA <- garroteExpect(model2, scope = scopeA, trace = TRUE)
selectedB <- garroteExpect(model2, scope = scopeB, trace = TRUE)
selectedC <- garroteExpect(model2, scope = scopeC, trace = TRUE)

# Use different selection types for p-splines and make use of cut off value delta_min
scope_rb1 <- y ~ rb(x1, type = 'pspline') + rb(x2, type = 'pspline') + 
                 rb(x3, type = 'pspline')
set.seed(1)
selected_rb1 <- garroteExpect(model2, scope = scope_rb1, trace = TRUE, split = 'complete')
set.seed(1)
selected_rb1 <- garroteExpect(model2, scope = scope_rb1, trace = TRUE, delta_min = 2.5e-10, 
                        split = 'complete')

# joint/grid approach
set.seed(1)
selected1 <- garroteExpect(model1, trace = TRUE, N_CV=10, grid_gamma = 50, type = "jointly")


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
