
estimate_CombiMatrix <- function(names_selection) {
    if(length(names_selection) > 10) {stop("To many covariates")}
    names_selection  <-  names_selection[order(names_selection)]
    NumberOfVariables <- length(names_selection)
    if(NumberOfVariables > 10) {
        stop("Number of possible combinations to large. Use stepwise selection instead")
    }
    
    
    
    Combi_lis  <- list()
    Combi_Matr <- matrix(0, nrow=1, ncol=NumberOfVariables)
    for(u in 1:NumberOfVariables) {
        Combi_temp     <- combinations(NumberOfVariables,u,names_selection,set=F)           # combinations() of Package gtools
        Combi_lis[[u]] <- cbind(Combi_temp, matrix(0, nrow=nrow(Combi_temp), ncol=(NumberOfVariables-ncol(Combi_temp))))
        Combi_Matr     <- rbind(Combi_Matr, Combi_lis[[u]])
    }
    
    Combi_Matr
}

add_fixed_check <- function(names_selection, names_fixed=NULL, name_response="y", 
                              data_in = data_in) {
    
    Combi_Matrix_new  <- estimate_CombiMatrix(names_selection=names_selection)
    List_Combi_new <- list()
    
    ### Determine the possible formula
    if(is.null(names_fixed)) {
        List_Combi_new[[1]]  <- "1"
    }
    if(!is.null(names_fixed)) {
        List_Combi_new[[1]] <- names_fixed
    }
    
    for(k in 2:nrow(Combi_Matrix_new)) {
        List_Combi_new_temp  <- sort(unique(c(Combi_Matrix_new[k,which(Combi_Matrix_new[k,] != 0)], names_fixed)))
        List_Combi_new[[k]]  <- List_Combi_new_temp
    }

    List_Combi_shortname <- List_Combi_new
    
    for(l1 in rev(1:length(List_Combi_new))) {
        remove_l1 <- FALSE
        temp_type       <- rep("u",times=length(List_Combi_new[[l1]]))
        temp_xname_orig <- rep("u",times=length(List_Combi_new[[l1]]))
        for(l2 in 1:length(List_Combi_new[[l1]])) {
            temp_param <- List_Combi_new[[l1]][l2]
            temp_name_split <- strsplit(temp_param,"(",fixed=TRUE)[[1]][1]
            if(temp_name_split == temp_param) {
                temp_param <- paste("rb(",temp_name_split,", type = 'parametric')")
            }
            temp_eval <- eval(parse(text=temp_param),envir=data_in,enclos=environment(formula))
            temp_xname_orig[l2] <- temp_eval$xname_orig
            temp_type[l2]       <- temp_eval$type
            List_Combi_shortname[[l1]][l2] <- temp_eval$xname
        }
        temp_xname_unique <- unique(temp_xname_orig)
        for(u in 1:length(temp_xname_unique)) {
            u1 <- which(temp_xname_orig == temp_xname_unique[u])
            if(length(temp_type[u1]) > 1) {
                if(length(unique(temp_type[u1])) > 1) {
                    if(!identical(sort(temp_type[u1]),sort(c("parametric","penalizedpart_pspline")))) {
                        remove_l1 <- TRUE
                    }
                } else {
                    warning("Building combinations had major error!")
                }
            
            }
        }
    if(remove_l1) {
        List_Combi_new[[l1]] <- NULL 
        List_Combi_shortname[[l1]] <- NULL 
        }
    }
    list("List_Combi_new"=List_Combi_new,"List_Combi_shortname"=List_Combi_shortname)
}

define_AllFormula <- function(names_selection, 
                              names_fixed=NULL,
                              name_response="y",
                              data_in = data_in) {
    Combi_Matrix_new <- estimate_CombiMatrix(names_selection=names_selection)
    List_Combi_new <- add_fixed_check(names_selection=names_selection, names_fixed=names_fixed, name_response=name_response, 
                              data_in = data_in)$List_Combi_new
    
    List_Combi_new <- unique(List_Combi_new)
    
    ### Determine the possible formula
    formular_Combi_new  <- list()
    for(k in 1:length(List_Combi_new)) {
        formular_Combi_new[[k]]  <- as.formula(paste(name_response, " ~ ", paste(List_Combi_new[[k]], collapse=" + "), sep=""),env=.GlobalEnv)
    }
    list(formular_Combi_new,List_Combi_new)
}

define_AllFormula_print <- function(names_selection, names_fixed=NULL,name_response="y", data_in=data_in) {
    
    List_Combi_shortname <- add_fixed_check(names_selection=names_selection, names_fixed=names_fixed, name_response=name_response, 
                              data_in = data_in)$List_Combi_shortname
    max_col <- max(unlist(lapply(List_Combi_shortname,length)))
    
    Combi_Matr <- NULL
    for(u in 1:length(List_Combi_shortname)) {
        Combi_temp     <- matrix(List_Combi_shortname[[u]],nrow=1)
        Combi_lis      <- cbind(Combi_temp, matrix("", nrow=1, ncol=(max_col-length(Combi_temp))))
        Combi_Matr     <- rbind(Combi_Matr, Combi_lis)
    }

   Combi_Matr 
}

estimate_AllModels <- function(data_in, Expect_new = c(0.1), names_selection, names_fixed=NULL, 
                               name_response="y", 
                               lambda_in = lambda_in, estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in) {
    
    AllFormula_1 <- define_AllFormula(names_selection=names_selection, names_fixed=names_fixed,
                                      name_response=name_response, data_in = data_in)[[1]]
    
    Mode_Combi <- list()
    Mode_Combi <- lapply(AllFormula_1, function(x) expectreg.ls(formula = x, data=data_in, expectiles=Expect_new, lambda = lambda_in, 
                                                                    estimate = estimate_in, smooth = smooth_in, ci = ci_in))
    Mode_Combi
}





### function to convert a formula in a sorted and standartised vector of covariates
sort_covariates <- function(Formel) {
    if(class(Formel) == "formula") {  string0 <- as.character(Formel[3])}
    if(is.vector(Formel) & is.character(Formel)) {  string0 <- Formel}
    string1 <- gsub(x = string0 , pattern = "\n",replacement = "")
    string2 <- gsub(x = string1 , pattern = " ",replacement = "")
    if(length(string2) == 1) {
        string3 <- strsplit(x = string2 , split = "+", fixed = T)
        string4 <- sort(string3[[1]]) 
    } else {
        string4 <- sort(string2)
    }
    string5 <- gsub(x = string4 , pattern = "\"",replacement = "'")
    string5
}

### function to standartise vector of covariates
restructure_covariates <- function(Vector_covariates){
    if(class(Vector_covariates) == "formula") {  stop("Only for Character")}
    if(is.vector(Vector_covariates) & is.character(Vector_covariates)) {  string0 <- Vector_covariates}
    string1 <- gsub(x = string0 , pattern = "\n",replacement = "")
    string2 <- gsub(x = string1 , pattern = " ",replacement = "")
    if(length(string2) == 1) {
        string3 <- strsplit(x = string2 , split = "+", fixed = T)
        string4 <- (string3[[1]]) 
    } else {
        string4 <- (string2)
    }
    string5 <- gsub(x = string4 , pattern = "\"",replacement = "'")
    string5
}

NumberOfCombinations <- function(names_selection, xnames_selection=xnames_selection,types_selection, vec_s_type, vec_s_xname_orig) {
    #if(length(names_selection) != length(types_selection)) {stop("length(names_selection) != length(types_selection)")}
    Num1 <- 1
    if(length(names_selection) > 0 ) {
        if(types_selection != "restricted") {
            Num1 <- 2^length(names_selection)
        } else {
            unique_xname_orig <- unique(vec_s_xname_orig)
            
            for(u in unique_xname_orig) {
                indices   <- which(vec_s_xname_orig == u)
                
                if(length(vec_s_type[indices]) == 1) { 
                    Num1 <- Num1*2 
                } else {
                    Num1 <- Num1*3 
                }
            }
        }
    }
    Num1
}




################################################################################
################################################################################
################################################################################




# transpose input so that it can be used by the functions
transpose_input <- function(object,scope=NULL,lambda_transpose=NULL, split=c("no","restricted","complete")) {
    split <- match.arg(split)
    
    # Build 1. Vectors of covariates out of scope
    
    if(!(class(scope) %in% c("NULL","formula","list"))) {
        stop("scope not well defined: \n\r !(class(scope) %in% c('NULL','formula','list'))")
    }
    
    if(class(scope) == "NULL") {
        formula_selection <- upper <- object$formula
        formula_fixed     <- lower <- NULL
    }
    if(class(scope) == "formula") { 
        if(scope[[3]] != ".") {
            formula_selection <- upper <- scope
            formula_fixed     <- lower <- NULL
        }
        if(scope[[3]] == ".") {
            formula_selection <- upper <- object$formula
            formula_fixed     <- lower <- NULL
        }
    }
    
    if(class(scope) == "list" && length(scope) == 1) {
        if(class(scope[[1]]) == "formula" ) { 
            if(scope[[1]][[3]] != ".") {
                formula_selection <- upper <- scope[[1]]
                formula_fixed     <- lower <- NULL
            }
            if(scope[[1]][[3]] == ".") {
                formula_selection <- upper <- object$formula
                formula_fixed     <- lower <- NULL
            }
        }
        if(class(scope[[1]]) != "formula") {
            stop("scope not well defined: \n\r class(scope[[1]]) != 'formula'")
        }
    }
    
    
    if(class(scope) == "list" && length(scope) == 2) {
        if(class(scope[[1]]) == "formula" && ((class(scope[[2]]) == "formula") || (class(scope[[2]]) == "NULL"))) { 
            if(scope[[1]][[3]] != ".") {
                formula_selection <- upper <- scope[[1]]
            }
            if(scope[[1]][[3]] == ".") {
                formula_selection <- upper <- object$formula
            }
            formula_fixed     <- lower <- scope[[2]]
        }
        if(class(scope[[1]]) == "formula" && class(scope[[2]]) == "formula" && as.character(scope[[2]])[3]=="1") { 
            if(scope[[1]][[3]] != ".") {
                formula_selection <- upper <- scope[[1]]
            }
            if(scope[[1]][[3]] == ".") {
                formula_selection <- upper <- object$formula
            }
            formula_fixed     <- lower <- NULL
        }
        if(class(scope[[1]]) != "formula") {
            stop("scope not well defined: \n\r class(scope[[1]]) != 'formula'")
        }
        if(!(class(scope[[2]]) %in% c("formula", "NULL") )) {
            stop("scope not well defined: \n\r !(class(scope[[2]]) %in% ('formula', 'NULL')")
        }
    }
    
    
    # Check if response of scope is the same
    names_selection <- labels(terms(formula_selection))
    name_response_1 <- as.character(formula_selection)[2]
    names_fixed <- NULL
    if(!is.null(formula_fixed)) {
        if(formula_fixed[[3]] == ".") { 
            stop("lower should not be all covariates")
        }
        if(formula_fixed[[3]] == "1") { 
            formula_fixed <- NULL
        }
        if(formula_fixed[[3]] != "1") { 
            names_fixed     <- labels(terms(formula_fixed))
            name_response_2 <- as.character(formula_fixed)[2]
            if(name_response_1 != name_response_2) {stop(paste("names of responses aren't the same: ",name_response_1,"!=", name_response_2))}
        }
    }
    
    
    name_response <- name_response_1
    
    # Get all other information out of object
    if(class(object)[1] == "expectreg") {
        data_in <- object$data
        EQ  <- "E"
        expectiles_in <- object$asymmetries
        estimate_in <- class(object)[2]
        if(is.null(lambda_transpose)) {
            lambda_in <- object$lambda[[1]][1]
        }
        if(!is.null(lambda_transpose)) {
            lambda_in <- lambda_transpose
        }
        smooth_in <- object$smooth_orig
        ci_in <- F
    } else {
        stop("class(object != 'expectreg'")
    }
    
#     if(class(object) == "rq" || class(object) == "rqs") {
#         data_in <- as.data.frame(cbind(object$y,object$x[,-1]))
#         names(data_in) <- names(object$model)
#         EQ  <- "Q"
#         expectiles_in <- object$tau
#         estimate_in <- NULL
#         lambda_in <- NULL
#         smooth_in <- NULL
#         ci_in <- NULL
#     }
    
    
    # Get spline information via rb(...)
    names_selection_old   <- names_selection
    names_selection       <- NULL
    names_fixed_old       <- names_fixed
    names_fixed           <- NULL
    names_selection_short <- NULL
    names_fixed_short     <- NULL
    
    if(length(names_selection_old) < 1) {
        stop("No selection, due to no covariates. Either there are no variables in upper, or all variables are transfered to lower")
    }
    if(length(names_selection_old) == 1) {
        if(names_selection_old == "1") {
            stop("No selection, due to no covariates. Either there are no variables in upper, or all variables are transfered to lower")
        }
    }
    
    
    # testing for not well defined combinations of parameters
    vec_s_xname       <- rep(NA,times=length(names_selection_old))
    vec_s_xname_orig  <- rep(NA,times=length(names_selection_old))
    vec_s_type        <- rep(NA,times=length(names_selection_old))
    vec_s_B_size      <- rep(NA,times=length(names_selection_old))
    
    list_s_xname_orig_orig <- list()
    
    for(i in 1:length(names_selection_old)) {
        zzzzz_A = strsplit(names_selection_old[i],"(",fixed=TRUE)[[1]][1]
        
        if(zzzzz_A == names_selection_old[i]) {
            temp_formula <- paste("rb(",names_selection_old[i],", type = 'parametric')")
            zzzzz = eval(parse(text=temp_formula),envir=data_in,enclos=environment(formula))
        }
        if(zzzzz_A != names_selection_old[i]) {
            zzzzz = eval(parse(text=names_selection_old[i]),envir=data_in,enclos=environment(formula))
        }
        
        if(zzzzz_A != names_selection_old[i]) {
            vec_s_xname      [i] <- zzzzz$xname
        }
        if(zzzzz_A == names_selection_old[i]) {
            vec_s_xname      [i] <- names_selection_old[i]
        }
        vec_s_type       [i] <- zzzzz$type
        vec_s_xname_orig [i] <- zzzzz$xname_orig
        vec_s_B_size     [i] <- zzzzz$B_size
        if(!is.null(attr(zzzzz$x,"dimnames")[[2]])) {
            list_s_xname_orig_orig[[i]] <- attr(zzzzz$x,"dimnames")[[2]]
        } else {
            list_s_xname_orig_orig[[i]] <- zzzzz$xname_orig
            }
    }
    
    vec_f_xname       <- NULL
    vec_f_xname_orig  <- NULL
    vec_f_type        <- NULL
    vec_f_B_size      <- NULL
    
    list_f_xname_orig_orig <- NULL
   
    if(!is.null(names_fixed_old)) {
        list_f_xname_orig_orig <- list()
   
        vec_f_xname       <- rep(NA,times=length(names_fixed_old))
        vec_f_xname_orig  <- rep(NA,times=length(names_fixed_old))
        vec_f_type        <- rep(NA,times=length(names_fixed_old))
        vec_f_B_size      <- rep(NA,times=length(names_fixed_old))
        for(i in 1:length(names_fixed_old)) {
            zzzzz_A = strsplit(names_fixed_old[i],"(",fixed=TRUE)[[1]][1]
            
            if(zzzzz_A == names_fixed_old[i]) {
                temp_formula <- paste("rb(",names_fixed_old[i],", type = 'parametric')")
                zzzzz = eval(parse(text=temp_formula),envir=data_in,enclos=environment(formula))
            }
            if(zzzzz_A != names_fixed_old[i]) {
                zzzzz = eval(parse(text=names_fixed_old[i]),envir=data_in,enclos=environment(formula))
            }
            if(zzzzz_A != names_fixed_old[i]) {
                vec_f_xname      [i] <- zzzzz$xname
            }
            if(zzzzz_A == names_fixed_old[i]) {
                vec_f_xname      [i] <- names_fixed_old[i]
            }
            vec_f_type       [i] <- zzzzz$type
            vec_f_xname_orig [i] <- zzzzz$xname_orig
            vec_f_B_size     [i] <- zzzzz$B_size
            if(!is.null(attr(zzzzz$x,"dimnames")[[2]])) {
                list_f_xname_orig_orig[[i]] <- attr(zzzzz$x,"dimnames")[[2]]
            } else {
                list_f_xname_orig_orig[[i]] <- zzzzz$xname_orig
            }
        }
        
    }
    
    D2Covariates <- c("2dspline","radial","krig")
    for(ccc in D2Covariates) {
    if(ccc %in% vec_s_type) {
        if(length(list_s_xname_orig_orig) > 1) {
            if(any(list_s_xname_orig_orig[[which(vec_s_type == ccc)]] %in% unlist(list_s_xname_orig_orig[[-which(vec_s_type == ccc)]]))) {
                stop("2D covariate and other covariate in model")
            }
        }
        if(length(list_f_xname_orig_orig) > 0){
            if(any(list_s_xname_orig_orig[[which(vec_s_type == ccc)]] %in% unlist(list_f_xname_orig_orig))) {
                stop("2D covariate and other covariate in model")
            }
        }
    } 
    
    if(!is.null(names_fixed_old)){
        if(ccc %in% vec_f_type) {
            if(length(list_f_xname_orig_orig) > 1) {
                if(any(list_f_xname_orig_orig[[which(vec_f_type == ccc)]] %in% unlist(list_f_xname_orig_orig[[-which(vec_f_type == ccc)]]))) {
                    stop("2D covariate and other covariate in model")
                }
            }
            if(length(list_s_xname_orig_orig) > 0){
                if(any(list_f_xname_orig_orig[[which(vec_f_type == ccc)]] %in% unlist(list_s_xname_orig_orig))) {
                    stop("2D covariate and other covariate in model")
                    }
                }
            }    
    }
    }
    # restructure covariates by include split command
    vec_s_xname_new       <- NULL
    vec_s_xname_orig_new  <- NULL
    vec_s_type_new        <- NULL
    vec_s_B_size_new      <- NULL
    
    
    for(i in 1:length(names_selection_old)) {
        if(vec_s_type[i] == "parametric" ) {
            names_selection           <- c(names_selection       , names_selection_old[i])
            names_selection_short     <- c(names_selection_short , names_selection_old[i])
            vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname[i])
            vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i])
            vec_s_type_new            <- c(vec_s_type_new        , vec_s_type[i])
            vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i])
        }
        if(vec_s_type[i] == "penalizedpart_pspline"){
            temp_names <- paste("rb(",vec_s_xname_orig[i], ", '", vec_s_type[i], 
                                "', B_size=", vec_s_B_size[i],")",sep="")
            names_selection           <- c(names_selection       , temp_names)
            names_selection_short     <- c(names_selection_short , paste(vec_s_xname[i],"", sep=""))
            vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname[i])
            vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i])
            vec_s_type_new            <- c(vec_s_type_new        , vec_s_type[i])
            vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i])
        }
        if(vec_s_type[i] == "pspline"){
            if(split == "no" ) {
                temp_names <- paste("rb(",vec_s_xname_orig[i], ", '", vec_s_type[i], 
                                    "', B_size=", vec_s_B_size[i],")",sep="")
                names_selection           <- c(names_selection       , temp_names)
                names_selection_short     <- c(names_selection_short , paste(vec_s_xname_orig[i],"_rb", sep=""))
                vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname[i])
                vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i])
                vec_s_type_new            <- c(vec_s_type_new        , vec_s_type[i])
                vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i])
            }
            if(split == "complete") {
                temp_names2 <- vec_s_xname_orig[i]
                temp_names3 <- paste("rb(",vec_s_xname_orig[i], ", '", "penalizedpart_pspline", 
                                     "', B_size=", vec_s_B_size[i],")",sep="")
                names_selection           <- c(names_selection       , temp_names2         , temp_names3)
                names_selection_short     <- c(names_selection_short , vec_s_xname_orig[i] , paste(vec_s_xname_orig[i],"_prb",sep=""))
                vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname_orig[i] , paste(vec_s_xname_orig[i],"_prb",sep=""))
                vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i] , vec_s_xname_orig[i])
                vec_s_type_new            <- c(vec_s_type_new        , "parametric"        , "penalizedpart_pspline")
                vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i]     , vec_s_B_size[i])
            }
            if(split == "restricted") {
                temp_names2 <- vec_s_xname_orig[i]
                temp_names3 <- paste("rb(",vec_s_xname_orig[i], ", '", "pspline", 
                                     "', B_size=", vec_s_B_size[i],")",sep="")
                names_selection           <- c(names_selection       , temp_names2         , temp_names3)
                names_selection_short     <- c(names_selection_short , vec_s_xname_orig[i] , paste(vec_s_xname_orig[i],"_rb",sep=""))
                vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname_orig[i] , paste(vec_s_xname_orig[i],"_rb",sep=""))
                vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i] , vec_s_xname_orig[i])
                vec_s_type_new            <- c(vec_s_type_new        , "parametric"        , "pspline")
                vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i]     , vec_s_B_size[i])
            }
            
        }
        if(!(vec_s_type[i] == "parametric" || vec_s_type[i] == "pspline" || vec_s_type[i] == "penalizedpart_pspline")) {
            names_selection           <- c(names_selection       , names_selection_old[i])
            names_selection_short     <- c(names_selection_short , vec_s_xname[i])
            vec_s_xname_new           <- c(vec_s_xname_new       , vec_s_xname[i])
            vec_s_xname_orig_new      <- c(vec_s_xname_orig_new  , vec_s_xname_orig[i])
            vec_s_type_new            <- c(vec_s_type_new        , vec_s_type[i])
            vec_s_B_size_new          <- c(vec_s_B_size_new      , vec_s_B_size[i])
        }
    }
    
    vec_s_xname       <- NULL
    vec_s_xname_orig  <- NULL
    vec_s_type        <- NULL
    vec_s_B_size      <- NULL
    
    vec_s_xname       <- vec_s_xname_new
    vec_s_xname_orig  <- vec_s_xname_orig_new
    vec_s_type        <- vec_s_type_new
    vec_s_B_size      <- vec_s_B_size_new
    
    
    
    vec_f_xname_new       <- NULL
    vec_f_xname_orig_new  <- NULL
    vec_f_type_new        <- NULL
    vec_f_B_size_new      <- NULL
    
    if(!is.null(names_fixed_old)) {
        for(i in 1:length(names_fixed_old)) {
            if(vec_f_type[i] == "parametric" ) {
                names_fixed           <- c(names_fixed       , names_fixed_old[i])
                names_fixed_short     <- c(names_fixed_short , names_fixed_old[i])
                vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname[i])
                vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i])
                vec_f_type_new            <- c(vec_f_type_new        , vec_f_type[i])
                vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i])
            }
            if(vec_f_type[i] == "penalizedpart_pspline"){
                temp_names <- paste("rb(",vec_f_xname_orig[i], ", '", vec_f_type[i], 
                                    "', B_size=", vec_f_B_size[i],")",sep="")
                names_fixed           <- c(names_fixed       , temp_names)
                names_fixed_short     <- c(names_fixed_short , paste(vec_f_xname[i],"", sep=""))
                vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname[i])
                vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i])
                vec_f_type_new            <- c(vec_f_type_new        , vec_f_type[i])
                vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i])
            }
            if(vec_f_type[i] == "pspline"){
                if(split == "no" ) {
                    temp_names <- paste("rb(",vec_f_xname_orig[i], ", '", vec_f_type[i], 
                                        "', B_size=", vec_f_B_size[i],")",sep="")
                    names_fixed           <- c(names_fixed       , temp_names)
                    names_fixed_short     <- c(names_fixed_short , paste(vec_f_xname_orig[i],"_rb", sep=""))
                    vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname[i])
                    vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i])
                    vec_f_type_new            <- c(vec_f_type_new        , vec_f_type[i])
                    vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i])
                }
                if(split == "complete") {
                    temp_names2 <- vec_f_xname_orig[i]
                    temp_names3 <- paste("rb(",vec_f_xname_orig[i], ", '", "penalizedpart_pspline", 
                                         "', B_size=", vec_f_B_size[i],")",sep="")
                    names_fixed           <- c(names_fixed       , temp_names2         , temp_names3)
                    names_fixed_short     <- c(names_fixed_short , vec_f_xname_orig[i] , paste(vec_f_xname_orig[i],"_prb",sep=""))
                    vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname_orig[i] , paste(vec_f_xname_orig[i],"_prb",sep=""))
                    vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i] , vec_f_xname_orig[i])
                    vec_f_type_new            <- c(vec_f_type_new        , "parametric"        , "penalizedpart_pspline")
                    vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i]     , vec_f_B_size[i])
                }
                if(split == "restricted") {
                    temp_names2 <- vec_f_xname_orig[i]
                    temp_names3 <- paste("rb(",vec_f_xname_orig[i], ", '", "pspline", 
                                         "', B_size=", vec_f_B_size[i],")",sep="")
                    names_fixed           <- c(names_fixed       , temp_names2         , temp_names3)
                    names_fixed_short     <- c(names_fixed_short , vec_f_xname_orig[i] , paste(vec_f_xname_orig[i],"_rb",sep=""))
                    vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname_orig[i] , paste(vec_f_xname_orig[i],"_rb",sep=""))
                    vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i] , vec_f_xname_orig[i])
                    vec_f_type_new            <- c(vec_f_type_new        , "parametric"        , "pspline")
                    vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i]     , vec_f_B_size[i])
                }
                
            }
            if(!(vec_f_type[i] == "parametric" || vec_f_type[i] == "pspline" || vec_f_type[i] == "penalizedpart_pspline")) {
                names_fixed           <- c(names_fixed       , names_fixed_old[i])
                names_fixed_short     <- c(names_fixed_short , vec_f_xname[i])
                vec_f_xname_new           <- c(vec_f_xname_new       , vec_f_xname[i])
                vec_f_xname_orig_new      <- c(vec_f_xname_orig_new  , vec_f_xname_orig[i])
                vec_f_type_new            <- c(vec_f_type_new        , vec_f_type[i])
                vec_f_B_size_new          <- c(vec_f_B_size_new      , vec_f_B_size[i])
            }
        }
    vec_f_xname       <- NULL
    vec_f_xname_orig  <- NULL
    vec_f_type        <- NULL
    vec_f_B_size      <- NULL
    
    vec_f_xname       <- vec_f_xname_new
    vec_f_xname_orig  <- vec_f_xname_orig_new
    vec_f_type        <- vec_f_type_new
    vec_f_B_size      <- vec_f_B_size_new
    
    } # End check fixed names
    
    
    
    
    # Remove duplicated elements in covariate vectors    
    names_selection_short <- names_selection_short [!duplicated(names_selection)]
    vec_s_xname           <- vec_s_xname           [!duplicated(names_selection)]
    vec_s_xname_orig      <- vec_s_xname_orig      [!duplicated(names_selection)]
    vec_s_type            <- vec_s_type            [!duplicated(names_selection)]
    vec_s_B_size          <- vec_s_B_size          [!duplicated(names_selection)]
    names_selection       <- names_selection       [!duplicated(names_selection)]
    
    if(!is.null(names_fixed)) {
        names_fixed_short     <- names_fixed_short     [!duplicated(names_fixed)]
        vec_f_xname           <- vec_f_xname           [!duplicated(names_fixed)]
        vec_f_xname_orig      <- vec_f_xname_orig      [!duplicated(names_fixed)]
        vec_f_type            <- vec_f_type            [!duplicated(names_fixed)]
        vec_f_B_size          <- vec_f_B_size          [!duplicated(names_fixed)]
        names_fixed           <- names_fixed           [!duplicated(names_fixed)]
    }
    
    
    if(any(names_selection %in% names_fixed)) {
        names_selection_short <- names_selection_short [-which(names_selection %in% names_fixed)]
        vec_s_xname           <- vec_s_xname           [-which(names_selection %in% names_fixed)]
        vec_s_xname_orig      <- vec_s_xname_orig      [-which(names_selection %in% names_fixed)]
        vec_s_type            <- vec_s_type            [-which(names_selection %in% names_fixed)]
        vec_s_B_size          <- vec_s_B_size          [-which(names_selection %in% names_fixed)]
        names_selection       <- names_selection       [-which(names_selection %in% names_fixed)]
    }
    
    
    if(length(names_selection) < 1) {stop("No selection, due to no covariates. Either there are no variables in upper, or all variables are transfered to lower")}
    
    vec_c_xname       <- c(vec_s_xname       ,vec_f_xname)
    vec_c_xname_orig  <- c(vec_s_xname_orig  ,vec_f_xname_orig)
    vec_c_type        <- c(vec_s_type        ,vec_f_type)
    vec_c_B_size      <- c(vec_s_B_size      ,vec_f_B_size)
    
    
    
    unique_xname_orig <- unique(vec_c_xname_orig)
    
    # Catch bad combinations
    if("penalizedpart_pspline" %in% vec_c_type & split == "restricted") {
        stop("Do not combine split = 'restricted', with scope including 'penalizedpart_pspline'.")
    }
    for(u in unique_xname_orig) {
        indices   <- which(vec_c_xname_orig == u)
        indices_s <- which(vec_s_xname_orig == u)
        indices_f <- which(vec_f_xname_orig == u)
        indices_orig   <- which(vec_c_xname_orig == u)
        indices_s_orig <- which(vec_s_xname_orig == u)
        indices_f_orig <- which(vec_f_xname_orig == u)
        
        
        if(length(indices_orig) > 1 ){
            if("penalizedpart_pspline" %in% vec_c_type[indices_orig] & "pspline" %in% vec_c_type[indices_orig]) {
                stop("Do not mix 'pspline' and 'penalizedpart_pspline' in one covariate, if split != 'complete'")
            }
            if("parametric" %in% vec_c_type[indices_orig] & "pspline" %in% vec_c_type[indices_orig] & split != "restricted") {
                stop("Do not mix 'parametric' and 'pspline' in one covariate, if split != 'restricted'.")
            }
            if("parametric" %in% vec_c_type[indices_orig] & "pspline" %in% vec_c_type[indices_orig] & split == "restricted" & 
               !("parametric" %in% vec_s_type[indices_s_orig] & "pspline" %in% vec_s_type[indices_s_orig])) {
                stop("Do not use 'parametric' and 'pspline' in lower, or do not mix 'parametric' and 'pspline' in lower and upper, if split == 'restricted'.")
            }
        }
        
        if(length(unique(vec_c_B_size[indices]))      != 1 && length(unique(vec_c_type[indices])) == 1) {stop("Do not mix different B_size types for one covariate!")} 
        if(length(indices) > 2) {stop("Specification of upper and lower induces colinearity!")}
    }
    
    if(length(names_selection) != length(vec_s_xname) | 
       length(names_selection) != length(vec_s_xname_orig) |
       length(names_selection) != length(names_selection_short)) {
        stop("Major error")
    }
    names_selection        <- names_selection      [order(names_selection_short)]
    vec_s_xname            <- vec_s_xname          [order(names_selection_short)]
    vec_s_xname_orig       <- vec_s_xname_orig     [order(names_selection_short)]
    names_selection_short  <- names_selection_short[order(names_selection_short)]
    
    if(length(names_fixed) > 0) {
    if(length(names_fixed) != length(vec_f_xname) | 
       length(names_fixed) != length(vec_f_xname_orig) | 
       length(names_fixed) != length(names_fixed_short)) {
        stop("Major error")
    }
    names_fixed        <- names_fixed      [order(names_fixed_short)]
    vec_f_xname        <- vec_f_xname      [order(names_fixed_short)]
    vec_f_xname_orig   <- vec_f_xname_orig [order(names_fixed_short)]
    names_fixed_short  <- names_fixed_short[order(names_fixed_short)]
    }
    
    NumberOfVariables  <- length(names_selection)
    
    NumberOfModels     <- NumberOfCombinations(names_selection, xnames_selection=vec_s_xname, types_selection = split, vec_s_type=vec_s_type, vec_s_xname_orig=vec_s_xname_orig)
    
    NumberOfExpectiles <- length(expectiles_in)
    
    formula_selection <- NULL
    formula_fixed <- NULL
    formula_selection <- as.formula(paste(name_response, " ~ ", paste(names_selection, collapse=" + "), sep=""),env=.GlobalEnv)
    if(!is.null(names_fixed)) {
        formula_fixed     <- as.formula(paste(name_response, " ~ ", paste(names_fixed, collapse=" + "), sep=""),env=.GlobalEnv)
    }
    
    #data_in <- data_in[,unique(names(data_in))]
    
    #if((any(vec_s_split_orig == "complete") | any(vec_f_split_orig == "complete") | any(vec_c_only_pen) | any(vec_c_only_unp))  && 
    #! smooth_in %in% c("aic","bic","cvgrid","ocv","gcv")) {stop("smooth has to be in c('aic','bic','cvgrid','ocv','gcv'), if split = complete")}
    list("formula_selection"=formula_selection, "formula_fixed"=formula_fixed,
         "names_selection"=names_selection, "names_fixed"=names_fixed, "name_response"=name_response, 
         "names_selection_short"=names_selection_short, "names_fixed_short"=names_fixed_short,
         "xnames_selection"=vec_s_xname, "xnames_fixed"=vec_f_xname,
         # "vec_c_split_orig"=vec_c_split_orig, "vec_s_split_orig"=vec_s_split_orig, 
         "vec_s_xname_orig"=vec_s_xname_orig, "vec_f_xname_orig"=vec_f_xname_orig,
         "data_in"=data_in, "EQ"=EQ, "expectiles_in"=expectiles_in, 
         "estimate_in"=estimate_in, "lambda_in"=lambda_in, "smooth_in"=smooth_in, "ci_in"=ci_in,
         "NumberOfVariables"=NumberOfVariables, "NumberOfModels"=NumberOfModels, "NumberOfExpectiles"=NumberOfExpectiles)
}







rename_covariates <- function(string_in){
    only_pen_split <- F
    temp_str_split_only_pen_1 <- strsplit(string_in,"only_pen",fixed=T)[[1]][2]
    temp_str_split_only_pen_2 <- strsplit(temp_str_split_only_pen_1,",",fixed=T)[[1]][1]
    temp_str_split_only_pen_3 <- strsplit(temp_str_split_only_pen_2,")",fixed=T)[[1]][1]
    if(!is.na(temp_str_split_only_pen_3)) {
        eval(parse(text=paste("only_pen_split",temp_str_split_only_pen_3,sep="")))
    }
    
    only_unp_split <- F
    temp_str_split_only_unp_1 <- strsplit(string_in,"only_unp",fixed=T)[[1]][2]
    temp_str_split_only_unp_2 <- strsplit(temp_str_split_only_unp_1,",",fixed=T)[[1]][1]
    temp_str_split_only_unp_3 <- strsplit(temp_str_split_only_unp_2,")",fixed=T)[[1]][1]
    if(!is.na(temp_str_split_only_unp_3)) {
        eval(parse(text=paste("only_unp_split",temp_str_split_only_unp_3,sep="")))
    }
    
    covariate_name1a <- strsplit(string_in,"(",fixed=T)[[1]][1]
    covariate_name1b <- strsplit(string_in,"(",fixed=T)[[1]][2]
    covariate_name2  <- strsplit(covariate_name1b,",",fixed=T)[[1]][1]
    
    names_selection_temp <- string_in
    if(only_pen_split && covariate_name1a=="rb") {
        names_selection_temp <- paste(covariate_name2,"_rb_only_pen",sep="")
    }
    if(only_unp_split && covariate_name1a=="rb") {
        names_selection_temp <- paste(covariate_name2,"_rb_only_unp",sep="")
    }
    if(!only_unp_split && !only_pen_split && covariate_name1a=="rb") {
        names_selection_temp <- paste(covariate_name2,"_rb",sep="")
    }
    names_selection_temp
}
