# function to construct the model, dvec, Dmat, Amat
construct_Parameter_solveQP_grid  <- function(data_est,
                                              expectiles_in1, 
                                              formula_all_possible = formula_all_possible, 
                                              names_selection_short = names_selection_short, 
                                              names_fixed_short = names_fixed_short, 
                                              name_response = name_response, 
                                              estimate_in = estimate_in, 
                                              smooth_in = smooth_in, 
                                              ci_in = ci_in, 
                                              lambda_in = lambda_in) { 
    Model_List1 <- list()
    weight_List <- list()
    
    WW_List          <- list()
    FF_List          <- list()
    FF_Rest_List     <- list()
    FF_Rest_sum_List <- list()
    y_F_List         <- list()
    dvec_List        <- list()
    Dmat_List        <- list()
    Amat_List        <- list()
    # 1) build all models on the grid of alpha and for each alpha build F, etc.
    for(tt in 1:length(expectiles_in1)) {
        Model_List1[[tt]] <- expectreg.ls(formula_all_possible,data = data_est,expectiles = expectiles_in1[tt], 
                                          estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
        weight_List[[tt]]  <- abs(expectiles_in1[tt] - 1*(data_est[,which(names(data_est)==name_response)] < Model_List1[[tt]]$fitted))
        
        if(length(names_selection_short) > 0) {
            FF_List[[tt]] <- matrix(NA,nrow = nrow(data_est),ncol = length(names_selection_short))
            for(u1 in 1:length(names_selection_short)) {
                u <- names_selection_short[u1]
                FF_List[[tt]][,u1] <- (Model_List1[[tt]]$values[[which(names(Model_List1[[tt]]$values)==u)]]-Model_List1[[tt]]$intercept)
            }
        }
        
        FF_Rest_List[[tt]] <- matrix(Model_List1[[tt]]$intercept,nrow = nrow(data_est),ncol = 1)
        for(u in names_fixed_short) {
            FF_Rest_List[[tt]] <- cbind(FF_Rest_List[[tt]],(Model_List1[[tt]]$values[[which(names(Model_List1[[tt]]$values)==u)]]-Model_List1[[tt]]$intercept))
        }
        
        if(is.null(names_fixed_short)) {
            FF_Rest_sum_List[[tt]] <- FF_Rest_List[[tt]]
        }
        
        if(!is.null(names_fixed_short)) {
            FF_Rest_sum_List[[tt]] <- rowSums(FF_Rest_List[[tt]])
        }
        
        y_F_List[[tt]] <- t((Model_List1[[tt]]$response) - FF_Rest_sum_List[[tt]])
        
    }
    
    # 2) put all results F, y, and weights below each other
    weight_vector_List <- NULL
    FF <- NULL
    y_F <- NULL
    for(tt in 1:length(expectiles_in1)) {
        FF  <- rbind(FF , FF_List[[tt]])
    }
    
    y_F <- unlist(y_F_List)
    weight_vector_List <- unlist(weight_List)
    WW <- Diagonal(x = weight_vector_List)    
    
    # 3) build dvec, Dmat, Amat
    dvec <- as.vector( y_F %*% WW %*% FF)
    Dmat <- t(FF) %*% WW %*% FF
    Amat <- diag(rep(1,ncol(FF)))
    Amat <- cbind(rep(1,ncol(FF)),Amat)
    
    
    list("Model_List" = Model_List1,"WW" = WW,"FF" = FF,"y_F" = y_F,"dvec" = dvec,"Dmat" = Dmat,"Amat" = Amat)
}

# function to build F, weights, and predicted values for cross validation
construct_Parameter_validate_grid <- function(data_valid,
                                              expectiles_in1,
                                              Model_List2,
                                              names_selection_short = names_selection_short, 
                                              names_fixed_short = names_fixed_short, 
                                              name_response = name_response) { 
    FF_valid_List          <- list()
    Model_valid_List       <- list()
    weight_valid_List      <- list()
    y_F_valid_List         <- list()
    
    for(tt in 1:length(expectiles_in1)) {
        Model <- Model_List2[[tt]]
        Model_valid <- predict(Model,newdata = data_valid)
        weight_valid <- abs(expectiles_in1[tt] - 1*(data_valid[,which(names(data_valid)==name_response)] < Model_valid$fitted))
        
        FF_valid <- NULL
        for(u in names_selection_short) {
            FF_valid <- cbind(FF_valid,(t(Model_valid$values[[which(names(Model_valid$values)==u)]])-Model$intercept))
        }
        
        FF_Rest_valid <- matrix(Model$intercept,nrow = nrow(data_valid),ncol = 1)
        for(u in names_fixed_short) {
            FF_Rest_valid <- cbind(FF_Rest_valid,t((Model_valid$values[[which(names(Model_valid$values)==u)]])-Model$intercept))
        }
        
        if(is.null(names_fixed_short)) {
            FF_Rest_sum_valid <- FF_Rest_valid
        }
        
        if(!is.null(names_fixed_short)) {
            FF_Rest_sum_valid <- rowSums(FF_Rest_valid)
        }
        
        y_F_valid_List[[tt]]    <- t(data_valid[,which(names(data_valid) == name_response)] - FF_Rest_sum_valid)
        FF_valid_List[[tt]]     <- FF_valid
        Model_valid_List[[tt]]  <- Model_valid
        weight_valid_List[[tt]] <- weight_valid
    }
    list("FF_valid_List" = FF_valid_List,"weight_valid_List" = weight_valid_List,"y_F_valid_List" = y_F_valid_List) 
}



# estimate CV error
build_Diff_per_gamma_grid <- function(Gamma1,
                                      data_valid,
                                      List_Parameter_validate_grid,
                                      List_Parameter_solveQP_grid,
                                      expectiles_in1 = 0.2, 
                                      delta_min = delta_min) { 
    #Model_List2 <- List_Parameter_solveQP_grid$Model_List
    bvec <- c(Gamma1,rep(0,times = ncol(List_Parameter_solveQP_grid$FF)))
    
    temp_delta <- solve.QP(Dmat = List_Parameter_solveQP_grid$Dmat,
                           dvec = List_Parameter_solveQP_grid$dvec,
                           Amat = List_Parameter_solveQP_grid$Amat,
                           bvec = bvec,meq = 1)$solution
    if(delta_min > 0) {
        temp_delta2 <- temp_delta
        temp_delta2[temp_delta < delta_min] <- 0
        temp_delta_diff <- sum(abs(temp_delta2 - temp_delta))
        if(temp_delta_diff < length(temp_delta)*delta_min | all.equal(temp_delta,temp_delta2)) {
            delta <- temp_delta2
        } else {
            delta <- temp_delta
        }
    } else {
        delta <- temp_delta
    }
    
    
    Diff1 <- rep(NA,times = length(expectiles_in1))
    for(tt in 1:length(expectiles_in1)) {
        weight_valid <-   List_Parameter_validate_grid$weight_valid_List[[tt]]
        y_F_valid    <- t(List_Parameter_validate_grid$y_F_valid_List[[tt]])
        FF_valid     <-   List_Parameter_validate_grid$FF_valid_List[[tt]]
        
        Pred_d       <- FF_valid %*% delta
        Diff1[tt]    <- mean(weight_valid*(y_F_valid-Pred_d)^2)
    }
    Diff <- mean(Diff1)
    Diff
}

garroteExpect_grid <- function(object, scope = NULL, output_type = c("list_models_delta", "one_model_delta","list_models","one_model"), 
                         trace = FALSE, lambda = 1, N_CV = 5, grid_alpha = 50, grid_gamma = 
                             50, delta_min = 2.5e-16, fix_gamma = NULL, start_gamma = 1e-04, split = c("no","complete","restricted")) {
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    split <- match.arg(split)
    if(class(object)[1] != "expectreg") {stop("Garrote only for class expectreg")}
    Transposed_Input     <- transpose_input(object = object, scope = scope, lambda_transpose = lambda, split=split)
    formula_selection    <- Transposed_Input$formula_selection
    formula_fixed        <- Transposed_Input$formula_fixed
    names_selection      <- Transposed_Input$names_selection
    names_fixed          <- Transposed_Input$names_fixed
    name_response        <- Transposed_Input$name_response
    data_in              <- Transposed_Input$data_in
    EQ                   <- Transposed_Input$EQ
    expectiles_in        <- Transposed_Input$expectiles_in
    estimate_in          <- Transposed_Input$estimate_in
    lambda_in            <- Transposed_Input$lambda_in
    smooth_in            <- Transposed_Input$smooth_in
    ci_in                <- Transposed_Input$ci_in
    NumberOfVariables    <- Transposed_Input$NumberOfVariables
    NumberOfModels       <- Transposed_Input$NumberOfModels
    NumberOfExpectiles   <- Transposed_Input$NumberOfExpectiles
    
    names_selection_short <- Transposed_Input$names_selection_short
    names_fixed_short     <- Transposed_Input$names_fixed_short
    xnames_selection      <- Transposed_Input$xnames_selection
    xnames_fixed          <- Transposed_Input$xnames_fixed
    
    vec_s_split_orig     <- Transposed_Input$vec_s_split_orig
    vec_s_xname_orig     <- Transposed_Input$vec_s_xname_orig
    if(split == 'restricted') { 
        stop("'restricted' is not compatible with nonnegative garrote.\n\r Use 'complete' or 'no'.")
    }
    
    names_all_possible   <- c(names_selection,names_fixed)
    names_all_possible_short   <- c(names_selection_short,names_fixed_short)
    formula_all_possible <- as.formula(paste(name_response, " ~ ", paste(names_all_possible, collapse = " + "), sep = ""),env = .GlobalEnv)
    
    if(!is.null(fix_gamma)) {
        if(length(fix_gamma) != 1) {stop("fixed gamma has to be one number for Garrote_grid")}
        if(length(fix_gamma) == 1) {
            if((fix_gamma > NumberOfVariables)) {stop("fixed gamma is larger than number of covariates")}
            if((fix_gamma <= 0)) {stop("fixed gamma is negative or 0")}
            if((0 < fix_gamma) && ( fix_gamma <= NumberOfVariables)) {cat("\n\r", "Gamma is fixed to ", fix_gamma ,"\n\r")}
        }
    }
    
    anova <- list()

    arguments <- list()
    arguments$N_CV <- N_CV
    arguments$lambda <- lambda
    arguments$delta_min <- delta_min
    arguments$split <- split
    arguments$grid_alpha <- grid_alpha
    arguments$grid_gamma <- grid_gamma
    arguments$fix_gamma <- fix_gamma
    arguments$start_gamma <- start_gamma
    arguments$output_type <- output_type
    
    anova$arguments <- arguments
    
    
    rm(Transposed_Input)
    
    Gamma_vec <- seq(start_gamma,NumberOfVariables,length = grid_gamma)
    n_ges <- nrow(data_in)
    Diff <- matrix(NA,nrow = length(Gamma_vec),ncol = N_CV)
    Numbers_G <- Sample_Numbers(N_CV1 = N_CV,n_ges1 = n_ges)
    grid_goodness <- seq(from = 1/grid_alpha, to = (1-1/grid_alpha), by = 1/grid_alpha)
    
    if(is.null(fix_gamma)){
        # estimate CV error for each validation dataset and each Gamma
        for(g in 1:N_CV) {
            List_Parameter_solveQP_grid  <- construct_Parameter_solveQP_grid (data_est   = data_in[Numbers_G[[2]][[g]],] , 
                                                                              expectiles_in1 = grid_goodness , 
                                                                              formula_all_possible = formula_all_possible, 
                                                                              names_selection_short = names_selection_short, 
                                                                              names_fixed_short = names_fixed_short, 
                                                                              name_response = name_response, 
                                                                              estimate_in = estimate_in, 
                                                                              smooth_in = smooth_in, 
                                                                              ci_in = ci_in, 
                                                                              lambda_in = lambda_in) 
            List_Parameter_validate_grid <- construct_Parameter_validate_grid(data_valid = data_in[Numbers_G[[1]][[g]],] , 
                                                                              expectiles_in1 = grid_goodness , 
                                                                              Model_List2 = List_Parameter_solveQP_grid$Model_List,
                                                                              names_selection_short = names_selection_short, 
                                                                              names_fixed_short = names_fixed_short, 
                                                                              name_response = name_response) 
            
            for(j in 1:length(Gamma_vec)) {
                Diff[j,g] <- build_Diff_per_gamma_grid(Gamma1 = Gamma_vec[j] , 
                                                       data_valid = data_in[Numbers_G[[1]][[g]],] , 
                                                       List_Parameter_validate_grid = List_Parameter_validate_grid,
                                                       List_Parameter_solveQP_grid = List_Parameter_solveQP_grid,
                                                       expectiles_in1 = grid_goodness,
                                                       delta_min = delta_min) 
            }
            if(trace){
                cat(" ",g,"-th CV")
            }
        }
        
        # Find optimal Gamma
        Diff_Gamma <- rowMeans(Diff)
        gamma_opt <- Gamma_vec[which.min(Diff_Gamma)]
        anova$gamma_values   <- rbind(Gamma_vec,Diff_Gamma)
        rownames(anova$gamma_values) <- c("gamma","MSE_per_gamma")
    }
    
    if(!is.null(fix_gamma)) {
        gamma_opt <- fix_gamma
        anova$gamma_values <- NULL
    }
    
    anova$gamma_opt      <- gamma_opt
    
    # use this optimal gamma to estimate delta on the whole dataset
    List_Parameter_solveQP_grid_all <- construct_Parameter_solveQP_grid(data_est = data_in,
                                                                        expectiles_in1 = grid_goodness,
                                                                        formula_all_possible = formula_all_possible, 
                                                                        names_selection_short = names_selection_short, 
                                                                        names_fixed_short = names_fixed_short, 
                                                                        name_response = name_response, 
                                                                        estimate_in = estimate_in, 
                                                                        smooth_in = smooth_in, 
                                                                        ci_in = ci_in, 
                                                                        lambda_in = lambda_in)
    bvec_all   <- c(gamma_opt,rep(0,times = ncol(List_Parameter_solveQP_grid_all$FF)))
    
    temp_delta_opt <- solve.QP(Dmat = List_Parameter_solveQP_grid_all$Dmat,
                               dvec = List_Parameter_solveQP_grid_all$dvec,
                               Amat = List_Parameter_solveQP_grid_all$Amat,
                               bvec = bvec_all,meq = 1)$solution
    
    if(delta_min > 0) {
        temp_delta_opt2 <- temp_delta_opt
        temp_delta_opt2[temp_delta_opt < delta_min] <- 0
        temp_delta_diff <- sum(abs(temp_delta_opt2 - temp_delta_opt))
        if(temp_delta_diff < length(temp_delta_opt)*delta_min | all.equal(temp_delta_opt,temp_delta_opt2)) {
            delta_opt <- temp_delta_opt2
        } else {
            delta_opt <- temp_delta_opt
        }
    } else {
        delta_opt <- temp_delta_opt
    }
    
    
    
    names(delta_opt) <- names_selection_short
    if(!is.null(names_fixed)) {
        delta_opt <- c(delta_opt,rep(1,times = length(names_fixed)))
        names(delta_opt) <- c(names_selection_short,paste(names_fixed_short,"(fixed)"))
    }
    
    anova$delta_opt      <- delta_opt
    
    
    
    Output_model <- NULL
    if("list_models" %in% output_type) {
        Output_model <- list()
        formula_tt <- formula_all_possible
        for(tt in 1:length(expectiles_in)) {
            Output_model[[tt]] <- expectreg.ls(formula_tt,data = data_in,
                                               expectiles = expectiles_in[tt],
                                               estimate = estimate_in, 
                                               smooth = smooth_in, 
                                               ci = ci_in, 
                                               lambda = lambda_in)
        }
    }
    
    Output_model_delta <- NULL
    if("list_models_delta" %in% output_type) {
        Output_model_delta <- list()
        formula_tt <- formula_all_possible
        for(tt in 1:length(expectiles_in)) {
            Output_model_delta[[tt]] <- expectreg.ls(formula_tt,
                                                     data = data_in,
                                                     expectiles = expectiles_in[tt],
                                                     estimate = estimate_in, 
                                                     smooth = smooth_in, 
                                                     ci = ci_in, 
                                                     lambda = lambda_in, 
                                                     delta_garrote = delta_opt)
        }
    }
    
    Output_OneModel <- NULL
    if("one_model" %in% output_type || "one_model_delta" %in% output_type) {
        Output_OneModel <- NULL
        formula_tt <- formula_all_possible
        Output_OneModel <- expectreg.ls(formula_tt, 
                                        data = data_in,
                                        expectiles = expectiles_in,
                                        estimate = estimate_in, 
                                        smooth = smooth_in, 
                                        ci = ci_in, 
                                        lambda = lambda_in)
    }
    
    Output_OneModel_delta <- NULL
    if("one_model_delta" %in% output_type) {
        Output_OneModel_delta <- NULL
        formula_tt <- formula_all_possible
        Output_OneModel_delta <- expectreg.ls(formula_tt, 
                                              data = data_in,
                                              expectiles = expectiles_in,
                                              estimate = estimate_in, 
                                              smooth = smooth_in, 
                                              ci = ci_in, 
                                              lambda = lambda_in, 
                                              delta_garrote = delta_opt)
    }
    
    formular_Garrote_temp <- NULL
    vec_modell_garrote_true <- F
    for(u in 1:length(names_selection)) {
        if(abs(delta_opt[which(names(delta_opt) == names_selection_short[u])]) >= delta_min) {
            vec_modell_garrote_true <- T
            formular_Garrote_temp <- c(formular_Garrote_temp,names_selection[u])
        }
    }
    formular_Garrote_temp <- c(formular_Garrote_temp,names_fixed)
    
    if(!vec_modell_garrote_true) {
        if(is.null(names_fixed)) {
            formular_Garrote_temp <- "1"
        }
        if(!is.null(names_fixed)) {
            formular_Garrote_temp <- names_fixed
        }
    }
    
    formular_Garrote_temp <- NULL
    vec_modell_garrote_true <- F
    for(u in 1:length(names_selection)) {
        if(abs(delta_opt[which(names(delta_opt) == names_selection_short[u])]) >= delta_min) {
            vec_modell_garrote_true <- T
            formular_Garrote_temp <- c(formular_Garrote_temp,names_selection[u])
        }
    }
    formular_Garrote_temp <- c(formular_Garrote_temp,names_fixed)
    
    if(!vec_modell_garrote_true) {
        if(is.null(names_fixed)) {
            formular_Garrote_temp <- "1"
        }
        if(!is.null(names_fixed)) {
            formular_Garrote_temp <- names_fixed
        }
    }
    anova$best_model <- paste(name_response, "~", paste(formular_Garrote_temp,collapse=" + "))
    
    
    
    table_delta_opt <- matrix(0,ncol = 1,nrow = length(names(anova$delta_opt)))
    
    rownames(table_delta_opt) <- names(anova$delta_opt)
    colnames(table_delta_opt) <- "all"
    All_covariates       <- c(names_fixed,      names_selection)
    All_covariates_short <- c(names_fixed_short,names_selection_short)
    table_delta_opt[,1] <- anova$delta_opt
    
    table_selected <- table_delta_opt
    table_selected[table_selected <= delta_min] <- 0
    table_selected[table_selected >  delta_min] <- 1
    anova$names_selection <- names_selection
    anova$names_fixed <- names_fixed
    
    anova$table_delta_opt <- table_delta_opt
    anova$table_selected <- table_selected
    
    if(trace) {
        cat("\n\r")
        print(anova,digits = 4,quote = F)
        cat("\n\r")
    }
    
    result <- list("anova" = anova)    
    if("list_models"       %in% output_type) { result$list_models       <- Output_model }
    if("list_models_delta" %in% output_type) { result$list_models_delta <- Output_model_delta }
    if("one_model"         %in% output_type) { result$one_model         <- Output_OneModel }
    if("one_model_delta"   %in% output_type) { result$one_model_delta   <- Output_OneModel_delta}
    #if("IndexBestModel" %in% output_type) { result$IndexBestModel <- IndexBestModel }

    class(result) = c("expectreg_selected", "garroteExpect", "jointly", "CV")
    
    result
    
}


























