
bestCV_separately <- function(object, scope = NULL, output_type = c("list_models","one_model"), 
                              trace = FALSE, lambda = 1, N_CV = 5, 
                              split = c("no","complete","restricted")) {
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    split <- match.arg(split)
    
    Transposed_Input     <- transpose_input(object=object,scope=scope,lambda_transpose=lambda,split=split)
    formula_selection    <- Transposed_Input$formula_selection 
    formula_fixed        <- Transposed_Input$formula_fixed
    names_selection      <- Transposed_Input$names_selection
    names_fixed          <- Transposed_Input$names_fixed
    name_response        <- Transposed_Input$name_response
    data_in              <- Transposed_Input$data_in
    EQ                   <- Transposed_Input$EQ
    expectiles_in        <- Transposed_Input$expectiles_in
    estimate_in          <- Transposed_Input$estimate_in
    lambda_in            <- Transposed_Input$lambda_in
    smooth_in            <- Transposed_Input$smooth_in
    ci_in                <- Transposed_Input$ci_in
    NumberOfVariables    <- Transposed_Input$NumberOfVariables
    NumberOfModels       <- Transposed_Input$NumberOfModels
    NumberOfExpectiles   <- Transposed_Input$NumberOfExpectiles
    
    xnames_selection     <- Transposed_Input$xnames_selection
    xnames_fixed         <- Transposed_Input$xnames_fixed
    names_selection_short <- Transposed_Input$names_selection_short
    names_fixed_short     <- Transposed_Input$names_fixed_short
    
    if(estimate_in != "laws")
        stop("bestExpect only possible for estimate == 'laws'!")
    
    anova <- list()
    
    arguments <- list()
    arguments$lambda <- lambda
    arguments$criterion <- "CV"
    arguments$N_CV <- N_CV
    arguments$k <- 2
    arguments$split <- split
    arguments$output_type <- output_type
    
    anova$arguments <- arguments
        
    rm(Transposed_Input)
    
    # 1) initialize the matrices for the CV criterion
    criterion_CV_separate  <- list()         # saves the value of the criterion for each CV iteration per expectile(column) and per model(row)
    criterion_CV_sum       <- matrix(0,nrow=NumberOfModels,ncol=NumberOfExpectiles)
    for(g in 1:N_CV){
        criterion_CV_separate[[g]] <- matrix(0,nrow=NumberOfModels,ncol=NumberOfExpectiles)
    }
    
    n_ges1 <- nrow(data_in)
    Numbers_all <- 1:n_ges1
    Numbers_in  <- list()
    Numbers_out <- list()
    size <- rep(n_ges1 %/% N_CV, times=N_CV)
    if(n_ges1%%N_CV != 0){
        for(d in 1:(n_ges1%%N_CV)) {
            size[d] <- size[d] + 1
        }
    }
    Numbers_left <- Numbers_all
    for(g in 1:N_CV){
        Numbers_out[[g]] <- sample(Numbers_left, size=size[g])
        Numbers_in[[g]]  <- Numbers_all[which(!(Numbers_all %in% Numbers_out[[g]]))]
        Numbers_left     <- Numbers_left[which(!(Numbers_left %in% Numbers_out[[g]]))]
    }
    
    # 3) Start CV
    for(g in 1:N_CV){
        data_train <- data_in[Numbers_in[[g]],]       # Dataset for training
        data_pre   <- data_in[Numbers_out[[g]],]      # Dataset for validation
        
        # 3a) Estimate all models with training dataset g
        
        AllModels <- estimate_AllModels(data_in = data_train, Expect_new=expectiles_in, names_selection=names_selection, names_fixed=names_fixed, name_response=name_response, lambda_in = lambda_in, estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in)
        if(NumberOfModels != length(AllModels)){stop("Number of models differs!")}
        # 3b) Compute CV-criterion for validation dataset g for each modell and each alpha
        for(k in 1:NumberOfModels) {
            #cat(k, " ")
            PredModell <- predict(object=AllModels[[k]],newdata=data_pre)   # Apply models on validation datasets and estimate the goodness of fit
            w_CV = matrix(AllModels[[k]]$asymmetries,nrow=nrow(data_pre),ncol=length(AllModels[[k]]$asymmetries),byrow=T)
            w_CV = abs(w_CV - 1*(data_pre[,name_response] < PredModell$fitted))
            criterion_CV_separate[[g]][k,] <- colMeans(w_CV*(data_pre[,name_response] - PredModell$fitted)^2)
        }
        
        criterion_CV_sum <- criterion_CV_sum + criterion_CV_separate[[g]] # summerize goodness of fit
        if(trace) {
            cat(g, "-th CV   ")    
        }
    }                                 # End CV iterations
    
    # 4) find best model of this iteration i and save its number
    AllFormula_1 <- define_AllFormula(names_selection=names_selection, names_fixed=names_fixed,
                                      name_response=name_response, data_in = data_in)[[1]]
    AllFormula_2 <- define_AllFormula(names_selection=names_selection, names_fixed=names_fixed,
                                      name_response=name_response, data_in = data_in)[[2]]
    
    IndexBestModel <- rep(NA,times=length(expectiles_in))
    Output_model <- NULL
    for(tt in 1:length(expectiles_in)) {
        IndexBestModel[tt] <- which.min(criterion_CV_sum[,tt])
    }
    Output_model <- list()
    for(tt in 1:length(expectiles_in)) {
        formula_tt <- AllFormula_1[[IndexBestModel[tt]]]
        Output_model[[tt]] <- expectreg.ls(formula_tt,data=data_in,expectiles=expectiles_in[tt],estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
    }
    
    
    AllFormula_3 <- define_AllFormula_print(names_selection=names_selection, names_fixed=names_fixed,name_response=name_response,data_in=data_in)
    trace_matrix <- cbind(AllFormula_3,formatC(criterion_CV_sum[,1],digits=2,format="e"),rank(criterion_CV_sum[,1]))
    if(NumberOfExpectiles > 1) {
        for(tt in 2:NumberOfExpectiles) {
            trace_matrix <- cbind(trace_matrix,formatC(criterion_CV_sum[,tt],digits=2,format="e"),rank(criterion_CV_sum[,tt]))
        }
    }
    
    names_trace_matrix1 <- rep("",times=ncol(AllFormula_3))
    names_trace_matrix2 <- NULL
    for(tt in 1:NumberOfExpectiles) {
        names_trace_matrix2 <- c(names_trace_matrix2,paste("criterion:",as.character(expectiles_in[tt])),paste("rank:",as.character(expectiles_in[tt])))
    }   
    colnames(trace_matrix) <- c(names_trace_matrix1,names_trace_matrix2)
    rownames(trace_matrix) <- rep("",times=nrow(trace_matrix))
    
    if(trace) {
        cat("\r\n")
        print(trace_matrix,digits =2,quote=F, right=T,rownames="")
        cat("\r\n")
    }
    
    table_selected <- matrix(0,ncol=length(expectiles_in),nrow=length(names_selection_short)+length(names_fixed_short))
    
    colnames(table_selected) <- expectiles_in
    
    All_covariates       <- restructure_covariates(c(names_selection,       names_fixed))
    All_covariates_short <- restructure_covariates(c(names_selection_short, names_fixed_short))
    rownames(table_selected) <- All_covariates_short
    for(tt in 1:length(expectiles_in)) {
        for(k in 1:length(All_covariates)) {
            if(All_covariates[k] %in% sort_covariates(Output_model[[tt]]$formula)){
                table_selected[k,tt] <- 1
            }
        }
    }
    
    anova$all_models <- AllFormula_1
    colnames(criterion_CV_sum) <- as.character(expectiles_in)
    anova$criterion <- criterion_CV_sum
    anova$names_selection <- names_selection
    anova$names_fixed <- names_fixed
    anova$table_selected <- table_selected
    
    Output <- NULL
    for(tt in 1:length(expectiles_in)) {
        Output[[tt]] <- sort_covariates(Output_model[[tt]]$formula)
    }
    
    if("one_model" %in% output_type) {
        Output_one_model <- NULL
        
        Vec_formula_join <- unique(unlist(Output))
        formula_join <-  as.formula(paste(name_response, " ~ ", paste(Vec_formula_join,collapse=" + "),sep=""))
        Output_one_model <- expectreg.ls(formula_join, data = data_in, expectiles = expectiles_in, 
                                         estimate = estimate_in, smooth = smooth_in, ci = ci_in, 
                                         lambda = lambda_in, list_models = Output_model)
    }
    
    if(trace) {
        cat("\n\r", "Table selected covariates:", "\n\r")
        print(anova$table_selected)
        cat("\n\r")
    }
    
    result <- list("anova"=anova)
    if("list_models" %in% output_type) { result$list_models <- Output_model     }
    if("one_model"   %in% output_type) { result$one_model   <- Output_one_model }
    #if("IndexBestModel" %in% output_type)  { result$IndexBestModel <- IndexBestModel  }
    
    class(result) = c("expectreg_selected", "bestExpect", "separately", "CV")
    
    result
}



bestAIC_separately <- function(object, scope = NULL, output_type = c("list_models","one_model"), 
                               trace = FALSE, lambda = 1, criterion = 
                                   c("AIC","BIC","OCV","GCV",NULL), k = 2, split = c("no","complete","restricted")) {
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    
    criterion <- match.arg(criterion, several.ok = FALSE)
    
    if(length(k) > 1) stop("k has to be scalar")
    
    if( is.null(criterion) &&  is.null(k))             {stop("specify criterion or specify k")}
    if(is.null(criterion) && !is.null(k) && is.numeric(k)) {
        criterion <- "AIC"
        pen_AIC <- k
    }
    
    if(!is.null(criterion)) {
        if(length(criterion) == 1) {
            if("AIC" %in% criterion && !is.null(k) && is.numeric(k))     {
                pen_AIC = k
            }
            if("AIC" %in% criterion && is.null(k))     {
                pen_AIC = 2
            }
        }
        if(length(criterion) > 1) {
            if("AIC" %in% criterion && !is.null(k) && is.numeric(k))     {
                pen_AIC = k
            }
            if("AIC" %in% criterion && is.null(k))     {
                pen_AIC = 2
            }
        }
    }
    
    split <- match.arg(split)
    
    Transposed_Input     <- transpose_input(object=object,scope=scope,lambda_transpose=lambda,split=split)
    formula_selection    <- Transposed_Input$formula_selection 
    formula_fixed        <- Transposed_Input$formula_fixed
    names_selection      <- Transposed_Input$names_selection
    names_fixed          <- Transposed_Input$names_fixed
    name_response        <- Transposed_Input$name_response
    data_in              <- Transposed_Input$data_in
    EQ                   <- Transposed_Input$EQ
    expectiles_in        <- Transposed_Input$expectiles_in
    estimate_in          <- Transposed_Input$estimate_in
    lambda_in            <- Transposed_Input$lambda_in
    smooth_in            <- Transposed_Input$smooth_in
    ci_in                <- Transposed_Input$ci_in
    NumberOfVariables    <- Transposed_Input$NumberOfVariables
    NumberOfModels       <- Transposed_Input$NumberOfModels
    NumberOfExpectiles   <- Transposed_Input$NumberOfExpectiles
    
    xnames_selection      <- Transposed_Input$xnames_selection
    xnames_fixed          <- Transposed_Input$xnames_fixed
    names_selection_short <- Transposed_Input$names_selection_short
    names_fixed_short     <- Transposed_Input$names_fixed_short
    
    anova <- list()
    
    if(estimate_in != "laws")
        stop("bestExpect only possible for estimate == 'laws'!")
    
    arguments <- list()
    arguments$lambda <- lambda
    arguments$criterion <- criterion
    arguments$N_CV <- 5
    arguments$k <- k
    arguments$split <- split
    arguments$output_type <- output_type
    
    anova$arguments <- arguments
    
    rm(Transposed_Input)
    n_ges1 <- nrow(data_in)
    # initialize the matrix for the goodness of fit criterion
    IndexBestModel <- matrix(NA,ncol=NumberOfExpectiles,nrow=length(criterion))
    criterion_sum_all <- list()
    
    # estimate all possible models
    AllModels_AIC <- estimate_AllModels(data_in = data_in, Expect_new=expectiles_in, names_selection=names_selection, names_fixed=names_fixed, name_response=name_response, lambda_in = lambda_in, estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in)     
    # compute there goodness of fit
    for(r in 1:length(criterion)) {
        criterion_sum <- matrix(NA,nrow=NumberOfModels,ncol=NumberOfExpectiles)   
        if(criterion[r]=="AIC") {
            for(k in 1:NumberOfModels) {
                criterion_sum[k,] <- AIC(AllModels_AIC[[k]], k=pen_AIC)
            }
            for(tt in 1:NumberOfExpectiles) {
                IndexBestModel[r,tt] <- which.min(criterion_sum[,tt])
            }
            criterion_sum_all$AIC <- criterion_sum
        }
        if(criterion[r]=="BIC") {
            for(k in 1:NumberOfModels) {
                criterion_sum[k,] <- AIC(AllModels_AIC[[k]], k=log(n_ges1))
            }
            for(tt in 1:NumberOfExpectiles) {
                IndexBestModel[r,tt] <- which.min(criterion_sum[,tt])
            }
            criterion_sum_all$BIC <- criterion_sum
        }
        if(criterion[r]=="OCV") {
            for(k in 1:NumberOfModels) {
                criterion_sum[k,] <- OCV(AllModels_AIC[[k]])
            }
            for(tt in 1:NumberOfExpectiles) {
                IndexBestModel[r,tt] <- which.min(criterion_sum[,tt])
            }
            criterion_sum_all$OCV <- criterion_sum
        }
        if(criterion[r]=="GCV") {
            for(k in 1:NumberOfModels) {
                criterion_sum[k,] <- GCV(AllModels_AIC[[k]])
            }
            for(tt in 1:NumberOfExpectiles) {
                IndexBestModel[r,tt] <- which.min(criterion_sum[,tt])
            }
            criterion_sum_all$GCV <- criterion_sum
        }
        
    }
    
    Output_model <- NULL
    AllFormula_1 <- define_AllFormula(names_selection=names_selection, names_fixed=names_fixed,
                                      name_response=name_response, data_in = data_in)[[1]]
    
    Output_model <- list()
    
    #         if(length(criterion) > 1) {
    #             for(r in 1:length(criterion)){
    #                 Output_model[[r]] <- list()
    #                 for(tt in 1:NumberOfExpectiles) {
    #                     formula_tt <- AllFormula_1[[IndexBestModel[r,tt]]]
    #                     Output_model[[r]][[tt]] <- expectreg.ls(formula_tt,data=data_in,expectiles=expectiles_in[tt],estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
    #                     }
    #                 }
    #                 names(Output_model) <- criterion
    #             }
    #         
    if(length(criterion) == 1) {
        for(tt in 1:NumberOfExpectiles) {
            formula_tt <- AllFormula_1[[IndexBestModel[1,tt]]]
            Output_model[[tt]] <- expectreg.ls(formula_tt,data=data_in,expectiles=expectiles_in[tt],estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
        }
    }
    
    
    Output_OneModel <- NULL
    if(length(criterion) == 1){
        Output <- NULL
        for(tt in 1:length(expectiles_in)) {
            Output[[tt]] <- sort_covariates(Output_model[[tt]]$formula)
        }
        if("one_model" %in% output_type) {
            Vec_formula_join <- unique(unlist(Output))
            formula_join <-  as.formula(paste(name_response, " ~ ", paste(Vec_formula_join,collapse=" + "),sep=""))
            Output_one_model <- expectreg.ls(formula_join, data = data_in, expectiles = expectiles_in, 
                                             estimate = estimate_in, smooth = smooth_in, ci = ci_in, 
                                             lambda = lambda_in, list_models = Output_model)
        }
        
    }
    
    
    AllFormula_3 <- define_AllFormula_print(names_selection=names_selection, names_fixed=names_fixed,name_response=name_response,data_in=data_in)
    trace_matrix <- AllFormula_3
    
    names_trace_matrix1 <- rep("",times=ncol(AllFormula_3))
    names_AIC_temp <- names_BIC_temp <- names_OCV_temp <- names_GCV_temp <- names_R2_adj_temp <- NULL
    if("AIC" %in% criterion) {
        trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$AIC[,1],digits=2,format="e"),rank(criterion_sum_all$AIC[,1]))
        names_AIC_temp <- c(paste("AIC:",as.character(expectiles_in[1])),"rank:")
        if(NumberOfExpectiles > 1) {
            for(tt in 2:NumberOfExpectiles) {
                trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$AIC[,tt],digits=2,format="e"),rank(criterion_sum_all$AIC[,tt]))
                names_AIC_temp <- c(names_AIC_temp,paste("AIC:",as.character(expectiles_in[tt])),"rank:")
            }
        }
    }
    if("BIC" %in% criterion) {
        trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$BIC[,1],digits=2,format="e"),rank(criterion_sum_all$BIC[,1]))
        names_BIC_temp <- c(paste("BIC:",as.character(expectiles_in[1])),"rank:")
        if(NumberOfExpectiles > 1) {
            for(tt in 2:NumberOfExpectiles) {
                trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$BIC[,tt],digits=2,format="e"),rank(criterion_sum_all$BIC[,tt]))
                names_BIC_temp <- c(names_BIC_temp,paste("BIC:",as.character(expectiles_in[tt])),"rank:")
            }
        }
    }
    if("OCV" %in% criterion) {
        trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$OCV[,1],digits=2,format="e"),rank(criterion_sum_all$OCV[,1]))
        names_OCV_temp <- c(paste("OCV:",as.character(expectiles_in[1])),"rank:")
        if(NumberOfExpectiles > 1) {
            for(tt in 2:NumberOfExpectiles) {
                trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$OCV[,tt],digits=2,format="e"),rank(criterion_sum_all$OCV[,tt]))
                names_OCV_temp <- c(names_OCV_temp,paste("OCV:",as.character(expectiles_in[tt])),"rank:")
            }
        }
    }
    if("GCV" %in% criterion) {
        trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$GCV[,1],digits=2,format="e"),rank(criterion_sum_all$GCV[,1]))
        names_GCV_temp <- c(paste("GCV:",as.character(expectiles_in[1])),"rank:")
        if(NumberOfExpectiles > 1) {
            for(tt in 2:NumberOfExpectiles) {
                trace_matrix <- cbind(trace_matrix,formatC(criterion_sum_all$GCV[,tt],digits=2,format="e"),rank(criterion_sum_all$GCV[,tt]))
                names_GCV_temp <- c(names_GCV_temp,paste("GCV:",as.character(expectiles_in[tt])),"rank:")
            }
        }
    }
    colnames(trace_matrix) <- c(names_trace_matrix1,names_AIC_temp,names_BIC_temp,names_OCV_temp,names_GCV_temp)
    
    
    
    if(trace) {
        cat("\r\n")
        print(trace_matrix,digits =2,quote=F,right=T)
        cat("\r\n")
    }
    
    anova$all_models <- AllFormula_1
    if("AIC" %in% criterion)    { colnames(criterion_sum_all$AIC)    <- as.character(expectiles_in)}
    if("BIC" %in% criterion)    { colnames(criterion_sum_all$BIC)    <- as.character(expectiles_in)}
    if("OCV" %in% criterion)    { colnames(criterion_sum_all$OCV)    <- as.character(expectiles_in)}
    if("GCV" %in% criterion)    { colnames(criterion_sum_all$GCV)    <- as.character(expectiles_in)}
    anova$criterion <- criterion_sum_all
    anova$names_selection <- names_selection
    anova$names_fixed <- names_fixed
    
    
    if(length(criterion) == 1) {
        table_selected <- matrix(0,ncol=length(expectiles_in),nrow=length(names_selection_short)+length(names_fixed_short))
        
        colnames(table_selected) <- expectiles_in
        
        All_covariates       <- restructure_covariates(c(names_selection,       names_fixed))
        All_covariates_short <- restructure_covariates(c(names_selection_short, names_fixed_short))
        rownames(table_selected) <- All_covariates_short
        for(tt in 1:length(expectiles_in)) {
            for(k in 1:length(All_covariates)) {
                if(All_covariates[k] %in% sort_covariates(Output_model[[tt]]$formula)){
                    table_selected[k,tt] <- 1
                }
            }
        }
        anova$table_selected <- table_selected
    }
    
    #     if(length(criterion) > 1) {
    #         list_table_selected <- list()
    #             
    #         for(r in 1:length(criterion)){
    #             table_selected <- matrix(0,ncol=length(expectiles_in),nrow=length(names_selection_short)+length(names_fixed_short))
    #     
    #             colnames(table_selected) <- expectiles_in
    #             
    #             All_covariates       <- restructure_covariates(c(names_selection,       names_fixed))
    #             All_covariates_short <- restructure_covariates(c(names_selection_short, names_fixed_short))
    #             rownames(table_selected) <- All_covariates_short
    #             for(tt in 1:length(expectiles_in)) {
    #                 for(k in 1:length(All_covariates)) {
    #                     if(All_covariates[k] %in% sort_covariates(Output_model[[r]][[tt]]$formula)){
    #                         table_selected[k,tt] <- 1
    #                         }
    #                     }
    #                 }
    #             list_table_selected[[r]] <- table_selected
    #             }
    #         names(list_table_selected) <- criterion
    #         anova$table_selected <- list_table_selected
    #         }
    
    if(trace) {
        cat("\n\r", "Table selected covariates:", "\n\r")
        print(anova$table_selected)
        cat("\n\r")
    }
    
    
    
    
    result <- list("anova"=anova)
    if("list_models"          %in% output_type)  { result$list_models <- Output_model    }
    if("one_model"            %in% output_type)  { result$one_model   <- Output_one_model     }
    #if("IndexBestModel" %in% output_type)  { result$IndexBestModel <- IndexBestModel  }
    class(result) = c("expectreg_selected", "bestExpect", "separately", criterion)
    
    result
}



