\name{plot.expectreg_selected}
\alias{plot.expectreg_selected}
\alias{plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Default expectreg_selected plotting
}
\description{
Takes a \code{expectreg_selected} object and plots the estimated effects. 
Function is similar to \code{plot.expectreg}.
}
\usage{
\method{plot}{expectreg_selected}(x, rug = TRUE, xlab = NULL, ylab = NULL, ylim = NULL, 
     legend = TRUE, ci = FALSE, ask = NULL, cex.main = 2, mar.min = 5, main = NULL, 
     cols = "rainbow", hcl.par = list(h = c(260, 0), c = 185, l = c(30, 85)), 
     ylim_spat = NULL, ylim_factor = NULL, range_warning = TRUE, add_intercept = TRUE, 
     type = c("one_model","list_models","one_model_delta","list_models_delta"), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
An object of class \code{expectreg_selected} as returned e.g. by the function \code{\link{stepExpect}}.
}
  \item{rug}{
Boolean. Whether nonlinear effects are displayed in a rug plot.
}
  \item{xlab, ylab, ylim}{
Graphic parameters. \code{xlab} should match the number of covariates.
}
  \item{legend}{
Boolean. Decides whether a legend is added to the plots.
}
  \item{ci}{
Boolean. Whether confidence intervals and significances should be plotted.
}
  \item{ask}{
Should always be asked before a new plot is printed.
}
  \item{cex.main}{
Font size of main
}
  \item{mar.min}{
Minimal margins, important when markov fields are plotted
}
  \item{main}{
Vector of main per plot
}
  \item{cols}{
Colours sheme of plots. Default is rainbow. Alternatively \code{hcl} can be used.
}
  \item{hcl.par}{
Parameters to specify the hcl coulour sheme.
}
  \item{ylim_spat}{
y_limits of the markov random field and all other spatial methods.
}
  \item{ylim_factor}{
y_limits of the plots of factor covariates.
}
  \item{range_warning}{
Should a warning be printed in the graphic if the range of the markov random field/factor plot is larger than the specified limits in \code{markov_ylim}/\code{factors_ylim}.
}
\item{add_intercept}{
Should the intercept be added to the plots of splines?
}
\item{type}{Which type of plot shouls be plotted? Default is \code{"list_models"}. Plot is only possible if this type is part of the original object.}
  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
}
}
\details{
The \code{plot} function gives a visual representation of the fitted expectiles
separately for each covariate. It joins the results of the different selected models per asymmetry, if necessary.
For non-negative garrote it uses the reweighted models, if possible.
}
\value{
plots
}
\references{
To be published

Schnabel S and Eilers P (2009)
\emph{ Optimal expectile smoothing }
Computational Statistics and Data Analysis, 53:4168-4177

Sobotka F and Kneib T (2010)
\emph{ Geoadditive Expectile Regression }
Computational Statistics and Data Analysis,
doi: 10.1016/j.csda.2010.11.015.

}
\author{
Elmar Spiegel and Fabian Sobotka \cr
Georg August University Goettingen \cr
\url{http://www.uni-goettingen.de} \cr
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{expectreg.ls}}, \code{\link{print.expectreg_selected}}, \code{\link{stepExpect}}
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- rpois(1000,1)
x4 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.3*x2 + x3 + eps
x3 <- factor(x3)
data1 <- data.frame(y, x1, x2, x3, x4)

model1 <- expectreg.ls(y ~ 1, data = data1, expectiles = c(0.1,0.2,0.5,0.8,0.9))
scope_rb1 <- y ~ rb(x1, type = 'pspline') + rb(x2, type = 'pspline') + 
                 x3 + rb(x4, type = 'pspline')

selected_rb1 <- stepExpect(model1, scope = scope_rb1, trace = TRUE)

plot(selected_rb1,ylim=c(-2,2),ylim_factors=c(0,7),cols="hcl")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
