\name{print.expectreg_selected}
\alias{print.expectreg_selected}
\alias{print}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Default expectreg_selected printing
}
\description{
Takes a \code{expectreg_selected} object and prints the table of selected covariates.
}
\usage{
\method{print}{expectreg_selected}(x, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
 an object of class \code{expectreg_selected}
}
  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
}
}
\details{
Prints the table of selected covariates, if possible.
}
%%\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
%%}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Elmar Spiegel
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{plot.expectreg_selected}}, \code{\link{stepExpect}} 
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- rpois(1000,1)
x4 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.3*x2 + x3 + eps
x3 <- factor(x3)
data1 <- data.frame(y, x1, x2, x3, x4)

model1 <- expectreg.ls(y ~ 1, data = data1, expectiles = c(0.1,0.2,0.5,0.8,0.9))
scope_rb1 <- y ~ rb(x1, type = 'pspline') + rb(x2, type = 'pspline') + 
                 x3 + rb(x4, type = 'pspline')

selected_rb1 <- stepExpect(model1, scope = scope_rb1, trace = TRUE)

selected_rb1
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
