\name{update.expectreg_selected}
\alias{update.expectreg_selected}
\alias{update}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Update the output of a model selection object
}
\description{
Updates the output of a model selection object of class \code{expectreg_selected}.
}
\usage{
\method{update}{expectreg_selected}(object, list_add_formula = NULL, data = NULL, lambda = 1, 
   ci = NULL,type = c("list_models","one_model","list_models_delta",
   "one_model_delta"), ...  )
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
object of class \code{expectreg_selected}, given by model selection.
}
  \item{list_add_formula}{
list of formulas for the changes. Default is using the formulas of \code{object}. (Take care of the ordering)
}
  \item{data}{
data for the updated model. Default is using the data of \code{object}.
}
  \item{lambda}{
initial value for smoothing parameter.
}
  \item{ci}{
Should confidence intervals be estimated in the updated model? Default is using the original ci type of \code{object}.
}
  \item{type}{Which type of output should be updated? Default is \code{"list_models"}. Update is only possible if this type is part of the original \code{object}.
  }
  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
}
}
\details{
Updates the output of a expectreg specific model selection. Non-negative garrote outputs are not updated, they should be restimated with the original estimation command \code{\link{garroteExpect}}.
}
\value{
object of class \code{expectreg_selected}, containing just the updated model.
}
\references{
To be published
}
\author{
Elmar Spiegel
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{update.expectreg}}, \code{\link{expectreg.ls}}
}
\examples{
set.seed(1)
x1 <- runif(500)
x2 <- runif(500)
x3 <- runif(500)
x4 <- runif(500)
eps <- rnorm(500,sd=5)

y <- 3*x1 + 1*x2 + x3 + eps
data1 <- data.frame(y, x1, x2, x3, x4)

model1 <- expectreg.ls(y ~ 1, data = data1, expectiles = c(0.1,0.2,0.5,0.8,0.9))
scope_rb1 <- y ~ x1 + x2 + x3 + x4

(selected_rb1 <- stepExpect(model1, scope = scope_rb1, type = "separately"))

# Update optimized model separately for each asymmetry parameter.
list_add_formula <- c(.~. - x4, 
                      .~. + x2,
                      .~.,
                      .~.,
                      .~.)

updated_model1 <- update(selected_rb1, list_add_formula = list_add_formula)

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
}
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
