## In "Stricly Proper Scoring Rules, Prediction, and Estimation" the Scroing function should be maximized. Out of this paper is the idea of building a grid etc.
## In "Making and evaluating point forecast" is the definition of the proper scoring function for expectiles. Here the function should be minimized.


# function for CV line number sampling
Sample_Numbers <- function(N_CV1,n_ges1) {
    Numbers_all1 <- 1:n_ges1
    Numbers_in1 <- list()
    Numbers_out1 <- list()
    size <- rep(n_ges1 %/% N_CV1, times=N_CV1)
    if(n_ges1%%N_CV1 != 0){
        for(d in 1:(n_ges1%%N_CV1)) {
            size[d] <- size[d] + 1
        }
    }
    Numbers_left1 <- Numbers_all1
    for(g in 1:N_CV1){
        Numbers_out1[[g]] <- sort(sample(Numbers_left1, size=size[g]))
        Numbers_in1[[g]]  <- sort(Numbers_all1[which(!(Numbers_all1 %in% Numbers_out1[[g]]))])
        Numbers_left1     <- Numbers_left1[which(!(Numbers_left1 %in% Numbers_out1[[g]]))]
    }
    erg <- list()
    erg[[1]] <- Numbers_out1  # Validation data
    erg[[2]] <- Numbers_in1   # Training data
    erg
}


build_Score <- function(Model,NewData,EQ=EQ,typeL=c("L1","L2","L4"),name_response=name_response,names_selection=names_selection,names_fixed=names_fixed,weight_vector=weight_vector) {
    if(typeL=="L1"){LL <- 1}
    if(typeL=="L2"){LL <- 2}
    if(typeL=="L4"){LL <- 4}
    # Apply model on validation dataset and estimate score
    if(EQ=="E") {
        PredModel <- predict(object=Model,newdata=NewData)                           
        w_Model <- matrix(Model$asymmetries, nrow=nrow(NewData), ncol=length(Model$asymmetries) , byrow=T)
        w_Model <- abs(w_Model - 1*(NewData[,which(names(NewData)==name_response)] < PredModel$fitted))
        # Commutated summation order due to weighting  
        erg <- sum(colSums(w_Model * abs(NewData[,which(names(NewData)==name_response)] - PredModel$fitted)^LL) * weight_vector)/nrow(NewData)   
        if(typeL == "L4") {
            erg <- sum(colSums(w_Model * (NewData[,which(names(NewData)==name_response)]^4 - PredModel$fitted^4 - 4*PredModel$fitted^3 * (NewData[,which(names(NewData)==name_response)]-PredModel$fitted))  ) * weight_vector)/nrow(NewData)
        }
    }
    if(EQ=="Q") {
        w_Model <- matrix(Model$tau , nrow=nrow(NewData)        , ncol=length(Model$tau) , byrow=T)
        PredModel <- predict(object=Model,newdata=NewData)                               
        w_Model <- abs(w_Model - 1*(NewData[,which(names(NewData)==name_response)] < PredModel))
        erg <- sum(colSums(w_Model * abs(NewData[,which(names(NewData)==name_response)] - PredModel)^LL) * weight_vector)/nrow(NewData)
        if(typeL == "L4") {
            erg <- sum(colSums(w_Model * (NewData[,which(names(NewData)==name_response)]^4 - PredModel^4 - 4*PredModel^3 * (NewData[,which(names(NewData)==name_response)]-PredModel))  ) * weight_vector)/nrow(NewData)
        }
    }
    erg
}  

build_Score2 <- function(data_in, Numbers, formula_in, N_CV=N_CV, expectiles_in_b, typeL=c("L1","L2","L4"), 
                         estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                         name_response=name_response, names_selection=names_selection, 
                         names_fixed=names_fixed, weight_vector=weight_vector) {
    if(typeL=="L1"){LL <- 1}
    if(typeL=="L2"){LL <- 2}
    if(typeL=="L4"){LL <- 4}
    erg <- rep(NA,times=N_CV)
    # Apply model on validation dataset and estimate score
    for(g in 1:N_CV) {
        Model <- expectreg.ls(formula = formula_in, expectiles=expectiles_in_b, data=data_in[Numbers[[2]][[g]],], estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
        NewData <- data_in[Numbers[[1]][[g]],]
        PredModel <- predict(object=Model,newdata=NewData)                           
        w_Model <- matrix(Model$asymmetries, nrow=nrow(NewData), ncol=length(Model$asymmetries) , byrow=T)
        w_Model <- abs(w_Model - 1*(NewData[,which(names(NewData)==name_response)] < PredModel$fitted))
        # Commutated summation order due to weighting  
        erg[g] <- sum(colSums(w_Model * abs(NewData[,which(names(NewData)==name_response)] - PredModel$fitted)^LL) * weight_vector)/nrow(NewData)   
        if(typeL == "L4") {
            erg[g] <- sum(colSums(w_Model * (NewData[,which(names(NewData)==name_response)]^4 - PredModel$fitted^4 - 4*PredModel$fitted^3 * (NewData[,which(names(NewData)==name_response)]-PredModel$fitted))  ) * weight_vector)/nrow(NewData)
        }
        
    }          
    mean(erg)
    }
                        
