
update.expectreg_selected <- function(object, list_add_formula = NULL, 
                                   data = NULL, lambda = 1, ci = NULL,
                                   type = c("list_models","one_model","list_models_delta","one_model_delta"),
                                    ... ) {
    type <- match.arg(type)
    list_updated_models <- NULL
    updated_one_model <- NULL
    list_delta_garrote <- NULL
    
    if(grepl("delta",type)) {stop("update model selected by non-negative garrote does not make sence. \n\r
                                  Re-estimate the model instead.")}
                                                              
    if((!is.null(object$list_models) | !is.null(object$list_models_delta)) & (type == "list_models" | type == "list_models_delta")) {
        if(type == "list_models" & !is.null(object$list_models)) {
            list_object <- object$list_models
        }
        if(type == "list_models_delta" & !is.null(object$list_models_delta)) {
            list_object <- object$list_models_delta
        }
        if(type == "list_models" & is.null(object$list_models)) {
            stop("type and object don't correspond")
        }
        if(type == "list_models_delta" & is.null(object$list_models_delta)) {
            stop("type and object don't correspond")
        }
        list_updated_models <- list()
        for(i in 1:length(list_object)) {
            estimate <- class(list_object[[i]])[2]
            smooth <- list_object[[i]]$smooth_orig
            expectiles <- list_object[[i]]$asymmetries
            delta_garrote <- list_object[[i]]$delta_garrote
            if(is.null(data)) {
                data <- list_object[[i]]$data
                }
            if(is.null(ci)) {
                ci <- FALSE
                if(!is.null(list_object[[i]]$covmat)) {ci <- TRUE}
            }
            if(is.null(list_add_formula)) {
                add_formula <- list_object[[i]]$formula
            } else {
                if(class(list_add_formula) == "list" & length(list_add_formula) == length(list_object)) {
                    add_formula <- update.formula(list_object[[i]]$formula,list_add_formula[[i]])
                } else { 
                    stop("list_add_formula not correct specified")
                }
            }
            
            
            
            list_updated_models[[i]] <- update(object=list_object[[i]],
                                            add_formula = add_formula,
                                            data = data, 
                                            estimate = estimate, 
                                            smooth = smooth,
                                            lambda = lambda, 
                                            expectiles = expectiles, 
                                            delta_garrote = delta_garrote, 
                                            ci = ci)#, ...)
        }
    }
    if((!is.null(object$one_model) | !is.null(object$one_model_delta)) & (type == "one_model" | type == "one_model_delta")) {
        if(type == "one_model" & !is.null(object$one_model)) {
            list_object <- object$one_model
        }
        if(type == "one_model_delta" & !is.null(object$one_model_delta)) {
            list_object <- object$one_model_delta
        }
        if(type == "one_model" & is.null(object$one_model)) {
            stop("type and object don't correspond")
        }
        if(type == "one_model_delta" & is.null(object$one_model_delta)) {
            stop("type and object don't correspond")
        }
        estimate <- class(list_object)[2]
        smooth <- list_object$smooth_orig
        expectiles <- list_object$asymmetries
        delta_garrote <- list_object$delta_garrote
        if(is.null(data)) {
            data <- list_object$data
            }
        if(is.null(ci)) {
            ci <- FALSE
            if(!is.null(list_object$covmat)) {ci <- TRUE}
        }
        if(is.null(list_add_formula)) {
            add_formula <- list_object$formula
        } else {
            add_formula <- update.formula(list_object$formula,list_add_formula)
        }
           
        updated_one_model <- update(object$one_model,
                                            add_formula=add_formula,
                                            data = data, 
                                            estimate = estimate, 
                                            smooth = smooth,
                                            lambda = lambda, 
                                            expectiles = expectiles, 
                                            delta_garrote = delta_garrote, 
                                            ci = ci, ...)
        }
    results <- list()
    if(type == "list_models")       {results$list_models       <- list_updated_models}
    if(type == "list_models_delta") {results$list_models_delta <- list_updated_models}
    if(type == "one_model")         {results$one_model         <- updated_one_model}
    if(type == "one_model_delta")   {results$one_model_delta   <- updated_one_model}
    class(results) <- class(object)
    results
    }


