\name{criteria}
%\alias{AIC.expectreg}
\alias{AIC_Area_Score.expectreg}
\alias{OCV.expectreg}
\alias{GCV.expectreg}
\alias{CV_Score.expectreg}
\alias{Scoring_Score.expectreg}
\alias{weighted_sum_errors.expectreg}
\alias{AIC_Area_Score}
\alias{OCV}
\alias{GCV}
\alias{CV_Score}
\alias{Scoring_Score}
\alias{weighted_sum_errors}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Model selection criteria for expectile regression objects
}
\description{
Model selection criteria for objects returned by expectile regression functions.
}
\usage{
%\method{AIC}{expectreg}(object, ..., k = 2)

\method{OCV}{expectreg}(object, ...)

\method{GCV}{expectreg}(object, ...)

\method{weighted_sum_errors}{expectreg}(object, ...)

\method{CV_Score}{expectreg}(object, N_CV = 5, ...)

\method{AIC_Area_Score}{expectreg}(object, k = 2, grid_alpha = 50, weight = 1, 
interval = c(-1, 2), ...)

\method{Scoring_Score}{expectreg}(object, N_CV = 5, grid_alpha = 50, weight = 1, 
interval = c(-1, 2), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
of class \code{expectreg}
}
  \item{...}{ Only for consistency with generic }
  \item{k}{
degress of freedom for AIC. \code{k = 2} is classical AIC, \code{k = log(n)} is BIC.
}
  \item{N_CV}{
Number of cross validations
}
  \item{grid_alpha}{
Number of asymmetry parameters (+ 1) used for the grid of models.
}
  \item{weight}{
optional weight \eqn{\omega} for a specified \code{interval} of asymmetry parameters}
  \item{interval}{
optional interval to \code{weight} special part of the distribution at the summation of the different scores per asymmetry parameter.
}
}

\details{
\describe{
  \item{AIC}{Estimates the AIC of for each asymmetry \eqn{\tau} parameters separately. The AIC is here defined as
\deqn{n \cdot log(\frac{1}{n} \sum\limits_{i=1}^{n}{w_{\tau}(y_i)(y_i-\hat{y}_i)^2}) + k \cdot trace(H)}
where H is the hat matrix of the expectile regression model. For \eqn{k=2} it's the AIC for \eqn{k=log(n)} it's the BIC.
}

  \item{OCV}{Estimates the OCV of for each asymmetry \eqn{\tau} parameters separately. The OCV is here defined as
\deqn{\frac{1}{n} \sum\limits_{i=1}^{n}{\frac{w_{\tau}(y_i)(y_i-\hat{y}_i)^2} {(1-(H_{ii})^2)}}}
where H is the hat matrix of the expectile regression model.
}

  \item{GCV}{Estimates the GCV of for each asymmetry \eqn{\tau} parameters separately. The GCV is here defined as
\deqn{\frac{\frac{1}{n} \sum\limits_{i=1}^{n}{w_{\tau}(y_i)(y_i-\hat{y}_i)^2}} {(1-(1+trace(H)/n))^2}}
where H is the hat matrix of the expectile regression model.
}

  \item{weighted_sum_errors}{Estimates the mean asymmetric weighted errors of the given object for each asymmetry separately.
\deqn{ \frac{1}{n} \sum\limits_{i=1}^{n}{w_{\tau}(y_i)(y_i - \hat{y}_{i,\tau})^{2}}}
}

  \item{CV_Score}{Estimates the CV score for all asymmetry parameters separately.\cr
Therefore cross validation is applied and the model is re-estimated N_CV = G times. Each time the predicted asymmetric sum of weighted errors is estimated for each asymmetry parameter separately. Finally the errors are combined over all cross validations 
\deqn{ \frac{1}{G} \sum\limits_{g=1}^G { \frac{1}{n_g} \sum\limits_{i=1}^{n_g}{w_{\tau}(y_i)(y_i - \hat{y}_{i,\tau})^{2}}}}
where \eqn{n_g} is the number of observations in validation data set number g.
}

  \item{AIC_Area_Score}{Estimates the AIC for all asymmetry parameters of a grid jointly.\cr
Therefore the model is re-estimated on the given grid. The AIC is estimated for each asymmetry parameter of the grid separately. Finally the AICs are combined over all asymmetry parameters. Totally this can be written as
\deqn{ \frac{1}{J} \cdot \sum\limits_{j=1}^{J}{ AIC_{\tau_j}(y) \cdot \omega_j}
}
where J is the length of the grid and \eqn{\omega_j} is a potential weight for specific parts of the distribution.
}

  \item{Scoring_Score}{Estimates the scoring score for all asymmetry parameters of a grid jointly.\cr
Therefore cross validation is applied and the model is re-estimated N_CV = G times on the grid of asymmetry parameters. Each time the predicted asymmetric sum of weighted errors is estimated for each asymmetry parameter of the grid separately. Finally the errors are combined over all cross validations and asymmetry parameters as
\deqn{ \frac{1}{J} \cdot \sum\limits_{j=1}^{J}{(\frac{1}{G} \sum\limits_{g=1}^G { \frac{1}{n_g} \sum\limits_{i=1}^{n_g}{w_{\tau_j}(y_i)(y_i - \hat{y}_{i,\tau_j})^{2}}}) \cdot \omega_j}
}
where J is the length of the grid and \eqn{n_g} is the number of observations in validation data set number g and \eqn{\omega_j} is a potential weight  for specific parts of the distribution.
}


}
}
\value{
  \item{\code{AIC}}{Vector of the estimated AIC per asymmetry.}
  \item{\code{OCV}}{Vector of the estimated OCV per asymmetry.}
  \item{\code{GCV}}{Vector of the estimated GCV per asymmetry.}
  \item{\code{weighted_sum_errors}}{Vector weighted errors per asymmetry parameter.}
  
  \item{\code{CV_Score}}{list of two objects
  
    \code{score_all} Mean of \code{score_vec} (for comparision with \code{Scoring_Score(...)})
    
    \code{score_vec} Vector with the mean score per asymmetry (desired number)
}
  \item{\code{AIC_Area_Score}}{list of two objects
  
    \code{score_all} Weighted mean of \code{score_vec} (desired number)
    
    \code{score_vec} Vector with the AIC per asymmetry (for comparision with \code{AIC(...)} and \code{Scoring_Score})
  }
  \item{\code{Scoring_Score}}{list of two objects
  
    \code{score_all} Weighted mean of \code{score_vec} (desired number)
    
    \code{score_vec} Vector with the mean score per asymmetry (for comparision with \code{CV_Score(...)})
  }
  
  }
\references{
To be published\cr

Schnabel S and Eilers P (2009)
\emph{ Optimal expectile smoothing }
Computational Statistics and Data Analysis, 53:4168-4177

Sobotka F and Kneib T (2010)
\emph{ Geoadditive Expectile Regression }
Computational Statistics and Data Analysis,
doi: 10.1016/j.csda.2010.11.015.
}
\author{
Elmar Spiegel and Fabian Sobotka
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{stepExpect}}, \code{\link{bestExpect}}
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.75*x2 + eps

data1 <- data.frame(y, x1, x2, x3)

model1 <- expectreg.ls(y ~ x1 + x2 + x3, data = data1, expectiles = c(0.1,0.5,0.9))

# test the different model selection criteria
AIC(model1, k=2)

AIC(model1, k=log(1000))

OCV(model1)

GCV(model1)

weighted_sum_errors(model1)

CV_Score(model1, N_CV = 5)

AIC_Area_Score(model1, k = 2, grid_alpha = 50)
AIC_Area_Score(model1, k = 2, grid_alpha = 50, weight = 10, interval = c(0,0.11))

Scoring_Score(model1, N_CV = 5, grid_alpha = 50)


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
