
plot_legend_points <- function(expectiles = c(0.05,0.2,0.5,0.8,0.95), cols = "hcl",
                               hcl.par = list(h=c(260,0), c=185, l=c(30,85)), par_new = FALSE, cex = 2 )  {
    op <- par(no.readonly = TRUE)
    pp <- expectiles
    np.plot <- length(pp)
    col_vector <- rainbow(np.plot+1)[1:np.plot]
    if(cols == "hcl") {
        col_vector <- colorspace::diverge_hcl(n=np.plot,h=hcl.par$h,c=hcl.par$c,l=hcl.par$l)[1:np.plot]
    }
    if(par_new) par(mar=c(0,0,0,0),oma=c(0,0,0,0))
    plot.new()
    legend(x="center", pch=19, cex=cex, col=rev(col_vector), legend=rev(pp), bg="white", bty="n")
    par(op)
}
