renameTableBoosting <- function(SelectedMatrix) {
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(cbirthorder, intercept = F)"      )] <- "cbirthorder"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(caesarian, intercept = F)"        )] <- "caesarian"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(deadchildrenD, intercept = F)"    )] <- "deadchildrenD"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(householdhead, intercept = F)"    )] <- "householdhead"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(householdmembers, intercept = F)" )] <- "householdmembers"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(meduC, intercept = F)"            )] <- "meduC"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(edupartnerC, intercept = F)"      )] <- "edupartnerC"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(csex, intercept = F)"             )] <- "csex"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(bicycle, intercept = F)"          )] <- "bicycle"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(electricity, intercept = F)"      )] <- "electricity"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(motorcycle, intercept = F)"       )] <- "motorcycle"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(radio, intercept = F)"            )] <- "radio"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(refrigerator, intercept = F)"     )] <- "refrigerator"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(telephone, intercept = F)"        )] <- "telephone"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(television, intercept = F)"       )] <- "television"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(breastfeeding, intercept = F)"    )] <- "breastfeeding"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bbs(breastfeeding, center = T)"        )] <- "breastfeeding_prb"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(cage, intercept = F)"             )] <- "cage"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bbs(cage, center = T)"                 )] <- "cage_prb"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(mage, intercept = F)"             )] <- "mage"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bbs(mage, center = T)"                 )] <- "mage_prb"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(mbmi, intercept = F)"             )] <- "mbmi"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bbs(mbmi, center = T)"                 )] <- "mbmi_prb"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bols(mheight, intercept = F)"          )] <- "mheight"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bbs(mheight, center = T)"              )] <- "mheight_prb"
    rownames(SelectedMatrix)[which(rownames(SelectedMatrix) == "bmrf(mregion, bnd = mapPeru2)"          )] <- "mregion"
    SelectedMatrix
    }

renameTable <- function(table_in) {
    rownames(table_in)[which(rownames(table_in) == "cbirthorder")] <- "birth order &"
    rownames(table_in)[which(rownames(table_in) == "caesarian")] <- "caesarian &"
    rownames(table_in)[which(rownames(table_in) == "deadchildrenD")] <- "dead children &"
    rownames(table_in)[which(rownames(table_in) == "householdhead")] <- "household head &"
    rownames(table_in)[which(rownames(table_in) == "householdmembers")] <- "householdmembers &"
    rownames(table_in)[which(rownames(table_in) == "meduC")] <- "mother's education &"
    rownames(table_in)[which(rownames(table_in) == "edupartnerC")] <- "partner's education &"
    rownames(table_in)[which(rownames(table_in) == "csex")] <- "sex &"
    rownames(table_in)[which(rownames(table_in) == "bicycle")] <- "bicycle &"
    rownames(table_in)[which(rownames(table_in) == "electricity")] <- "electricity &"
    rownames(table_in)[which(rownames(table_in) == "motorcycle")] <- "motorcycle &"
    rownames(table_in)[which(rownames(table_in) == "radio")] <- "radio &"
    rownames(table_in)[which(rownames(table_in) == "refrigerator")] <- "refrigerator &"
    rownames(table_in)[which(rownames(table_in) == "telephone")]  <- "telephone &"
    rownames(table_in)[which(rownames(table_in) == "television")] <- "television &"
    rownames(table_in)[which(rownames(table_in) == "breastfeeding")]     <- "breastfeeding & linear"
    rownames(table_in)[which(rownames(table_in) == "breastfeeding_prb")] <- "breastfeeding & nonlinear"
    rownames(table_in)[which(rownames(table_in) == "cage")]     <- "child's age & linear"
    rownames(table_in)[which(rownames(table_in) == "cage_prb")] <- "child's age & nonlinear"
    rownames(table_in)[which(rownames(table_in) == "mage")]     <- "mother's age & linear"
    rownames(table_in)[which(rownames(table_in) == "mage_prb")] <- "mother's age & nonlinear"
    rownames(table_in)[which(rownames(table_in) == "mbmi")]     <- "mother's bmi & linear"
    rownames(table_in)[which(rownames(table_in) == "mbmi_prb")] <- "mother's bmi & nonlinear"
    rownames(table_in)[which(rownames(table_in) == "mheight")]  <- "mother's height & linear"
    rownames(table_in)[which(rownames(table_in) == "mheight_prb")] <- "mother's height & nonlinear"
    rownames(table_in)[which(rownames(table_in) == "mregion")] <- "region & GMRF"
    table_in
    }

order_rows <- c("cbirthorder", "caesarian", "deadchildrenD", "householdhead", 
            "householdmembers", "meduC", "edupartnerC", "csex", "bicycle", "electricity", 
            "motorcycle", "radio", "refrigerator", "telephone", "television", 
            "breastfeeding", "breastfeeding_prb", 
            "cage", "cage_prb", 
            "mage", "mage_prb", 
            "mbmi", "mbmi_prb", 
            "mheight", "mheight_prb", 
            "mregion")


rename_xlab <- function(xlab_old) {
    xlab_new <- xlab_old
    xlab_new[which(xlab_old == "cbirthorder")] <- "birth order"
    xlab_new[which(xlab_old == "caesarian")] <- "caesarian"
    xlab_new[which(xlab_old == "deadchildrenD")] <- "dead children"
    xlab_new[which(xlab_old == "householdhead")] <- "household head"
    xlab_new[which(xlab_old == "householdmembers")] <- "householdmembers"
    xlab_new[which(xlab_old == "meduC")] <- "mother's education"
    xlab_new[which(xlab_old == "edupartnerC")] <- "partner's education"
    xlab_new[which(xlab_old == "csex")] <- "sex"
    xlab_new[which(xlab_old == "bicycle")] <- "bicycle"
    xlab_new[which(xlab_old == "electricity")] <- "electricity"
    xlab_new[which(xlab_old == "motorcycle")] <- "motorcycle"
    xlab_new[which(xlab_old == "radio")] <- "radio"
    xlab_new[which(xlab_old == "refrigerator")] <- "refrigerator"
    xlab_new[which(xlab_old == "telephone")]  <- "telephone"
    xlab_new[which(xlab_old == "television")] <- "television"
    xlab_new[which(xlab_old == "breastfeeding")]     <- "breastfeeding linear"
    xlab_new[which(xlab_old == "breastfeeding_prb")] <- "breastfeeding nonlinear"
    xlab_new[which(xlab_old == "cage")]     <- "child's age linear"
    xlab_new[which(xlab_old == "cage_prb")] <- "child's age nonlinear"
    xlab_new[which(xlab_old == "mage")]     <- "mother's age linear"
    xlab_new[which(xlab_old == "mage_prb")] <- "mother's age nonlinear"
    xlab_new[which(xlab_old == "mbmi")]     <- "mother's bmi linear"
    xlab_new[which(xlab_old == "mbmi_prb")] <- "mother's bmi nonlinear"
    xlab_new[which(xlab_old == "mheight")]  <- "mother's height linear"
    xlab_new[which(xlab_old == "mheight_prb")] <- "mother's height nonlinear"
    xlab_new[which(xlab_old == "mregion")] <- "region"
    xlab_new 
}



