# function to construct the model, dvec, Dmat, Amat
construct_Parameter_solveQP <- function(data_est, expectiles_in1, 
                                        formula_all_possible = formula_all_possible, 
                                        names_selection_short = names_selection_short, 
                                        names_fixed_short = names_fixed_short, 
                                        name_response = name_response, 
                                        estimate_in = estimate_in, 
                                        smooth_in = smooth_in, 
                                        ci_in = ci_in, 
                                        lambda_in = lambda_in) {
    
    Model <- expectreg.ls(formula_all_possible,data=data_est,expectiles=expectiles_in1, estimate = estimate_in, 
                          smooth = smooth_in, ci = ci_in, lambda = lambda_in)
    weight <- abs(expectiles_in1 - 1*(data_est[,which(names(data_est)==name_response)] < Model$fitted))
    
    WW <- Diagonal(x=as.vector(weight))
    FF <- NULL
    for(u in names_selection_short) {
        FF <- cbind(FF,(Model$values[[which(names(Model$values)==u)]]-Model$intercept))
    }
    
    FF_Rest <- matrix(Model$intercept,nrow=nrow(data_est),ncol=1)
    for(u in names_fixed_short) {
        FF_Rest <- cbind(FF_Rest,(Model$values[[which(names(Model$values)==u)]]-Model$intercept))
    }
    
    if(is.null(names_fixed_short)) {
        FF_Rest_sum <- FF_Rest
    }
    
    if(!is.null(names_fixed_short)) {
        FF_Rest_sum <- rowSums(FF_Rest)
    }
    
    
    y_F  <- t((Model$response) - FF_Rest_sum)
    
    dvec <- as.vector( y_F %*% WW %*% FF)
    Dmat <- t(FF) %*% WW %*% FF
    Amat <- diag(rep(1,ncol(FF)))
    Amat <- cbind(rep(1,ncol(FF)),Amat)
    list("Model"=Model,"WW"=WW,"FF"=FF,"y_F"=y_F,"dvec"=dvec,"Dmat"=Dmat,"Amat"=Amat)
}

# function to build F, weights, and predicted values for cross validation
construct_Parameters_validate <- function(data_valid, Model, expectiles_in1, 
                                          names_selection_short = names_selection_short, 
                                          names_fixed_short = names_fixed_short, 
                                          name_response = name_response) {
    Model_valid <- predict(Model,newdata = data_valid)
    weight_valid <- abs(expectiles_in1 - 1*(data_valid[,which(names(data_valid)==name_response)] < Model_valid$fitted))
    
    FF_valid <- NULL
    for(u in names_selection_short) {
        FF_valid <- cbind(FF_valid,t(Model_valid$values[[which(names(Model$values)==u)]])-Model$intercept)
    }
    
    FF_Rest_valid <- matrix(Model$intercept,nrow=nrow(data_valid),ncol=1)
    for(u in names_fixed_short) {
        FF_Rest_valid <- cbind(FF_Rest_valid,t(Model_valid$values[[which(names(Model$values)==u)]])-Model$intercept)
    }
    
    if(is.null(names_fixed_short)) {
        FF_Rest_sum_valid <- FF_Rest_valid
    }
    
    
    if(!is.null(names_fixed_short)) {
        FF_Rest_sum_valid <- rowSums(FF_Rest_valid)
    }
    
    
    y_F_valid  <- t(data_valid[,which(names(data_valid) == name_response)] - FF_Rest_sum_valid)
    
    
    list("FF_valid"=FF_valid,"weight_valid"=weight_valid, "y_F_valid"=y_F_valid)    
}

# estimate CV error
build_Diff_per_gamma <- function(Gamma1, data_valid, List_Parameter_validate,
                                 List_Parameter_solveQP,
                                 expectiles_in1 = 0.2, delta_min = delta_min) { 
    #Model <- List_Parameter_solveQP$Model
    bvec <- c(Gamma1,rep(0,times=ncol(List_Parameter_solveQP$FF)))
    
    temp_delta <- solve.QP(Dmat=List_Parameter_solveQP$Dmat, 
                           dvec=List_Parameter_solveQP$dvec, 
                           Amat=List_Parameter_solveQP$Amat, 
                           bvec=bvec, meq=1)$solution 
    
    if(delta_min > 0) {
        temp_delta2 <- temp_delta
        temp_delta2[temp_delta < delta_min] <- 0
        temp_delta_diff <- sum(abs(temp_delta2 - temp_delta))
        if(temp_delta_diff < length(temp_delta)*delta_min | all.equal(temp_delta,temp_delta2)) {
            delta <- temp_delta2
        } else {
            delta <- temp_delta
        }
    } else {
        delta <- temp_delta
    }
    
    #Model_valid  <- List_Parameter_validate$Model_valid
    weight_valid <- List_Parameter_validate$weight_valid
    y_F_valid    <- t(List_Parameter_validate$y_F_valid)
    
    FF_valid     <- List_Parameter_validate$FF_valid
    
    Pred_d       <- FF_valid %*% delta
    Diff         <- mean(weight_valid*(y_F_valid-Pred_d)^2)
    Diff
}

garroteExpect_separately <- function(object, scope = NULL, output_type = c("list_models_delta", "list_models", "one_model_delta", "one_model"), 
                               trace = FALSE, lambda = 1, N_CV = 5, 
                               grid_gamma = 50, delta_min = 2.5e-16, fix_gamma = NULL, 
                               start_gamma = 1e-04, split = c("no","complete","restricted")) {
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    output_type_orig <- output_type
    if("one_model_delta" %in% output_type & !"list_models_delta" %in% output_type) {
        output_type <- c(output_type, "list_models_delta")
    }
    if("one_model" %in% output_type & !"list_models" %in% output_type) {
        output_type <- c(output_type, "list_models")
    }
    
    split <- match.arg(split)
    
    if(class(object)[1] != "expectreg") {stop("Garrote only for class expectreg")}
    
    Transposed_Input     <- transpose_input(object=object,scope=scope,lambda_transpose=lambda,split=split)
    formula_selection    <- Transposed_Input$formula_selection
    formula_fixed        <- Transposed_Input$formula_fixed
    names_selection      <- Transposed_Input$names_selection
    names_fixed          <- Transposed_Input$names_fixed
    name_response        <- Transposed_Input$name_response
    data_in              <- Transposed_Input$data_in
    EQ                   <- Transposed_Input$EQ
    expectiles_in        <- Transposed_Input$expectiles_in
    estimate_in          <- Transposed_Input$estimate_in
    lambda_in            <- Transposed_Input$lambda_in
    smooth_in            <- Transposed_Input$smooth_in
    ci_in                <- Transposed_Input$ci_in
    NumberOfVariables    <- Transposed_Input$NumberOfVariables
    NumberOfModels       <- Transposed_Input$NumberOfModels
    NumberOfExpectiles   <- Transposed_Input$NumberOfExpectiles
    
    names_selection_short <- Transposed_Input$names_selection_short
    names_fixed_short     <- Transposed_Input$names_fixed_short
    xnames_selection      <- Transposed_Input$xnames_selection
    xnames_fixed          <- Transposed_Input$xnames_fixed
    
    vec_s_split_orig     <- Transposed_Input$vec_s_split_orig
    vec_s_xname_orig     <- Transposed_Input$vec_s_xname_orig
    if(split == 'restricted') { 
        stop("'restricted' is not compatible with nonnegative garrote.\n\r Use 'complete' or 'no'.")}
    
    if(estimate_in != "laws")
        stop("garroteExpect(..., type = 'separately') only possible for estimate = 'laws'!")
    
    
    names_all_possible         <- c(names_selection,names_fixed)
    names_all_possible_short   <- c(names_selection_short,names_fixed_short)
    formula_all_possible       <- as.formula(paste(name_response, " ~ ", paste(names_all_possible, collapse=" + "), sep=""),env=.GlobalEnv)
    
    anova <- list()
    
    arguments <- list()
    arguments$N_CV <- N_CV
    arguments$lambda <- lambda
    arguments$delta_min <- delta_min
    arguments$split <- split
    arguments$grid_alpha <- 50
    arguments$grid_gamma <- grid_gamma
    arguments$fix_gamma <- fix_gamma
    arguments$start_gamma <- start_gamma
    arguments$output_type <- output_type
    
    anova$arguments <- arguments
    
    rm(Transposed_Input)
    
    if(!is.null(fix_gamma)) {
        if(length(fix_gamma) != length(expectiles_in)) {stop("fixed gamma and number of Expectiles do not match")}
        if(length(fix_gamma) == length(expectiles_in)) {
            if(any(fix_gamma > NumberOfVariables)) {stop("fixed gamma are larger than number of covariates")}
            if(any(fix_gamma <= 0)) {stop("fixed gamma is negative or 0")}
            if(all(0 < fix_gamma) && all( fix_gamma <= NumberOfVariables)) {cat("\n\r", "Gamma is fixed to ", fix_gamma ,"\n\r")}
        }
    }
    gamma_opt <- list()
    delta_opt <- list()
    for(tt in 1:NumberOfExpectiles) {
        anova[[tt]] <- list()
        
        expectiles_in1 <- expectiles_in[tt]
        Gamma_vec <- seq(start_gamma,NumberOfVariables,length=grid_gamma)
        Diff <- matrix(NA,nrow=length(Gamma_vec),ncol=N_CV)
        Numbers_G <- Sample_Numbers(N_CV1 = N_CV,n_ges1=nrow(data_in))
        
        if(is.null(fix_gamma)) {
            # estimate CV error for each validation dataset and each Gamma    
            for(g in 1:N_CV) {
                List_Parameter_solveQP  <- construct_Parameter_solveQP  (data_est = data_in[Numbers_G[[2]][[g]],], 
                                                                         expectiles_in1 = expectiles_in1, 
                                                                         formula_all_possible = formula_all_possible, 
                                                                         names_selection_short = names_selection_short, 
                                                                         names_fixed_short = names_fixed_short, 
                                                                         name_response = name_response, 
                                                                         estimate_in = estimate_in, 
                                                                         smooth_in = smooth_in, 
                                                                         ci_in = ci_in, lambda_in = lambda_in) 
                List_Parameter_validate <- construct_Parameters_validate(data_valid = data_in[Numbers_G[[1]][[g]],] , 
                                                                         Model  =List_Parameter_solveQP$Model, 
                                                                         expectiles_in1 = expectiles_in1, 
                                                                         names_selection_short = names_selection_short, 
                                                                         names_fixed_short = names_fixed_short, 
                                                                         name_response = name_response) 
                
                for(j in 1:length(Gamma_vec)) {
                    Diff[j,g] <- build_Diff_per_gamma(Gamma1=Gamma_vec[j] , 
                                                      data_valid=data_in[Numbers_G[[1]][[g]],] ,
                                                      List_Parameter_validate = List_Parameter_validate , 
                                                      List_Parameter_solveQP = List_Parameter_solveQP , 
                                                      expectiles_in1=expectiles_in1, delta_min=delta_min) 
                }
            }
            
            # Find optimal Gamma
            Diff_Gamma <- rowMeans(Diff)
            gamma_opt[[tt]] <- Gamma_vec[which.min(Diff_Gamma)]
            anova[[tt]]$gamma_values   <- rbind(Gamma_vec,Diff_Gamma)
            rownames(anova[[tt]]$gamma_values) <- c("gamma","MSE_per_gamma")
        }
        
        if(!is.null(fix_gamma)) {
            gamma_opt[[tt]] <- fix_gamma[tt]
            anova[[tt]]$gamma_values <- NULL
        }
        
        anova[[tt]]$gamma_opt      <- gamma_opt[[tt]]
        
        # use this optimal gamma to estimate delta on the whole dataset
        List_Parameter_solveQP_all <- construct_Parameter_solveQP(data_est = data_in,
                                                                  expectiles_in1 = expectiles_in1,
                                                                  formula_all_possible = formula_all_possible, 
                                                                  names_selection_short = names_selection_short, 
                                                                  names_fixed_short = names_fixed_short, 
                                                                  name_response = name_response, 
                                                                  estimate_in = estimate_in, 
                                                                  smooth_in = smooth_in, 
                                                                  ci_in = ci_in, 
                                                                  lambda_in = lambda_in) 
        bvec_all <- c(gamma_opt[[tt]],rep(0,times=ncol(List_Parameter_solveQP_all$FF)))
        
        temp_delta_opt <- solve.QP(Dmat = List_Parameter_solveQP_all$Dmat , dvec = List_Parameter_solveQP_all$dvec , 
                                   Amat = List_Parameter_solveQP_all$Amat , bvec=bvec_all , meq=1)$solution
        if(delta_min > 0) {
            temp_delta_opt2 <- temp_delta_opt
            temp_delta_opt2[temp_delta_opt < delta_min] <- 0
            temp_delta_diff <- sum(abs(temp_delta_opt2 - temp_delta_opt))
            if(temp_delta_diff < length(temp_delta_opt)*delta_min | all.equal(temp_delta_opt,temp_delta_opt2)) {
                delta_opt[[tt]] <- temp_delta_opt2
            } else {
                delta_opt[[tt]] <- temp_delta_opt
            }
        } else {
            delta_opt[[tt]] <- temp_delta_opt
        }
        
        names(delta_opt[[tt]]) <- names_selection_short
        if(!is.null(names_fixed)) {
            delta_opt[[tt]] <- c(delta_opt[[tt]],rep(1,times=length(names_fixed)))
            names(delta_opt[[tt]]) <- c(names_selection_short,paste(names_fixed_short,"(fixed)"))
        }
        anova[[tt]]$delta_opt      <- delta_opt[[tt]]
        
    }
    
    Output_model <- NULL
    if("list_models" %in% output_type) {
        Output_model <- list()
        formula_tt <- formula_all_possible
        for(tt in 1:length(expectiles_in)) {
            Output_model[[tt]] <- expectreg.ls(formula_tt,data=data_in, expectiles=expectiles_in[tt], estimate = estimate_in, 
                                               smooth = smooth_in, ci = ci_in, lambda = lambda_in)
        }
    }
    
    Output_model_delta <- NULL
    if("list_models_delta" %in% output_type) {
        Output_model_delta <- list()
        formula_tt <- formula_all_possible
        for(tt in 1:length(expectiles_in)) {
            Output_model_delta[[tt]] <- expectreg.ls(formula_tt, data=data_in, expectiles=expectiles_in[tt], estimate = estimate_in, 
                                                     smooth = smooth_in, ci = ci_in, lambda = lambda_in, delta_garrote = delta_opt[[tt]])
        }
    }
    
    Output_one_model <- NULL
    if("one_model" %in% output_type) {
        Output <- NULL
        for(tt in 1:length(expectiles_in)) {
            Output[[tt]] <- sort_covariates(Output_model[[tt]]$formula)
        }
        Vec_formula_join <- unique(unlist(Output))
        formula_join <-  as.formula(paste(name_response, " ~ ", paste(Vec_formula_join,collapse=" + "),sep=""))
        Output_one_model <- expectreg.ls(formula_join, data = data_in, expectiles = expectiles_in, 
                                         estimate = estimate_in, smooth = smooth_in, ci = ci_in, 
                                         lambda = lambda_in, list_models = Output_model)
        
    }
    
    Output_one_model_delta <- NULL
    if("one_model_delta" %in% output_type) {
        Output_delta <- NULL
        for(tt in 1:length(expectiles_in)) {
            Output_delta[[tt]] <- sort_covariates(Output_model_delta[[tt]]$formula)
        }
        
        Vec_formula_join_delta <- unique(unlist(Output_delta))
        formula_join_delta <-  as.formula(paste(name_response, " ~ ", paste(Vec_formula_join_delta, collapse=" + "),sep=""))
        Output_one_model_delta <- expectreg.ls(formula_join_delta, data = data_in, expectiles = expectiles_in, 
                                               estimate = estimate_in, smooth = smooth_in, ci = ci_in, 
                                               lambda = lambda_in, list_models = Output_model_delta)
        
    }
    
    
    
    formular_Garrote_temp_list <- list()
    for(tt in 1:NumberOfExpectiles) {
        formular_Garrote_temp <- NULL
        vec_modell_garrote_true <- F
        for(u in 1:length(names_selection)) {
            if(abs(delta_opt[[tt]][which(names(delta_opt[[tt]]) == names_selection_short[u])]) >= delta_min) {
                vec_modell_garrote_true <- T
                formular_Garrote_temp <- c(formular_Garrote_temp,names_selection[u])
            }
        }
        formular_Garrote_temp <- c(formular_Garrote_temp,names_fixed)
        
        if(!vec_modell_garrote_true) {
            if(is.null(names_fixed)) {
                formular_Garrote_temp <- "1"
            }
            if(!is.null(names_fixed)) {
                formular_Garrote_temp <- names_fixed
            }
        }
        formular_Garrote_temp_list[[tt]] <- formular_Garrote_temp
        anova[[tt]]$best_model <- paste(name_response, "~", paste(formular_Garrote_temp_list[[tt]],collapse=" + "))
    }
    
    
    names(anova) <- paste("Expectile",expectiles_in,sep="")
    
    
    table_delta_opt <- matrix(0,ncol=length(expectiles_in),nrow=length(names(anova[[1]]$delta_opt)))
    
    rownames(table_delta_opt) <- names(anova[[1]]$delta_opt)
    colnames(table_delta_opt) <- expectiles_in
    All_covariates       <- c(names_fixed,      names_selection)
    All_covariates_short <- c(names_fixed_short,names_selection_short)
    for(tt in 1:length(expectiles_in)) {
        table_delta_opt[,tt] <- anova[[tt]]$delta_opt
    }
    
    table_selected <- table_delta_opt
    table_selected[table_selected <=  delta_min] <- 0
    table_selected[table_selected > delta_min] <- 1
    
    anova$names_selection <- names_selection
    anova$names_fixed <- names_fixed
    
    anova$table_selected <- table_selected
    anova$table_delta_opt <- table_delta_opt
    
    if(trace) {
        cat("\n\r")
        print(anova,digits=4,quote=F)
        cat("\n\r")
    }
    
    result <- list("anova"=anova)    
    if("list_models"          %in% output_type_orig) { result$list_models          <- Output_model      }
    if("list_models_delta"    %in% output_type_orig) { result$list_models_delta    <- Output_model_delta}
    if("one_model"            %in% output_type_orig) { result$one_model            <- Output_one_model}
    if("one_model_delta"      %in% output_type_orig) { result$one_model_delta      <- Output_one_model_delta}
    
    #if("IndexBestModel" %in% output_type) { result$IndexBestModel <- IndexBestModel    }
    class(result) = c("expectreg_selected", "garroteExpect", "separately", "CV")
    
    result
}










