\name{update.expectreg}
\alias{update.expectreg}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Update given expectreg model
}
\description{
Updates a given expectreg model with the specified changes
}
\usage{
\method{update}{expectreg}(object, add_formula, data = NULL, estimate = NULL, 
smooth = NULL, lambda = NULL, expectiles = NULL, delta_garrote = NULL, ci = NULL, 
...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
of class expectreg
}
  \item{add_formula}{
update for formula
}
  \item{data}{
Should other data be used
}
  \item{estimate}{
Change estimate
}
  \item{smooth}{
Change smooth
}
  \item{lambda}{
Change lambda
}
  \item{expectiles}{
Change asymmetries
}
  \item{delta_garrote}{
Change delta_garrote
}
  \item{ci}{
Change ci
}
  \item{\dots}{
%%     ~~Describe \code{\dots} here~~
}
}
\details{
Re-estimates the given model, with the specified changes. If nothing is specified the characteristics of the original model are used. Except lambda here the default 1 is used as initial value.
}
\value{
object of class \code{expectreg}
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Elmar Spiegel
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[stats]{update}}, \code{\link[stats]{update.formula}}
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- rpois(1000,1)
x4 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.3*x2 + x3 + eps
x3 <- factor(x3)
data1 <- data.frame(y, x1, x2, x3, x4)

model1 <- expectreg.ls(y ~ rb(x1, type = 'pspline') + rb(x2, type = 'pspline') + x3, 
                       data = data1, expectiles = c(0.2,0.5,0.8))

# Change formula and update model
add_formula <- .~. + x4
updated_model1 <- update(model1, add_formula)

# Use different asymmetries and update model
updated_model2 <- update(model1, expectiles = c(0.1,0.2,0.5,0.8,0.9))

plot(model1        , ylim = c(-2,2), ylim_factor = c(0,7), cols = "hcl", ask = FALSE)
plot(updated_model1, ylim = c(-2,2), ylim_factor = c(0,7), cols = "hcl", ask = FALSE)
plot(updated_model2, ylim = c(-2,2), ylim_factor = c(0,7), cols = "hcl", ask = FALSE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
