#########################################
### StepAIC for each alpha separately ###
#########################################

stepExpect_separately <- function(object, scope = NULL, output_type = c("list_models", "one_model"), 
                               trace = FALSE, lambda = 1, direction = 
                                   c("forward","backward","both"), delta = 1e-05,
                               criterion = c("AIC","CV","BIC","OCV","GCV",NULL), 
                               k = 2, N_CV = 5, split = c("no","complete","restricted")) {  
    
    output_type <- match.arg(output_type, several.ok = TRUE)
    remove_list_models <- FALSE
    
    if("one_model" %in% output_type && ! "list_models" %in% output_type) {
        output_type <- c(output_type,"list_models")
        remove_list_models <- TRUE
        }
    
    criterion <- match.arg(criterion)
    split     <- match.arg(split)
    direction <- match.arg(direction)
    
    
    
    Transposed_Input     <- transpose_input(object=object,scope=scope,lambda_transpose=lambda, split=split)
    formula_selection    <- Transposed_Input$formula_selection 
    formula_fixed        <- Transposed_Input$formula_fixed
    names_selection      <- Transposed_Input$names_selection
    names_fixed          <- Transposed_Input$names_fixed
    name_response        <- Transposed_Input$name_response
    data_in              <- Transposed_Input$data_in
    EQ                   <- Transposed_Input$EQ
    expectiles_in        <- Transposed_Input$expectiles_in
    estimate_in          <- Transposed_Input$estimate_in
    lambda_in            <- Transposed_Input$lambda_in
    smooth_in            <- Transposed_Input$smooth_in
    ci_in                <- Transposed_Input$ci_in
    NumberOfVariables    <- Transposed_Input$NumberOfVariables
    NumberOfModels       <- Transposed_Input$NumberOfModels
    NumberOfExpectiles   <- Transposed_Input$NumberOfExpectiles
    xnames_selection     <- Transposed_Input$xnames_selection
    xnames_fixed         <- Transposed_Input$xnames_fixed
    
    names_selection_short <- Transposed_Input$names_selection_short
    names_fixed_short     <- Transposed_Input$names_fixed_short
    #vec_s_split_orig     <- Transposed_Input$vec_s_split_orig
    vec_s_xname_orig      <- Transposed_Input$vec_s_xname_orig
    if(split == 'restricted'  && direction != "forward") { 
        stop("\n\r split = 'restricted' is only compatible with forward selection.\n\r Use 'complete' or 'no', if you want to do 'backward' or 'both' selection.")
    }
    if(estimate_in != "laws")
        stop("stepExpect(..., type = 'separately') only possible for estimate = 'laws'!")
    
    if(length(k) > 1) stop("k has to be scalar")
    if( is.null(criterion) &&  is.null(k)) {
        stop("specify criterion or specify k")
    }
    if(!is.null(criterion) && criterion == "AIC" && !is.null(k) && is.numeric(k))     {
        pen_AIC = k
        decreasing_model <- F
    }
    if(!is.null(criterion) && criterion == "AIC" && is.null(k))     {
        pen_AIC = 2
        decreasing_model <- F
    }
    if(is.null(criterion) && !is.null(k) && is.numeric(k)) {
        criterion <- "AIC"
        pen_AIC <- k
        decreasing_model <- F
    }
    if(criterion == "OCV"|| criterion == "GCV")     {
        pen_AIC = 2
        decreasing_model <- F
    }
    if(criterion == "BIC")     {
        pen_AIC = log(nrow(data_in))
        decreasing_model <- F
    }
    if(criterion == "CV")     {
        pen_AIC = 2
        decreasing_model <- F
    }
    
    
    anova <- list()
    
    arguments <- list()
    arguments$criterion <- criterion
    arguments$k <- k
    arguments$N_CV <- N_CV
    arguments$direction <- direction
    arguments$lambda <- lambda
    arguments$delta <- delta
    arguments$split <- split
    arguments$grid_alpha <- 50
    arguments$weight <- 1
    arguments$interval <- c(-1,2)
    arguments$output_type <- output_type
    
    anova$arguments <- arguments
    
    rm(Transposed_Input)
    
    criterion_CV <- "L2"
    
    Output <- list()
    
    for(tt in 1:NumberOfExpectiles) {
        if(trace) {
            cat("\r\n \r\n Expectile: ", expectiles_in[tt], "\r\n")
        }
        
        Numbers <- Sample_Numbers(N_CV1=N_CV,nrow(data_in))
        
        Vector_covariates        <- names_selection
        Vector_covariates_short  <- names_selection_short
        Vector_covariates_xnames <- vec_s_xname_orig
        Ind_old_new <- T                                                                     # Indicator, whether the new model is worse than the old model
        niter <- 0
        StartFormula_vec <- NULL
        
        if(direction == "forward") {
            if(is.null(names_fixed)) {
                Start_name  <- "1"
            }
            if(!is.null(names_fixed)) {
                Start_name <- names_fixed
            }
            
            StartFormula_vec      <- Start_name
            StartFormula_text     <- paste(name_response, " ~ ", paste(Start_name,collapse = " + "),sep="")
            StartFormula          <- as.formula(StartFormula_text,env=.GlobalEnv)
            
            if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                StartModel        <- expectreg.ls(formula = StartFormula, expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)   
                if(criterion %in% c("AIC", "BIC")){ScoreStartModel <- AIC(StartModel, k = pen_AIC)}
                if(criterion == "OCV")            {ScoreStartModel <- OCV(StartModel)}
                if(criterion == "GCV")            {ScoreStartModel <- GCV(StartModel)}
            } 
            if(criterion == "CV") {
                ScoreStartModel <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = StartFormula, N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
            }
            anova[[tt]] <- list()
            while(Ind_old_new & length(Vector_covariates)!=0 & niter <= (NumberOfModels+2)) {         # repeat as long as the old model is better than the new one, or no covariates are left to be included 
                ScoreStartModel_temp <- formatC(ScoreStartModel,digits=2,format="e")
                if(trace) {
                    if(niter==0) {
                        cat(paste("Start: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                    if(niter>0) {
                        cat(paste("\r\n Step: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                }
                anova[[tt]][[niter+1]] <- list()
                names(anova[[tt]]) <- paste("Step",0:niter,sep="")
                anova[[tt]][[niter+1]]$StartModel     <- StartFormula
                anova[[tt]][[niter+1]]$StartCriterion <- ScoreStartModel
                
                OtherModels <- NULL
                #OtherModels <- list()
                ScoreOther <- NULL
                ScoreOther <- rep(0, times = length(Vector_covariates))
                OtherFormula <- NULL
                OtherFormula <- list()
                OtherFormula_text <- NULL
                OtherFormula_text <- list()
                OtherFormula_vec <- NULL
                OtherFormula_vec <- list()
                # for every possible new covariate estimate the model and the goodness of fit
                for(i1 in 1:length(Vector_covariates)) {
                    OtherFormula_vec [[i1]]   <- c(StartFormula_vec,Vector_covariates[i1])
                    if("1" %in% OtherFormula_vec [[i1]]) {
                        OtherFormula_vec [[i1]]   <- OtherFormula_vec [[i1]][-which(OtherFormula_vec [[i1]] == "1")]
                    }
                    OtherFormula_text[[i1]] <- paste(name_response, " ~ ", paste(OtherFormula_vec [[i1]],collapse = " + "),sep="")  
                    OtherFormula     [[i1]] <- as.formula(OtherFormula_text[[i1]],env=.GlobalEnv)
                    if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                        OtherModels      <- expectreg.ls(formula = OtherFormula[[i1]], expectiles=expectiles_in[tt], data=data_in, 
                                                         estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in) 
                        if(criterion %in% c("AIC", "BIC")) {ScoreOther[i1]  <- AIC(OtherModels, k = pen_AIC)}
                        if(criterion == "OCV")             {ScoreOther[i1]  <- OCV(OtherModels)}
                        if(criterion == "GCV")             {ScoreOther[i1]  <- GCV(OtherModels)}
                    } 
                    if(criterion == "CV") {
                        ScoreOther[i1]  <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = OtherFormula[[i1]], N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                        estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                        name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
                    }
                    
                }
                
                # print step
                trace_matrix_step <- matrix(NA,nrow=(length(Vector_covariates)+1),ncol=2)
                colnames(trace_matrix_step) <- c("add",criterion)
                trace_matrix_step[2:(length(Vector_covariates)+1),1] <- Vector_covariates_short
                trace_matrix_step[2:(length(Vector_covariates)+1),2] <- formatC(ScoreOther,digits=2,format="e")
                trace_matrix_step[1,1] <- "<none>"
                trace_matrix_step[1,2] <- formatC(ScoreStartModel,digits=2,format="e")
                Score_matrix_temp_sort <- c(ScoreStartModel, ScoreOther)
                trace_matrix_step <- trace_matrix_step[order(Score_matrix_temp_sort,decreasing=decreasing_model),]
                if(trace) {
                    print(trace_matrix_step,digits =2,quote=F,right=T)
                }
                anova[[tt]][[niter+1]]$names_covariates     <- Vector_covariates
                anova[[tt]][[niter+1]]$criterion_covariates <- ScoreOther
                
                # test which new model is the best and if the old model was better than all new models
                # smaller is better
                if(min(ScoreOther) >= ScoreStartModel - delta) {
                    Ind_old_new <- F                         # if non of the new models (OtherModels) is better than the old one => End of while-loop
                }
                
                if(trace) {
                    if(min(ScoreOther) >= ScoreStartModel - delta && min(ScoreOther) < ScoreStartModel) {
                        cat("\n\r Iteration stops, because the criteria of the new models are to close to the criterion of the StartModel. 
                            Change delta to 0 to get the absolute best model. \n\r")
                    }
                }  
                if(min(ScoreOther) < ScoreStartModel - delta) {
                    #StartModel        <- OtherModels      [[which.min(ScoreOther)]]
                    ScoreStartModel   <- min(ScoreOther)
                    StartFormula      <- OtherFormula     [[which.min(ScoreOther)]]
                    StartFormula_text <- OtherFormula_text[[which.min(ScoreOther)]]
                    StartFormula_vec  <- OtherFormula_vec [[which.min(ScoreOther)]]
                }
                xname_temp               <- Vector_covariates_xnames   [which.min(ScoreOther)]
                if(split == "restricted") {
                    Vector_covariates        <- Vector_covariates          [-which(Vector_covariates_xnames==xname_temp)]     # The included covariate is excluded of the list of possible new covariates
                    Vector_covariates_short  <- Vector_covariates_short    [-which(Vector_covariates_xnames==xname_temp)]     # The included covariate is excluded of the list of possible new covariates
                    Vector_covariates_xnames <- Vector_covariates_xnames   [-which(Vector_covariates_xnames==xname_temp)]     # The included covariate is excluded of the list of possible new covariates_xnames
                }
                if(split != "restricted") {
                    Vector_covariates        <- Vector_covariates          [-which.min(ScoreOther)]     # The included covariate is excluded of the list of possible new covariates
                    Vector_covariates_short  <- Vector_covariates_short    [-which.min(ScoreOther)]     # The included covariate is excluded of the list of possible new covariates
                    Vector_covariates_xnames <- Vector_covariates_xnames   [-which.min(ScoreOther)]     # The included covariate is excluded of the list of possible new covariates_xnames
                }
                
                anova[[tt]][[niter+1]]$best_model <- StartFormula
                niter <- niter + 1
            }
            if(trace) {
                cat(" \n\r best model: \n\r", StartFormula_text," \n\r")
            }
        } # Ende forward
        
        
        if(direction == "backward") {
            StartFormula_vec      <- c(names_selection,names_fixed)
            StartFormula_text     <- paste(name_response, " ~ " , paste(StartFormula_vec,collapse=" + "),sep="")
            StartFormula          <- as.formula(StartFormula_text,env=.GlobalEnv)
            
            if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                StartModel        <- expectreg.ls(formula = StartFormula, expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)   
                if(criterion %in% c("AIC", "BIC")) {ScoreStartModel <- AIC(StartModel, k = pen_AIC)}
                if(criterion == "OCV")             {ScoreStartModel <- OCV(StartModel)}
                if(criterion == "GCV")             {ScoreStartModel <- GCV(StartModel)}
            } 
            if(criterion == "CV") {
                ScoreStartModel <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = StartFormula, N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
            }
            anova[[tt]] <- list()
            #names(anova) <- names_anova_Expectile
            while(Ind_old_new & length(Vector_covariates)!=0 & niter <= (NumberOfModels+2)) {
                ScoreStartModel_temp <- formatC(ScoreStartModel,digits=2,format="e")
                if(trace) {
                    if(niter==0) {
                        cat(paste("Start: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                    if(niter>0) {
                        cat(paste("\r\n Step: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                }
                anova[[tt]][[niter+1]] <- list()
                names(anova[[tt]]) <- paste("Step",0:niter,sep="")
                anova[[tt]][[niter+1]]$StartModel     <- StartFormula
                anova[[tt]][[niter+1]]$StartCriterion <- ScoreStartModel
                
                OtherModels <- NULL
                #OtherModels <- list()
                ScoreOther <- NULL
                ScoreOther <- rep(0, times = length(Vector_covariates))
                OtherFormula <- NULL
                OtherFormula <- list()
                OtherFormula_text <- NULL
                OtherFormula_text <- list()
                OtherFormula_vec <- NULL
                OtherFormula_vec <- list()
                # for every covariate estimate the model without this covariate and the goodness of fit
                for(i1 in 1:length(Vector_covariates)) {
                    OtherFormula_vec [[i1]] <- StartFormula_vec[-which(StartFormula_vec==Vector_covariates[i1])]
                    if(length(Vector_covariates) < 2) {
                        if(is.null(names_fixed)) {
                            OtherFormula_vec [[i1]] <- "1"
                        }
                        if(!is.null(names_fixed)) {
                            OtherFormula_vec [[i1]] <- names_fixed
                        }
                    }
                    OtherFormula_text[[i1]] <- paste(name_response, " ~ ", paste(OtherFormula_vec[[i1]],collapse=" + "),sep="")
                    OtherFormula     [[i1]] <- as.formula(OtherFormula_text[[i1]],env=.GlobalEnv)
                    # b) estimate the new model and goodness of fit
                    if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                        OtherModels <- expectreg.ls(formula = OtherFormula[[i1]], expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in) 
                        if(criterion %in% c("AIC", "BIC")) {ScoreOther[i1]  <- AIC(OtherModels, k = pen_AIC)}
                        if(criterion == "OCV")             {ScoreOther[i1]  <- OCV(OtherModels)}
                        if(criterion == "GCV")             {ScoreOther[i1]  <- GCV(OtherModels)}                    
                    }
                    if(criterion == "CV") {
                        ScoreOther[i1]  <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = OtherFormula[[i1]], N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                        estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                        name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
                    }
                    
                }
                
                # print step
                trace_matrix_step <- matrix(NA,nrow=(length(Vector_covariates)+1),ncol=2)
                colnames(trace_matrix_step) <- c("remove",criterion)
                trace_matrix_step[2:(length(Vector_covariates)+1),1] <- Vector_covariates_short
                trace_matrix_step[2:(length(Vector_covariates)+1),2] <- formatC(ScoreOther,digits=2,format="e")
                trace_matrix_step[1,1] <- "<none>"
                trace_matrix_step[1,2] <- formatC(ScoreStartModel,digits=2,format="e")
                Score_matrix_temp_sort <- c(ScoreStartModel, ScoreOther)
                
                trace_matrix_step <- trace_matrix_step[order(Score_matrix_temp_sort,decreasing=decreasing_model),]
                if(trace) {
                    print(trace_matrix_step,digits =2,quote=F,right=T)
                }
                anova[[tt]][[niter+1]]$names_covariates     <- Vector_covariates
                anova[[tt]][[niter+1]]$criterion_covariates <- ScoreOther
                
                # find best new model and test if old model was better
                if(min(ScoreOther) >= ScoreStartModel - delta) {
                    Ind_old_new <- F                         # if non of the new models (OtherModels) is better than the old one => End of while-loop
                }
                if(trace) {
                    if(min(ScoreOther) >= ScoreStartModel - delta && min(ScoreOther) < ScoreStartModel) {
                        cat("\n\r Iteration stops, because the criteria of the new models are to close to the criterion of the StartModel. Change delta to 0 to get the absolute best model. \n\r")
                    }
                }  
                if(min(ScoreOther) < ScoreStartModel - delta) {
                    ScoreStartModel   <- min(ScoreOther)
                    #StartModel       <- OtherModels      [[which.min(ScoreOther)]] 
                    StartFormula      <- OtherFormula     [[which.min(ScoreOther)]]
                    StartFormula_text <- OtherFormula_text[[which.min(ScoreOther)]]
                    StartFormula_vec  <- OtherFormula_vec [[which.min(ScoreOther)]]
                }
                Vector_covariates        <- Vector_covariates       [-which.min(ScoreOther)]     # The excluded covariate is excluded of the list of possible excluded covariates
                Vector_covariates_short  <- Vector_covariates_short [-which.min(ScoreOther)]     # The excluded covariate is excluded of the list of possible excluded covariates
                Vector_covariates_xnames <- Vector_covariates_xnames[-which.min(ScoreOther)]
                
                anova[[tt]][[niter+1]]$best_model <- StartFormula
                niter <- niter + 1
            }
            
            if(trace) {
                cat(" \n\r best model: \n\r", StartFormula_text," \n\r")
            }
        } # End backward
        
        
        # at both the StartModel is the full model
        if(direction == "both") {
            StartFormula_vec      <- c(names_selection, names_fixed)
            StartFormula_text     <- paste(name_response, " ~ " , paste(StartFormula_vec,collapse=" + "),sep="")
            StartFormula          <- as.formula(StartFormula_text,env=.GlobalEnv)
            
            if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                StartModel <- expectreg.ls(formula = StartFormula, expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)   
                if(criterion %in% c("AIC", "BIC")) {ScoreStartModel <- AIC(StartModel, k = pen_AIC)}
                if(criterion == "OCV")             {ScoreStartModel <- OCV(StartModel)}
                if(criterion == "GCV")             {ScoreStartModel <- GCV(StartModel)}
            }
            if(criterion == "CV") {
                ScoreStartModel <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = StartFormula, N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
            }
            Vector_covariates_excl       <- Vector_covariates       # List of covariates that may be excluded
            Vector_covariates_incl       <- NULL                    # List of covariates that may be included (NULL at the beginning)
            Vector_covariates_excl_short <- Vector_covariates_short # List of covariates that may be excluded
            Vector_covariates_incl_short <- NULL                    # List of covariates that may be included (NULL at the beginning)
            anova[[tt]] <- list()
            #names(anova) <- names_anova_Expectile
            while(Ind_old_new & length(Vector_covariates_excl)!=0 & niter <= (NumberOfModels*2 + 2) ) { 
                ScoreStartModel_temp <- formatC(ScoreStartModel,digits=2,format="e")
                if(trace) {
                    if(niter==0) {
                        cat(paste("Start: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                    if(niter>0) {
                        cat(paste("\r\n Step: ",
                                  "\r\n        ", criterion, " = ", ScoreStartModel_temp, 
                                  "\r\n        ", StartFormula_text, "\r\n \r\n"))
                    }
                }
                anova[[tt]][[niter+1]] <- list()
                names(anova[[tt]]) <- paste("Step",0:niter,sep="")
                anova[[tt]][[niter+1]]$StartModel     <- StartFormula
                anova[[tt]][[niter+1]]$StartCriterion <- ScoreStartModel
                OtherModels <- NULL
                #OtherModels <- list()
                ScoreOther <- NULL
                ScoreOther <- rep(0, times = (length(Vector_covariates_excl) + length(Vector_covariates_incl)))
                OtherFormula <- NULL
                OtherFormula <- list()
                OtherFormula_text <- NULL
                OtherFormula_text <- list()
                OtherFormula_vec <- NULL
                OtherFormula_vec <- list()
                # a) estimate the models with one covariate less, like backwards
                if(length(Vector_covariates_excl) != 0) {
                    for(i1 in 1:length(Vector_covariates_excl)) {
                        OtherFormula_vec [[i1]] <- StartFormula_vec[-which(StartFormula_vec==Vector_covariates_excl[i1])]
                        if(length(Vector_covariates_excl) < 2) {
                            if(is.null(names_fixed)) {
                                OtherFormula_vec [[i1]] <- "1"
                            }
                            if(!is.null(names_fixed)) {
                                OtherFormula_vec [[i1]] <- names_fixed
                            }
                        }
                        OtherFormula_text[[i1]] <- paste(name_response, " ~ ", paste(OtherFormula_vec[[i1]],collapse=" + "),sep="")
                        OtherFormula     [[i1]] <- as.formula(OtherFormula_text[[i1]],env=.GlobalEnv)
                        if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                            OtherModels <- expectreg.ls(formula = OtherFormula[[i1]], expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in) 
                            if(criterion %in% c("AIC", "BIC")) {ScoreOther[i1] <- AIC(OtherModels, k = pen_AIC)}
                            if(criterion == "OCV")             {ScoreOther[i1] <- OCV(OtherModels)}
                            if(criterion == "GCV")             {ScoreOther[i1] <- GCV(OtherModels)}
                        }
                        if(criterion == "CV") {
                            ScoreOther[i1] <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = OtherFormula[[i1]], N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                           estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                           name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
                        }
                    }
                }
                # b) estimate the models with one covariate more, like forwards
                if(length(Vector_covariates_incl)!=0){
                    for(j1 in (length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl))) {
                        i1 <- j1 - length(Vector_covariates_excl)
                        OtherFormula_vec [[j1]]   <- c(StartFormula_vec,Vector_covariates_incl[i1])
                        if("1" %in% OtherFormula_vec [[j1]]) {
                            OtherFormula_vec [[i1]]   <- OtherFormula_vec [[i1]][-which(OtherFormula_vec [[j1]] == "1")]
                        }
                        OtherFormula_text[[j1]] <- paste(name_response, " ~ ", paste(OtherFormula_vec [[j1]],collapse = " + "),sep="")  
                        OtherFormula     [[j1]] <- as.formula(OtherFormula_text[[j1]],env=.GlobalEnv)
                        if(criterion %in% c("AIC","BIC","OCV","GCV")) {
                            OtherModels <- expectreg.ls(formula = OtherFormula[[j1]], expectiles=expectiles_in[tt], data=data_in, estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in) 
                            if(criterion %in% c("AIC", "BIC")) {ScoreOther[j1]  <- AIC(OtherModels, k = pen_AIC)}
                            if(criterion == "OCV")             {ScoreOther[j1]  <- OCV(OtherModels)}
                            if(criterion == "GCV")             {ScoreOther[j1]  <- GCV(OtherModels)}
                        }
                        if( criterion == "CV") {
                            ScoreOther[j1]  <- build_Score2(data_in = data_in, Numbers = Numbers, formula_in = OtherFormula[[j1]], N_CV = N_CV, expectiles_in_b = expectiles_in[tt], typeL = criterion_CV, 
                                                            estimate_in = estimate_in, smooth_in = smooth_in, ci_in = ci_in, lambda_in = lambda_in,
                                                            name_response=name_response, names_selection=names_selection, names_fixed=names_fixed, weight_vector=1)
                        }
                    }
                }
                # print step
                Score_matrix_temp_sort1 <- NULL
                Score_matrix_temp_sort2 <- NULL
                trace_matrix_step <- NULL
                trace_matrix_step <- matrix(NA,nrow=(length(Vector_covariates_excl)+length(Vector_covariates_incl)+1),ncol=2)
                colnames(trace_matrix_step) <- c("add or remove",criterion)
                if(length(Vector_covariates_excl)!=0){
                    trace_matrix_step[2:(length(Vector_covariates_excl)+1),1] <- paste("-",Vector_covariates_excl_short)
                    trace_matrix_step[2:(length(Vector_covariates_excl)+1),2] <- formatC(ScoreOther[1:length(Vector_covariates_excl)],digits=2,format="e")
                    Score_matrix_temp_sort1 <- ScoreOther[1:length(Vector_covariates_excl)]
                    anova[[tt]][[niter+1]]$names_covariates_excl      <- Vector_covariates_excl
                    anova[[tt]][[niter+1]]$criterion_covariates_excl  <- ScoreOther[1:length(Vector_covariates_excl)]
                }
                if(length(Vector_covariates_incl)!=0){
                    trace_matrix_step[(((length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl)))+1),1] <- paste("+",Vector_covariates_incl_short)
                    trace_matrix_step[(((length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl)))+1),2] <- formatC(ScoreOther[(length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl))],digits=2,format="e")
                    Score_matrix_temp_sort2 <- ScoreOther[(length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl))]
                    anova[[tt]][[niter+1]]$names_covariates_incl      <- Vector_covariates_incl
                    anova[[tt]][[niter+1]]$criterion_covariates_incl  <- ScoreOther[(length(Vector_covariates_excl)+1):(length(Vector_covariates_excl) + length(Vector_covariates_incl))]
                }
                trace_matrix_step[1,1] <- "<none>"
                trace_matrix_step[1,2] <- formatC(ScoreStartModel,digits=2,format="e")
                Score_matrix_temp_sort <- c(ScoreStartModel, Score_matrix_temp_sort1, Score_matrix_temp_sort2)
                trace_matrix_step <- trace_matrix_step[order(Score_matrix_temp_sort,decreasing=decreasing_model),]
                if(trace) {
                    print(trace_matrix_step,digits =2,quote=F,right=T)
                }
                
                
                # find best new model and test if old model was better, update lists of possible new covariates and existing covariates
                if(min(ScoreOther) >= ScoreStartModel - delta) {
                    Ind_old_new <- F                                        # if non of the new models (OtherModels) is better than the old one => End of while-loop
                }
                if(trace) {
                    if(min(ScoreOther) >= ScoreStartModel - delta && min(ScoreOther) < ScoreStartModel) {
                        cat("\n\r Iteration stops, because the criteria of the new models are to close to the criterion of the StartModel. Change delta to 0 to get the absolute best model. \n\r")
                    }
                }
                if(min(ScoreOther) < ScoreStartModel - delta) {
                    ScoreStartModel   <- min(ScoreOther)
                    #StartModel       <- OtherModels      [[which.min(ScoreOther)]] 
                    StartFormula      <- OtherFormula     [[which.min(ScoreOther)]]
                    StartFormula_text <- OtherFormula_text[[which.min(ScoreOther)]]
                    StartFormula_vec  <- OtherFormula_vec [[which.min(ScoreOther)]]
                }
                if(which.min(ScoreOther) <= length(Vector_covariates_excl)) {                                                    # if the best model excludes a covariate:
                    Vector_covariates_incl_new       <- c(Vector_covariates_incl      , Vector_covariates_excl      [which.min(ScoreOther)])   #        this covariate is deleted of the list of possible excluded covariates
                    Vector_covariates_incl_new_short <- c(Vector_covariates_incl_short, Vector_covariates_excl_short[which.min(ScoreOther)])   #        this covariate is deleted of the list of possible excluded covariates
                    Vector_covariates_excl_new       <- Vector_covariates_excl      [-which.min(ScoreOther)]                                #        this covariate is added to the list of possible included covariates
                    Vector_covariates_excl_new_short <- Vector_covariates_excl_short[-which.min(ScoreOther)]                                #        this covariate is added to the list of possible included covariates
                }
                if(which.min(ScoreOther) > length(Vector_covariates_excl)) {                                                                                         # if the best model adds a covariate:
                    Vector_covariates_excl_new       <- c(Vector_covariates_excl      , Vector_covariates_incl      [(- length(Vector_covariates_excl      ) + which.min(ScoreOther))]) #        this covariate is added to the list of possible excluded covariates
                    Vector_covariates_excl_new_short <- c(Vector_covariates_excl_short, Vector_covariates_incl_short[(- length(Vector_covariates_excl_short) + which.min(ScoreOther))]) #        this covariate is added to the list of possible excluded covariates
                    Vector_covariates_incl_new       <- Vector_covariates_incl      [-(- length(Vector_covariates_excl      ) + which.min(ScoreOther))]                                #        this covariate is deleted of the list of possible included covariates
                    Vector_covariates_incl_new_short <- Vector_covariates_incl_short[-(- length(Vector_covariates_excl_short) + which.min(ScoreOther))]                                #        this covariate is deleted of the list of possible included covariates
                }
                Vector_covariates_excl       <- unique(Vector_covariates_excl_new      )                  
                Vector_covariates_excl_short <- unique(Vector_covariates_excl_new_short)                  
                Vector_covariates_incl       <- unique(Vector_covariates_incl_new      )
                Vector_covariates_incl_short <- unique(Vector_covariates_incl_new_short)
                
                
                
                anova[[tt]][[niter+1]]$best_model <- StartFormula
                niter <- niter + 1
            }
            if(trace) {
                cat(" \n\r best model: \n\r", StartFormula_text," \n\r")
            }
        } # End both
        
        Output[[tt]] <- StartFormula_vec
    } # End for(tt in 1:NumberOfExpectiles)
    
    
    #     IndexBestModel <- NULL
    #     if("IndexBestModel" %in% output_type){    
    #         AllFormula_1 <- define_AllFormula(names_selection = names_selection, names_fixed=names_fixed,name_response=name_response,xnames_selection=xnames_selection,xnames_fixed=xnames_fixed)[[1]]
    #         AllFormula_2 <- define_AllFormula(names_selection = names_selection, names_fixed=names_fixed,name_response=name_response,xnames_selection=xnames_selection,xnames_fixed=xnames_fixed)[[2]]
    #         
    #         IndexBestModel <- matrix(NA,ncol=NumberOfExpectiles,nrow=1)
    #         for(tt in 1:NumberOfExpectiles) {
    #             for(kk in 1:length(AllFormula_1)) {
    #                 if(all(Output[[tt]] %in% AllFormula_2[[kk]]) && all(AllFormula_2[[kk]] %in% Output[[tt]])) {
    #                     IndexBestModel[1,tt] <- kk
    #                     }
    #                 }
    #             }
    #         }
    #     
    Output_model <- NULL
    if("list_models" %in% output_type) {
        Output_model <- list()
        for(tt in 1:length(expectiles_in)) {
            formula_tt <- as.formula(paste(name_response, " ~ ", paste(Output[[tt]],collapse=" + "),sep=""))
            Output_model[[tt]] <- expectreg.ls(formula_tt,data=data_in,expectiles=expectiles_in[tt],estimate = estimate_in, smooth = smooth_in, ci = ci_in, lambda = lambda_in)
        }
    }
    
    if("one_model" %in% output_type) {
        Vec_formula_join <- unique(unlist(Output))
        formula_join <-  as.formula(paste(name_response, " ~ ", paste(Vec_formula_join,collapse=" + "),sep=""))
        Output_one_model <- expectreg.ls(formula_join, data = data_in, expectiles = expectiles_in, 
                                         estimate = estimate_in, smooth = smooth_in, ci = ci_in, 
                                         lambda = lambda_in, list_models = Output_model)
        }
    names(anova) <- paste("Expectile",expectiles_in,sep="")
    
    table_selected <- matrix(0,ncol=length(expectiles_in),nrow=length(names_selection_short)+length(names_fixed_short))
    
    rownames(table_selected) <- c(names_selection_short,names_fixed_short)
    colnames(table_selected) <- expectiles_in
    All_covariates       <- c(names_selection,       names_fixed)
    All_covariates_short <- c(names_selection_short, names_fixed_short)
    for(tt in 1:length(expectiles_in)) {
        for(k in 1:length(All_covariates)) {
            if(All_covariates[k] %in% Output[[tt]]){
                table_selected[k,tt] <- 1
            }
        }
    }
    anova$names_selection <- names_selection
    anova$names_fixed <- names_fixed
    
    anova$table_selected <- table_selected
    
    if(trace) {
        cat("\n\r", "Table selected covariates:", "\n\r")
        print(table_selected)
        cat("\n\r")
    }
    result <- list("anova"=anova)    
    if("list_models"          %in% output_type && !remove_list_models) { result$list_models <- Output_model         }
    if("one_model"            %in% output_type) { result$one_model   <- Output_one_model     }
    #if("IndexBestModel" %in% output_type) { result$IndexBestModel <- IndexBestModel       }
    class(result) = c("expectreg_selected", "stepExpect", "separately", criterion)
    
    result
}  # End Function



