\name{bestExpect}
\alias{bestExpect}
\alias{bestExpect.expectreg}
%\alias{bestAIC_separately}
%\alias{bestCV_separately}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Best subset model selection for expectiles via AIC or CV
}
\description{
Estimates best subset model selection with AIC or cross-validation for each asymmetry parameter separately.
}
\usage{
\method{bestExpect}{expectreg}(object, scope = NULL, split = c("no","complete","restricted"),
    criterion = c("AIC","BIC","OCV","GCV","CV"), k = 2,  N_CV = 5, trace = FALSE, 
    lambda = 1, output_type = c("one_model","list_models"), ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
 an object of class \code{expectreg}. Required to get the basic information: \code{data}, \code{estimate}, \code{smooth}, \code{expectiles}, ...
}
  \item{scope}{
    defines the range of models evaluated in the model selection. This could be either \code{NULL},  a single formula, or a list of two formulas specifying the upper and lower bound. See the details for how to specify the formulas and how they are used.
}
  \item{split}{
how to deal with psplines. See details.
}
  \item{criterion}{
selection criterion. Default is \code{"AIC"}, alternatives are \code{"BIC"}, \code{"OCV"} and \code{"GCV"}. Here criterion can be a vector of the prespecified values. Then the best models of multiple criteria can be compared in one estimation. The criterion \code{"CV"} performs N_CV-fold cross-validation and is only possible as a single criterion.
}
  \item{k}{
numeric, the penalty per parameter to be used, if \code{criterion} is \code{NULL}; the default \code{k = 2} is the AIC, \code{k = log(n)} is the BIC.
}
  \item{N_CV}{
number of cross validations. Default is 5.
}
  \item{trace}{
 if \code{TRUE}, information about all evaluated models is printed at the end of the selection.
}
  \item{lambda}{
initial value of smoothing parameter for updating \code{expectreg.ls()}. Default is 1.
}
\item{output_type}{
specifies which output should be created. Default is \code{"list_models"}. See value for details.
}
  \item{...}{
}
}
\details{
Best subset model selection estimates all possible combinations of covariates specified in \code{scope}. These are 2^(number covariates). Thus best subset model selection is only possible for few < 10 covariates.\cr

If \code{scope} is \code{NULL}, then the lower bound is the intercept model and the upper bound is the model given in \code{object}. If \code{code} is a single formula then this is the upper bound and the lower bound is the intercept model. If \code{scope} is a list of two formulae then the first is the upper bound and the second is the lower bound. \cr

For P-splines several approaches for model selection are possible:
\itemize{
    \item{\code{split = "no"} { No special treatment is applied. The input is only checked for inconsitency. Each covariate may only occure once, except if it is the combination of "parametric" and "penalizedpart_pspline". Then both covariates are treated a independent covariates.}}
    \item{\code{split = "restricted"} { For every P-spline two possibilities are evaluated in each step and the better one is used. The two possibilities are the classical linear covariate and the classical P-spline. If one is selected the otherone is not possible anymore.}}
    \item{\code{split = "complete"} { Each P-spline is splitted into its linear trend \code{rb(..., type = 'parametric')} and the wiggly deviation of the linear trend \code{rb(..., type = 'penalizedpart_pspline')}. Both parts are used as independent covariates in the model selection. }}
    }
}
\value{
An object of class \code{expectreg_selected}. \cr
A LIST with elements specified in \code{output_type} and anova:
  \item{anova }{A LIST of model selection information:
                \describe{
                    \item{\code{all_models}}{Vector of all evaluated models}
                    \item{\code{criterion}}{Matrix of resulting model selection criterion in rows and asymmetries is columns}
                    \item{\code{names_selection}}{Names of covariates possible to be excluded.}
                    \item{\code{names_fixed}}{Names of covariates always in the best model (lower bound of scope). }
                    \item{\code{table_selected}}{Matrix (rows = covariate, column = asymmetries) of selected covariates. 1 means selected 0 means excluded.}         
                }
                }
  \item{one_model}{Best model for all asymmetry parameters together. Covariates which are always excluded are not shown, covariates which are included only in some asymmetries have coefficient 0 in the others.}
  \item{list_models}{LIST of best model for each asymmetry parameter separately.}
}
\references{
To be published
}
\author{
Elmar Spiegel
}
\note{
Best subset model selection is a ineffective way of model selection, since all possible models are evaluated. Thus the computational time can be very large and we recommend using stepwise model selection instead.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~
\section{Warning }{This function uses a list of all possible combinations of covariates. This may cause serious problems with the saving space, when too many covariates are used. Thus the number of covariates is retricted to 10.}

\seealso{
 \code{\link{garroteExpect}}, \code{\link{stepExpect}}, \code{\link{AIC}}, \code{\link{OCV}}, \code{\link{GCV}}, \code{\link{CV_Score}}
}
\examples{
set.seed(1)
x1 <- runif(1000)
x2 <- runif(1000)
x3 <- runif(1000)
eps <- rnorm(1000)

y <- 3*x1 + 0.75*x2 + eps

data1 <- data.frame(y, x1, x2, x3)

# standard model
model1 <- expectreg.ls(y ~ x1 + x2 + x3, data = data1, expectiles = c(0.1,0.5,0.9))

# different ways to define the criterion
selected1 <- bestExpect(model1, trace = TRUE, criterion = "AIC")
selected2 <- bestExpect(model1, trace = TRUE, k = 2)

# Joint selection different criteria
selected3 <- bestExpect(model1, trace = TRUE, criterion = "AIC",
                                several.ok = TRUE)
selected4 <- bestExpect(model1, trace = TRUE, criterion = "CV", N_CV = 10)

# Use different scope
model2 <- expectreg.ls(y ~ 1, data = data1, expectiles = c(0.1,0.5,0.9))
scopeA <- y ~ x1 + x2 + x3
scopeB <- list(y ~ x1 + x3, y ~ x3)
scopeC <- list(y ~ x1 + x2, y ~ x3)

selectedA <- bestExpect(model2, scope = scopeA, trace = TRUE)
selectedB <- bestExpect(model2, scope = scopeB, trace = TRUE)
selectedC <- bestExpect(model2, scope = scopeC, trace = TRUE)

# Use different selection types for p-splines
scope_rb1 <- y ~ rb(x1, type = 'pspline') + rb(x2, type = 'pspline') + 
                 rb(x3, type = 'pspline')

selected_rb1 <- bestExpect(model2, scope = scope_rb1, trace = TRUE, split = 'no')
selected_rb2 <- bestExpect(model2, scope = scope_rb1, trace = TRUE, split = 'complete')
selected_rb3 <- bestExpect(model2, scope = scope_rb1, trace = TRUE, split = 'restricted')


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
