rm(list=ls())

library(expectregSelection)
library(ExtraFunctions)
library(xtable)
library(colorspace)
load("WS_CVgrid_Paper_c_.RData")
source("plot.expectreg.accepted.R")


add_formula <- .~. - cage - rb(cage,"penalizedpart_pspline",B_size = 20) + rb(cage)
# Update model for joint plotting of cage and cage_prb
ModelPlot <- update(SelectedModels$one_model,add_formula=add_formula, expectiles = c(0.02,0.05,0.1,0.2,0.5,0.8,0.9,0.95,0.98))

# let the pictures have nice labels
rename_xlab2 <- function (xlab_old) {
    xlab_new <- xlab_old
    xlab_new[which(xlab_old == "cbirthorder")] <- "birth order"
    xlab_new[which(xlab_old == "caesarian")] <- "caesarian"
    xlab_new[which(xlab_old == "deadchildrenD")] <- "dead children"
    xlab_new[which(xlab_old == "householdhead")] <- "household head"
    xlab_new[which(xlab_old == "householdmembers")] <- "householdmembers"
    xlab_new[which(xlab_old == "meduC")] <- "mother's education"
    xlab_new[which(xlab_old == "edupartnerC")] <- "partner's education"
    xlab_new[which(xlab_old == "csex")] <- "sex"
    xlab_new[which(xlab_old == "bicycle")] <- "bicycle"
    xlab_new[which(xlab_old == "electricity")] <- "electricity"
    xlab_new[which(xlab_old == "motorcycle")] <- "motorcycle"
    xlab_new[which(xlab_old == "radio")] <- "radio"
    xlab_new[which(xlab_old == "refrigerator")] <- "refrigerator"
    xlab_new[which(xlab_old == "telephone")] <- "telephone"
    xlab_new[which(xlab_old == "television")] <- "television"
    xlab_new[which(xlab_old == "breastfeeding")] <- "breastfeeding"
    xlab_new[which(xlab_old == "breastfeeding_prb")] <- "breastfeeding nonlinear"
    xlab_new[which(xlab_old == "cage")] <- "child's age"
    xlab_new[which(xlab_old == "cage_prb")] <- "child's age nonlinear"
    xlab_new[which(xlab_old == "cage_rb")] <- "child's age"
    xlab_new[which(xlab_old == "mage")] <- "mother's age"
    xlab_new[which(xlab_old == "mage_prb")] <- "mother's age nonlinear"
    xlab_new[which(xlab_old == "mbmi")] <- "mother's bmi"
    xlab_new[which(xlab_old == "mbmi_prb")] <- "mother's bmi nonlinear"
    xlab_new[which(xlab_old == "mheight")] <- "mother's height"
    xlab_new[which(xlab_old == "mheight_prb")] <- "mother's height nonlinear"
    xlab_new[which(xlab_old == "mregion")] <- "region"
    xlab_new
}

NameImg    <- paste("WS",      nameSim, nameSim2, "new_accepted.RData", sep="_")
NameTable  <- paste("Table",   nameSim, nameSim2, "new_accepted.csv", sep="_")
NamePDF1   <- paste("Effects", nameSim, nameSim2, "small_new_accepted.pdf"  , sep="_")
NamePDF2   <- paste("Effects", nameSim, nameSim2, "new_accepted.pdf"  , sep="_")

NameEPS2 <- gsub(x=NamePDF2,pattern="pdf",replacement="eps")


    

xlab_old <- names(ModelPlot$coef)
    xlab_new <- rename_xlab2(xlab_old)
    type <- "one_model"
    if(!is.null(SelectedModels$one_model_delta)) {
        type <- "one_model_delta"
    }

ylim_factor <- c(-0.57,0.57)    
ylim_spat   <- c(-0.55,0.75)

setEPS()
postscript("Scoring_accepted_smooth.eps",width=8,height=5)
par(mfrow=c(2,3),mar=c(4,4.2,2,2))
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=2,legend=F,cex.main=2,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=9)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=2,legend=F,cex.main=2,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=15)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=2,legend=F,cex.main=2,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=7)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=2,legend=F,cex.main=2,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=5)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=2,legend=F,cex.main=2,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=1)
#plot.new()
plot_legend_points(expectiles=ModelPlot$asymmetries,cex=1)
dev.off()
 
setEPS()
postscript("Scoring_accepted_markov.eps",width=8,height=5)
layout(matrix(c(1:3,4:6),2,3,byrow = TRUE), widths=c(rep(1,3),2), heights=c(rep(4.0,1),1), FALSE)
par(mar=c(0,0,0,0),oma=c(0,0,0,0))
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=c(0,0,1,0),legend=F,cex.main=1,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=2,select_markov=2)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=c(0,0,1,0),legend=F,cex.main=1,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=2,select_markov=5)
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=c(0,0,1,0),legend=F,cex.main=1,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=2,select_markov=8)
plot.new()
par(mar=c(0,2,0,0))
plot_legend_markov(ylim_spat=ylim_spat,par_new=FALSE,cex.legend=1)
dev.off()

    
setEPS()
postscript("Scoring_accepted_markov_long.eps",width=8,height=11)
layout(matrix(c(1:9,10:12),4,3,byrow = TRUE), widths=c(rep(1,4),2), heights=c(rep(2.0,3),1), FALSE)
par(mar=c(0,0,0,0),oma=c(0,0,0,0))
plot.expectreg.accepted(ModelPlot,ask=F,ylim=c(-2,2),xlab=xlab_new,mar.min=c(0,0,1,0),legend=F,cex.main=1,cols="hcl",
                        ylim_factor=ylim_factor,ylim_spat=ylim_spat,cex.lab=1,cex.axis=1,select=2)#,select_markov=2)
plot.new()
par(mar=c(0,2,0,0))
plot_legend_markov(ylim_spat=ylim_spat,par_new=FALSE,cex.legend=1)
dev.off()

 


###########################################################################
## Plot factors extra such that they have a nicer size
###########################################################################
    
model_coef <- ModelPlot
ylim_plot1 <- c(-0.12,0.3)
ylim_plot2 <- c(-0.55,0.2)
#ylim_plot1 <- ylim_plot2
adj_plot2 <- 0.75#
adj_plot1 <- 0.28#
height_plot <- 7
y_lab_plot <- -0.24
y_lab_plot1 <- -0.12
cex_text <- cex_axis <- 1

setEPS()
postscript("Scoring_accepted_cat.eps",width=8,height=8)
layout(matrix(c(1,2,3,3,4,4,5:10),2,6,byrow = TRUE), widths=c(1,1,1,1,1,1,1,1,1,1),height=c(1,4/7),  FALSE) #heights=c(rep(1,1),1)
par(mar=c(1,4,0,1),oma=c(0,0,0,0))

#pdf("model_coef_motorcycle.pdf",width=2.1,height=height_plot)
par(mar=c(0,4,1,1))
plot(rep(2.5,times=length(model_coef$asymmetries)),model_coef$coeff$motorcycle,col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(2.4,2.6),ylim=ylim_plot2,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
title(ylab="Coefficients",line=2,adj=adj_plot2,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.20,0.20,by=0.1),label=round(seq(-0.2,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(2.5),labels=c(""),cex=1,pos=0,line=5,cex.axis=cex_axis)
text(x=2.5,y=y_lab_plot,labels="motorcycle",cex=cex_text)
#dev.off()


#pdf("model_coef_edupartnerC.pdf",width=2.5,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(3.2,times=length(model_coef$asymmetries)),model_coef$coeff$edupartnerC[1,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(3.05,3.65),ylim=ylim_plot2,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
points(rep(3.5,times=length(model_coef$asymmetries)),model_coef$coeff$edupartnerC[2,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
title(ylab="Coefficients",line=2,adj=adj_plot2,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.20,0.20,by=0.1),label=round(seq(-0.2,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(3.2,3.5),labels=c("medium","high"),cex=1,line=-21,cex.axis=cex_axis,las=2)
text(x=3.35,y=y_lab_plot,labels="\n partner's \n education",cex=cex_text)
#dev.off()


#pdf("model_coef_cbirthorder.pdf",width=4,height=height_plot)
#    par(mar=c(1,4,1,1))
plot(rep(5.0,times=length(model_coef$asymmetries)),model_coef$coeff$cbirthorder[1,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(4.85,5.75),ylim=ylim_plot2,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
points(rep(5.2,times=length(model_coef$asymmetries)),model_coef$coeff$cbirthorder[2,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
points(rep(5.4,times=length(model_coef$asymmetries)),model_coef$coeff$cbirthorder[3,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
points(rep(5.6,times=length(model_coef$asymmetries)),model_coef$coeff$cbirthorder[4,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
abline(h=0)
axis(side=2,at=seq(-0.50,0.20,by=0.1),label=round(seq(-0.5,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(5.0,5.2,5.4,5.6),labels=expression("2","3","4","">=5),cex.axis=cex_axis,pos=0)
text(x=5.3,y=-0.1,labels="birth order",cex=cex_text)
title(ylab="Coefficients",line=2.5,adj=adj_plot2,cex.lab=cex_text)
#dev.off()


#pdf("model_coef_householdmembers.pdf",width=3.3,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(5,times=length(model_coef$asymmetries)),model_coef$coeff$householdmembers[1,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(4.8,6.8),ylim=ylim_plot2,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
points(rep(5.4,times=length(model_coef$asymmetries)),model_coef$coeff$householdmembers[2,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
points(rep(5.8,times=length(model_coef$asymmetries)),model_coef$coeff$householdmembers[3,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
points(rep(6.2,times=length(model_coef$asymmetries)),model_coef$coeff$householdmembers[4,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
points(rep(6.6,times=length(model_coef$asymmetries)),model_coef$coeff$householdmembers[5,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
title(ylab="Coefficients",line=2,adj=adj_plot2,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.40,0.20,by=0.1),label=round(seq(-0.4,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(5,5.4,5.8,6.2,6.6),labels=expression("4","5","6","7","">=8),cex=1,line=-6.5,cex.axis=cex_axis)
text(x=5.8,y=-0.51,labels="householdmembers",cex=cex_text)
#dev.off()





#pdf("model_coef_csex.pdf",width=1.8,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(2.0,times=length(model_coef$asymmetries)),model_coef$coeff$csex,col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(1.85,2.15),ylim=ylim_plot1,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
title(ylab="Coefficients",line=2,adj=adj_plot1,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.10,0.20,by=0.1),label=round(seq(-0.1,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(2.0),labels=c(""),cex=1,pos=0,cex.axis=cex_axis)
text(x=2,y=y_lab_plot1,labels="female",cex=cex_text)
points(x=2,y=-0.65)
#dev.off()

#pdf("model_coef_medu.pdf",width=2.5,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(3.2,times=length(model_coef$asymmetries)),model_coef$coeff$meduC[1,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(3.05,3.65),ylim=ylim_plot1,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
points(rep(3.5,times=length(model_coef$asymmetries)),model_coef$coeff$meduC[2,],col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),pch=19,lwd=3)
title(ylab="Coefficients",line=2,adj=adj_plot1,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.10,0.30,by=0.1),label=round(seq(-0.1,0.3,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(3.2,3.5),labels=c("medium","high"),cex=1,pos=0,cex.axis=cex_axis,las=2)
text(x=3.35,y=y_lab_plot1,labels=" mother's \n education",cex=cex_text)
#dev.off()


#pdf("model_coef_refrigerator.pdf",width=2,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(2.5,times=length(model_coef$asymmetries)),model_coef$coeff$refrigerator,col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(2.4,2.6),ylim=ylim_plot1,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
title(ylab="Coefficients",line=2,adj=adj_plot1,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.10,0.20,by=0.1),label=round(seq(-0.1,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(2.5),labels=c(""),cex=1,pos=0,line=5,cex.axis=cex_axis)
text(x=2.5,y=y_lab_plot1,labels="refrigerator",cex=cex_text)
#dev.off()

#pdf("model_coef_telephone.pdf",width=2,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(2.5,times=length(model_coef$asymmetries)),model_coef$coeff$telephone,col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(2.4,2.6),ylim=ylim_plot1,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
title(ylab="Coefficients",line=2,adj=adj_plot1,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.10,0.20,by=0.1),label=round(seq(-0.1,0.2,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(2.5),labels=c(""),cex=1,pos=0,line=5,cex.axis=cex_axis)
text(x=2.5,y=y_lab_plot1,labels="telephone",cex=cex_text)
#dev.off()


#pdf("model_coef_television.pdf",width=1.5,height=height_plot)
#par(mar=c(1,4,1,1))
plot(rep(2.5,times=length(model_coef$asymmetries)),model_coef$coeff$television,col=diverge_hcl(length(model_coef$asymmetries),c=185,l=c(30,85)),xlim=c(2.4,2.6),ylim=ylim_plot1,pch=19,lwd=3,axes=F,ylab="",xlab="",main="")
title(ylab="Coefficients",line=2,adj=adj_plot1,cex.lab=cex_text)
abline(h=0)
axis(side=2,at=seq(-0.10,0.30,by=0.1),label=round(seq(-0.1,0.3,by=0.1),digits=1),cex.axis=cex_axis)
axis(side=1,at=c(2.5),labels=c(""),cex=1,pos=0,cex.axis=cex_axis)
text(x=2.5,y=y_lab_plot1,labels="TV",cex=cex_text)
#dev.off()

plot_legend_points(expectiles=model_coef$asymmetries,par_op=F,cex=1)






dev.off()





