
build_S_lambda_inv <- function(smooth_list, lambda_vec, S_temp2){
    S_lambda_list <- list()
    jj2 <- 1
    for(jj1 in 1:length(smooth_list)){
        S_lambda_temp <- 0
        for(jj3 in 1:length(smooth_list[[jj1]]$S)) {
            S_lambda_temp <- S_lambda_temp + smooth_list[[jj1]]$S[[jj3]] * lambda_vec[jj2]
            jj2 <- jj2+1
        }
        S_temp2[smooth_list[[jj1]]$first.para : smooth_list[[jj1]]$last.para, 
                smooth_list[[jj1]]$first.para : smooth_list[[jj1]]$last.para] <-
            ginv(S_lambda_temp)
    }
    S_temp2
}

build_S_lambda <- function(smooth_list, lambda_vec, S_temp2){
    S_lambda_list <- list()
    jj2 <- 1
    for(jj1 in 1:length(smooth_list)){
        S_lambda_temp <- 0
        for(jj3 in 1:length(smooth_list[[jj1]]$S)) {
            S_lambda_temp <- S_lambda_temp + smooth_list[[jj1]]$S[[jj3]] * lambda_vec[jj2]
            jj2 <- jj2+1
        }
        S_temp2[smooth_list[[jj1]]$first.para : smooth_list[[jj1]]$last.para, 
                smooth_list[[jj1]]$first.para : smooth_list[[jj1]]$last.para] <-
            (S_lambda_temp)
    }
    S_temp2
}



expectreg_bam_schall <- function(formula,data,expectiles,sm_par_vec,delta=0.01,step_max=10, dev_schall, quietly=FALSE, initial_weights) {
    #print(sm_par_vec)
    w1 <- rep(0.5,times=nrow(data))
    data$w1 <- w1
    model_temp <- bam(formula=formula, data=data, family=gaussian(),weights=w1,method="GCV.Cp",sp=sm_par_vec, fit=F)
    
    gc()
    if(!quietly) cat("0")
    
    S_temp <- matrix(0,nrow=ncol(model_temp$X),ncol=ncol(model_temp$X))
    S1 <- list()
    jj2 <- 1
    for(jj1 in 1:length(model_temp$smooth)){
        for(jj3 in 1:length(model_temp$smooth[[jj1]]$S)) {
            S1[[jj2]] <- S_temp
            S1[[jj2]][model_temp$smooth[[jj1]]$first.para : model_temp$smooth[[jj1]]$last.para, 
                      model_temp$smooth[[jj1]]$first.para : model_temp$smooth[[jj1]]$last.para] <-
                model_temp$smooth[[jj1]]$S[[jj3]]
            jj2 <- jj2+1
        }
    }
    if(!quietly) cat("0")
    smooth_list <- model_temp$smooth
    rm("model_temp")
    gc()
    
    sm_par_vec_new <- sm_par_vec
    sm_par_vec_new[] <- 0
    sm_par_vec_old <- sm_par_vec_star <- sm_par_vec_new
    deviance_model <- Inf
    iter_step <- 0
    if(!quietly) cat("\n Initial smoothing parameter: \n")
    if(!quietly) print((sm_par_vec))
    
    model2 <- expectreg_bam(formula=formula,data=data,expectiles=expectiles,sm_par_vec=sm_par_vec,quietly=quietly, initial_weights = initial_weights)
    model1 <- model2$model
    
    
    iter <- 1
    iter_step <- 0
    conv1 <- FALSE
    conv2 <- FALSE
    while(iter < 50 & !conv1 & !conv2){
        if(!quietly) cat("\n iter: ", iter, "\n")
        
        S_lambda <- S_temp
        for(j in 1:length(S1)) {
            S_lambda <- S_lambda + sm_par_vec[j] * S1[[j]]
        }
        
        beta1c <- matrix(model1$coef,ncol=1)
        
        penalty_model1 <- as.numeric(t(beta1c) %*% S_lambda %*% beta1c)
        
        deviance_model1 <- model1$deviance + penalty_model1
        
        if(dev_schall == "gcv") {
            deviance_model1 <- model1$gcv
        }
        
        XWXS1 <- model1$Vp/model1$sig2
        sm_par_vec_star[] <- 0
        Sinv <- build_S_lambda_inv(smooth_list=smooth_list, lambda_vec=sm_par_vec, S_temp2=S_temp)
            
        for(j in 1:length(sm_par_vec)) {
            aa <- sum(diag(Sinv%*%S1[[j]]))
            if(aa < 1e-15) {
                stop("ginv is 0!")
            }
            sm_par_vec_star[j] <- (aa - sum(diag(XWXS1 %*% S1[[j]])))/(t(beta1c)%*%S1[[j]]%*%beta1c)*model1$sig2 * sm_par_vec[j]
        }
        if(any(sm_par_vec_star < 0 )) stop("negative sm_par_vec")
        
        dev_crit <- FALSE
        conv3 <- FALSE
        while(iter_step <= step_max & !dev_crit & !conv3){
            if(!quietly) cat("\n iter: ", iter, " iter_step: ", iter_step, "\n")
            sm_par_vec_new <- (sm_par_vec_star - sm_par_vec) / (2^iter_step) + sm_par_vec
            if(any(sm_par_vec_new <0 )) stop("negative sm_par_vec")
            sm_par_vec_new[sm_par_vec_new > 1e+5] <- 1e+5
            sm_par_vec_new[sm_par_vec_new < 1e-5] <- 1e-5
            
            model2_new <- expectreg_bam(formula=formula, data=data, expectiles=expectiles, sm_par_vec=sm_par_vec_new, quietly=quietly, initial_weights = initial_weights)
            model1_new <- model2_new$model
            
            S_lambda_new <- S_temp
            for(j in 1:length(S1)) {
                S_lambda_new <- S_lambda_new + sm_par_vec_new[j] * S1[[j]]
            }
            
            beta1c_new <- matrix(model1_new$coef,ncol=1)
            
            penalty_model1_new <- as.numeric(t(beta1c_new) %*% S_lambda_new %*% beta1c_new)
            
            deviance_model1_new <- model1_new$deviance + penalty_model1_new
            
            if(dev_schall == "gcv") {
                deviance_model1_new <- model1_new$gcv
            }
            
            if(!quietly) {
                cat("\n New smoothing parameter: \n")
                print((sm_par_vec_new))
                cat("Old smoothing parameter: \n")
                print((sm_par_vec))
                cat("Relative Difference: \n")
                print(abs(sm_par_vec_new - sm_par_vec)/sm_par_vec)
                cat("Absolute Difference: \n")
                print(abs(sm_par_vec_new - sm_par_vec))
                cat("Difference Deviance \n")
                print(deviance_model1_new - deviance_model1)
            }
            if(dev_schall =="non" || deviance_model1_new < deviance_model1) {
                dev_crit <- TRUE
                iter_step <- 0
            } else {
                iter_step <- iter_step + 1
            }
            if(all((abs(sm_par_vec_new - sm_par_vec)/sm_par_vec < delta) | (abs(sm_par_vec_new - sm_par_vec) < delta))) {
                conv3 <- TRUE
            }  else {
                conv3 <- FALSE
            }
        }
        if(iter_step > step_max) {
            conv2 <- TRUE
        }
        
        if(!conv2){
            if(all((abs(sm_par_vec_new - sm_par_vec)/sm_par_vec < delta) | (abs(sm_par_vec_new - sm_par_vec) < delta))) {
                conv1 <- TRUE
            }  else {
                model1 <- model1_new
                sm_par_vec <- sm_par_vec_new
            }
        }
        iter <- iter + 1
    }
    
    if(iter==50) warning("Schall did not converge!")
    if(!conv3 & conv2) warning("iter_step > step_max & rel. Difference > delta")
    
    list("sm_par_vec"=sm_par_vec, "iter"=iter, "iter_step"=iter_step, 
         "conv1"=conv1, "conv2"=conv2, "conv3"=conv3)
}


expectreg_bam <- function(formula,data,expectiles,sm_par_vec,quietly, initial_weights) {
    #print(sm_par_vec)
    dw1 <- 1
    it <- 1
    w1 <- initial_weights
    data$w1 <- w1
    p <- expectiles
    #model_temp <- bam(formula=formula, data=data, family=gaussian(),weights=w1,fit=F,method="GCV.Cp",sp=sm_par_vec)
    
    for(it in 1:50) {
        if(!quietly) cat(it)
        w1 <- data$w1
        w2 <- w1
        if(!quietly) cat("i")
        model <- bam(formula=formula, data=data, family=gaussian(),weights=w1,fit=T,method="GCV.Cp",sp=sm_par_vec)
        if(!quietly) cat("I")
        z1 <- model$fitted
        w1[] = p
        w1[!(model$y > z1)] = 1-p
        data$w1 <- w1
        dw1 <- sum(w1 != w2,na.rm=TRUE) 
        if(dw1 == 0) break
        gc()
    }
    
    gcv <- model$gcv.ubre
    if(!quietly) cat("\n")
    list("model"=model, "w1"=w1, "gcv"=gcv, "expectiles"=expectiles, "it"=it, 
         "fitted"=model$fitted, "coefficients" = model$coefficients, "sm_par_vec"=sm_par_vec)
}

expectreg_bam_temp <- function(sm_par_log,formula,data,expectiles,quietly=FALSE, initial_weights, bounce_off) {
    sm_par_vec <- exp(sm_par_log)
    res <- 0
    if(any(sm_par_vec < 1e-5) | any(sm_par_vec > 1e+5)) {
        res <- 1e10 
    }
    if(!bounce_off | res < 0.9e10) { 
        model_eval <- expectreg_bam(formula=formula,data=data,expectiles=expectiles,sm_par_vec=sm_par_vec,quietly=quietly, initial_weights = initial_weights)
        res <- model_eval$gcv
    }
    res
}


expectreg_bam_smooth <- function(formula, data, expectiles, sm_par_vec, fixed = FALSE, 
                                   delta = 0.0001, step_max = 10, reltol = 1e-8,
                                   initial_w = TRUE, 
                                   opt_type=c("gcv","schall"), dev_schall = c("dev","gcv","non"),
                                   quietly=FALSE, bounce_off=FALSE){
    
    opt_type   <- match.arg(opt_type)
    dev_schall <- match.arg(dev_schall)
    
    if(!is.null(sm_par_vec) & !fixed) {
        sm_par_vec[sm_par_vec > 0.99999e+5] <- 0.99999e+5
        sm_par_vec[sm_par_vec < 1.00001e-5] <- 1.00001e-5
    }
    res <- expectreg_bam(formula=formula, data=data,expectiles=expectiles,sm_par_vec=sm_par_vec,quietly=quietly, initial_weights = rep(0.5,times=nrow(data)))
    initial_weights <- rep(0.5,times=nrow(data))
    if(initial_w) initial_weights <- res$w1
    
    if(!fixed) {
        if(!quietly) cat("\n Initial weights estimated \n")
        if(opt_type == "schall") {
            model_optim <- expectreg_bam_schall(formula=formula, data=data, expectiles=expectiles, sm_par_vec=sm_par_vec,
                                                  delta=delta, step_max=step_max, dev_schall=dev_schall, 
                                                  quietly=quietly, initial_weights = initial_weights)
            sm_par_vec <- model_optim$sm_par_vec
        }
        if(opt_type == "gcv") {
            sm_par_log <- log(sm_par_vec)
            trace1 <- 1
            if(quietly) trace1 <- 0
            model_optim <- optim(par=sm_par_log, fn=expectreg_bam_temp, 
                                     formula=formula, data=data, expectiles=expectiles, quietly = quietly, initial_weights = initial_weights, bounce_off=bounce_off,
                                     control=list("reltol"=reltol,trace=trace1))
            sm_par_log <- model_optim$par
            sm_par_vec <- exp(sm_par_log)
        }
            
        if(!quietly) cat("\n Final Smoothing Parameter: \n")
        if(!quietly) print(sm_par_vec)
        res <- expectreg_bam(formula=formula, data=data,expectiles=expectiles,sm_par_vec=sm_par_vec,quietly=quietly, initial_weights = initial_weights)
        res$model_optim <- model_optim
    }
    
    
    res   
}


