dose.p                 package:MASS                 R Documentation

_P_r_e_d_i_c_t _D_o_s_e_s _f_o_r _B_i_n_o_m_i_a_l _A_s_s_a_y _m_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Calibrate binomial assays, generalizing the calculation of LD50.

_U_s_a_g_e:

     dose.p(obj, cf=1:2, p=0.5)

_A_r_g_u_m_e_n_t_s:

     obj: A fitted model object of class inheriting from `"glm"'. 

      cf: The terms in the coefficient vector giving the intercept and
          coefficient of (log-)dose 

       p: Probabilities at which to predict the dose needed. 

_V_a_l_u_e:

     An object of class `"glm.dose"' giving the prediction and standard
     error at each response probability.

_R_e_f_e_r_e_n_c_e_s:

     Venables, W. N. and Ripley, B. D. (1999) Modern Applied Statistics
     with S-PLUS. Springer, pages 218-222.

_E_x_a_m_p_l_e_s:

     ldose <- rep(0:5, 2)
     numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
     sex <- factor(rep(c("M", "F"), c(6, 6)))
     SF <- cbind(numdead, numalive=20-numdead)
     budworm.lg0 <- glm(SF ~ sex + ldose - 1, family=binomial)

     dose.p(budworm.lg0, cf = c(1,3), p = 1:3/4)
     dose.p(update(budworm.lg0, family=binomial(link=probit)),
            cf = c(1,3), p = 1:3/4)

