glm.nb                 package:MASS                 R Documentation

_F_i_t _a _N_e_g_a_t_i_v_e _B_i_n_o_m_i_a_l _G_e_n_e_r_a_l_i_z_e_d _L_i_n_e_a_r _M_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     A modification of the system function `glm()' to include
     estimation of the additional parameter, `theta', for a Negative
     Binomial generalized linear model.

_U_s_a_g_e:

     glm.nb(formula, ...,  init.theta, link=log)

_A_r_g_u_m_e_n_t_s:

 formula: Model formula, as for `glm()'. 

     ...: Any other arguments for the `glm()' function except `family'. 

init.theta: Optional initial value for the theta parameter.  If omitted
          a moment estimator after an initial fit using a Poisson GLM
          is used. 

    link: The link function.  Currently must be one of `log', `sqrt' or
          `identity'. 

_D_e_t_a_i_l_s:

     An alternating iteration process is used.  For given `theta' the
     GLM is fitted using the same process as used by `glm()'.  For
     fixed means the `theta' parameter is estimated using score and
     information iterations.  The two are alternated until convergence
     of both. (The number of alternations and the number of iterations
     when estimating `theta' are controlled by the `maxit' parameter of
     `glm.control'.)

     Setting `trace > 0' traces the alternating iteration process.
     Setting `trace > 1' traces the `glm' fit, and setting `trace > 2'
     traces the estimation of `theta'.

_V_a_l_u_e:

     A fitted model object of class `negbin' inheriting from `glm' and
     `lm'. The object is like the output of `glm' but contains three
     additional components, namely `theta' for the ML estimate of
     theta, `SE.theta' for its approximate standard error (using
     observed rather than expected information), and `twologlik' for
     twice the log-likelihood function.

_S_e_e _A_l_s_o:

     `glm', `negative.binomial', `anova.negbin', `summary.negbin',
     `theta.ml', `theta.md', `theta.mm'

_E_x_a_m_p_l_e_s:

     data(quine)
     quine.nb1 <- glm.nb(Days ~ Sex/(Age + Eth*Lrn), data=quine)
     quine.nb2 <- update(quine.nb1, . ~ . + Sex:Age:Lrn)
     quine.nb3 <- update(quine.nb2, Days ~ .^4)
     anova(quine.nb1, quine.nb2, quine.nb3)

