###--- >>> `addterm' <<<----- Try All One-Term Additions to a Model

	## alias	 help(addterm)
	## alias	 help(addterm.default)
	## alias	 help(addterm.glm)
	## alias	 help(addterm.lm)
	## alias	 help(addterm.mlm)
	## alias	 help(addterm.negbin)
	## alias	 help(addterm.survreg)

##___ Examples ___:

data(quine)
quine.hi <- aov(log(Days + 2.5) ~ .^4, quine)
quine.lo <- aov(log(Days+2.5) ~ 1, quine)
addterm(quine.lo, quine.hi, test="F")

data(housing)
house.glm0 <- glm(Freq ~ Infl*Type*Cont + Sat, family=poisson, 
                   data=housing)
addterm(house.glm0, ~. + Sat:(Infl+Type+Cont), test="Chisq")
house.glm1 <- update(house.glm0, . ~ . + Sat*(Infl+Type+Cont))
addterm(house.glm1, ~. + Sat:(Infl+Type+Cont)^2, test = "Chisq")

## Keywords: 'models'.


