###--- >>> `beav2' <<<----- Body Temperature Series of Beaver 2

	## alias	 help(beav2)

##___ Examples ___:

library(ts)
data(beav2)
attach(beav2)
beav2$hours <- 24*(day-307) + trunc(time/100) + (time%%100)/60
plot(beav2$hours, beav2$temp, type="l", xlab="time", 
   ylab="temperature", main="Beaver 2")
usr <- par("usr"); usr[3:4] <- c(-0.2, 8); par(usr=usr)
lines(beav2$hours, beav2$activ, type="s", lty=2)

temp <- ts(temp, start=8+2/3, frequency=6)
activ <- ts(activ, start=8+2/3, frequency=6)
acf(temp[activ==0]); acf(temp[activ==1]) # also look at PACFs
ar(temp[activ==0]); ar(temp[activ==1])

arima0(temp, order=c(1,0,0))
arima0(temp, order=c(1,0,0), xreg=activ)
dreg <- cbind(sin=sin(2*pi*beav2$hours/24), cos=cos(2*pi*beav2$hours/24))
arima0(temp, order=c(1,0,0), xreg=cbind(active=activ,dreg))

library(nlme)
beav2.gls <- gls(temp ~ activ, data=beav2,  corr=corAR1(0.8), method="ML")
summary(beav2.gls)
summary(update(beav2.gls, subset=6:100))
detach("beav2"); rm(temp, activ)

## Keywords: 'datasets'.


