###--- >>> `dose.p' <<<----- Predict Doses for Binomial Assay model

	## alias	 help(dose.p)
	## alias	 help(print.glm.dose)

##___ Examples ___:

ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive=20-numdead)
budworm.lg0 <- glm(SF ~ sex + ldose - 1, family=binomial)

dose.p(budworm.lg0, cf = c(1,3), p = 1:3/4)
dose.p(update(budworm.lg0, family=binomial(link=probit)),
       cf = c(1,3), p = 1:3/4)

## Keywords: 'regression', 'models'.


