###--- >>> `dropterm' <<<----- Try All One-Term Deletions from a Model

	## alias	 help(dropterm)
	## alias	 help(dropterm.default)
	## alias	 help(dropterm.glm)
	## alias	 help(dropterm.lm)
	## alias	 help(dropterm.mlm)
	## alias	 help(dropterm.negbin)
	## alias	 help(dropterm.survreg)

##___ Examples ___:

data(quine)
quine.hi <- aov(log(Days + 2.5) ~ .^4, quine)
quine.nxt <- update(quine.hi, . ~ . - Eth:Sex:Age:Lrn)
dropterm(quine.nxt, test="F")
quine.stp <- stepAIC(quine.nxt, 
    scope = list(upper = ~Eth*Sex*Age*Lrn, lower = ~1), 
    trace = FALSE)
dropterm(quine.stp, test="F")
quine.3 <- update(quine.stp, . ~ . - Eth:Age:Lrn)
dropterm(quine.3, test="F")
quine.4 <- update(quine.3, . ~ . - Eth:Age)
dropterm(quine.4, test="F")
quine.5 <- update(quine.4, . ~ . - Age:Lrn)
dropterm(quine.5, test="F")

data(housing)
house.glm0 <- glm(Freq ~ Infl*Type*Cont + Sat, family=poisson, 
                   data=housing)
house.glm1 <- update(house.glm0, . ~ . + Sat*(Infl+Type+Cont))
dropterm(house.glm1, test="Chisq")

## Keywords: 'models'.


