###--- >>> `stepAIC' <<<----- Choose a model by AIC in a Stepwise Algorithm

	## alias	 help(stepAIC)
	## alias	 help(extractAIC)

##___ Examples ___:

data(quine)
quine.hi <- aov(log(Days + 2.5) ~ .^4, quine)
quine.nxt <- update(quine.hi, . ~ . - Eth:Sex:Age:Lrn)
quine.stp <- stepAIC(quine.nxt, 
    scope = list(upper = ~Eth*Sex*Age*Lrn, lower = ~1), 
    trace = FALSE)
quine.stp$anova

data(cpus)
cpus1 <- cpus
attach(cpus)
for(v in names(cpus)[2:7]) 
  cpus1[[v]] <- cut(cpus[[v]], unique(quantile(cpus[[v]])), 
                    include.lowest = TRUE)
detach()
cpus0 <- cpus1[, 2:8]  # excludes names, authors' predictions
cpus.samp <- sample(1:209, 100)
cpus.lm <- lm(log10(perf) ~ ., data=cpus1[cpus.samp,2:8])
cpus.lm2 <- stepAIC(cpus.lm, trace=FALSE)
cpus.lm2$anova

example(birthwt)
birthwt.glm <- glm(low ~ ., family=binomial, data=bwt)
birthwt.step <- stepAIC(birthwt.glm, trace=FALSE)
birthwt.step$anova
birthwt.step2 <- stepAIC(birthwt.glm, ~ .^2 + I(scale(age)^2)
    + I(scale(lwt)^2), trace=FALSE)
birthwt.step2$anova

quine.nb <- glm.nb(Days ~ .^4, data=quine)
quine.nb2 <- stepAIC(quine.nb)
quine.nb2$anova

## Keywords: 'models'.


