###--- >>> `predict.nnet' <<<----- Predict New Examples by a Trained Neural Net

	## alias	 help(predict.nnet)

##___ Examples ___:

data(iris3)
# use half the iris data
ir <- rbind(iris3[,,1],iris3[,,2],iris3[,,3])
targets <- class.ind( c(rep("s", 50), rep("c", 50), rep("v", 50)) )
samp <- c(sample(1:50,25), sample(51:100,25), sample(101:150,25))
ir1 <- nnet(ir[samp,], targets[samp,],size=2, rang=0.1,
            decay=5e-4, maxit=200)
test.cl <- function(true, pred){
        true <- max.col(true)
        cres <- max.col(pred)
        table(true, cres)
}
test.cl(targets[-samp,], predict(ir1, ir[-samp,]))

# or
ird <- data.frame(rbind(iris3[,,1], iris3[,,2], iris3[,,3]),
        species=c(rep("s",50), rep("c", 50), rep("v", 50)))
ir.nn2 <- nnet(species ~ ., data=ird, subset=samp, size=2, rang=0.1, 
            decay=5e-4, maxit=200)
table(ird$species[-samp], predict(ir.nn2, ird[-samp,], type="class"))

## Keywords: 'neural'.


