/*Autor: Ylva Brandt, Februar 2023
Dieses Werk ist lizenziert unter einer Creative Commons Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz (http://creativecommons.org/licenses/by-nc-sa/4.0/).
*/
int[][] parameter = new int[15][3]; //zweidimensionale Reihung; Spalte 0: xKoordinaten, Spalte 1: yKoordinaten; Spalte 2: Drehwinkel

void setup(){
 size(400, 300);
 background(0, 100, 255);
 frameRate(10);
 //Zufällige Werte für Koordinaten und Drehwinkel
 for(int i = 0; i < parameter.length; i++){
   parameter[i][0] = (int)random(30, width-30);
   parameter[i][1] = (int)random(30, height-60);
   parameter[i][2] = (int)random(0, 360);
 }
}

void draw(){
  background(0, 100, 255);
  for(int i = 0; i < parameter.length; i++){
    //Drehwinkel um 10 Grad ändern
    parameter[i][2] = (parameter[i][2] + 10) % 360;
    windmuehleZeichnen(parameter[i][0], parameter[i][1], parameter[i][2]);
  }
}

void windmuehleZeichnen(int x, int y, int winkel){
 float w = (winkel * 2 * PI) / 360;
 float w2 = w + PI/4;
  
 //Stiel
 stroke(0, 255, 0);
 strokeWeight(5);
 line(x, y, x, y + 60);

 //Flügel
 noStroke();
 fill(255, 0, 0);
 triangle(x, y, x + 30 * sin(0+w), y + 30 * cos(0+w), x + 15 * sin(0+w2), y + 15 * cos(0+w2)); 
 fill(255, 255, 0);
 triangle(x, y, x + 30 * sin(PI/2+w), y + 30 * cos(PI/2+w), x + 15 * sin(PI/2+w2), y + 15 * cos(PI/2+w2)); 
 fill(255, 0, 255);
 triangle(x, y, x + 30 * sin(PI+w), y + 30 * cos(PI+w), x + 15 * sin(PI+w2), y + 15 * cos(PI+w2)); 
 fill(0, 255, 255);
 triangle(x, y, x + 30 * sin(3*PI/2+w), y + 30 * cos(3*PI/2+w), x + 15 * sin(3*PI/2+w2), y + 15 * cos(3*PI/2+w2)); 
 //Kreis innen
 strokeWeight(2);
 stroke(0, 0, 0);
 fill(255, 150, 0);
 circle(x, y, 10);
}
